/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Box;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwindx.examples.ApplicationTemplate;

public class Boxes
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Boxes", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setInteriorOpacity(0.7);
            basicShapeAttributes.setEnableLighting(true);
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setDrawOutline(false);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
            basicShapeAttributes2.setInteriorMaterial(Material.PINK);
            basicShapeAttributes2.setInteriorOpacity(1.0);
            basicShapeAttributes2.setEnableLighting(true);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineWidth(2.0);
            basicShapeAttributes2.setDrawOutline(false);
            Box box = new Box(Position.fromDegrees(40.0, -120.0, 80000.0), 50000.0, 50000.0, 50000.0);
            box.setAltitudeMode(0);
            box.setAttributes(basicShapeAttributes);
            box.setVisible(true);
            box.setValue("gov.nasa.worldwind.avkey.DisplayName", "Box with equal axes, ABSOLUTE altitude mode");
            renderableLayer.addRenderable(box);
            Box box2 = new Box(Position.fromDegrees(37.5, -115.0, 50000.0), 50000.0, 50000.0, 50000.0);
            box2.setAltitudeMode(2);
            box2.setAttributes(basicShapeAttributes);
            box2.setVisible(true);
            box2.setValue("gov.nasa.worldwind.avkey.DisplayName", "Box with equal axes, RELATIVE_TO_GROUND altitude mode");
            renderableLayer.addRenderable(box2);
            Box box3 = new Box(Position.fromDegrees(35.0, -110.0, 50000.0), 50000.0, 50000.0, 50000.0);
            box3.setAltitudeMode(1);
            box3.setAttributes(basicShapeAttributes);
            box3.setVisible(true);
            box3.setValue("gov.nasa.worldwind.avkey.DisplayName", "Box with equal axes, CLAMP_TO_GROUND altitude mode");
            renderableLayer.addRenderable(box3);
            Box box4 = new Box(Position.fromDegrees(0.0, -90.0, 600000.0), 600000.0, 600000.0, 600000.0);
            box4.setAltitudeMode(2);
            box4.setImageSources("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            box4.setAttributes(basicShapeAttributes);
            box4.setVisible(true);
            box4.setValue("gov.nasa.worldwind.avkey.DisplayName", "Box with a texture");
            renderableLayer.addRenderable(box4);
            Box box5 = new Box(Position.ZERO, 1000000.0, 500000.0, 100000.0);
            box5.setAltitudeMode(0);
            box5.setAttributes(basicShapeAttributes);
            box5.setVisible(true);
            box5.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Box with default orientation");
            renderableLayer.addRenderable(box5);
            Box box6 = new Box(Position.fromDegrees(0.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            box6.setAltitudeMode(2);
            box6.setAttributes(basicShapeAttributes2);
            box6.setVisible(true);
            box6.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Box with a pre-set orientation");
            renderableLayer.addRenderable(box6);
            Box box7 = new Box(Position.fromDegrees(30.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            box7.setAltitudeMode(2);
            box7.setImageSources("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            box7.setAttributes(basicShapeAttributes2);
            box7.setVisible(true);
            box7.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Box with a pre-set orientation");
            renderableLayer.addRenderable(box7);
            Box box8 = new Box(Position.fromDegrees(60.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            box8.setAltitudeMode(2);
            box8.setAttributes(basicShapeAttributes2);
            box8.setVisible(true);
            box8.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Box with a pre-set orientation");
            renderableLayer.addRenderable(box8);
            Box box9 = new Box(Position.fromDegrees(-45.0, -180.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            box9.setAltitudeMode(2);
            box9.setAttributes(basicShapeAttributes2);
            box9.setVisible(true);
            box9.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled, oriented Box in the 3rd 'quadrant' (-X, -Y, -Z)");
            renderableLayer.addRenderable(box9);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

