/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import com.jogamp.opengl.util.Animator;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import javax.media.opengl.GLAutoDrawable;

public class AnimatedGlobe
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Animated Globe", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame
    implements RenderingListener {
        Animator animator;
        double rotationRate = 100.0;
        long lastTime;
        Position eyePosition = Position.fromDegrees(0.0, 0.0, 2.0E7);

        public AppFrame() {
            this.getWwd().getModel().getGlobe().getTessellator().setUpdateFrequency(5000L);
            this.getWwd().addRenderingListener(this);
            this.lastTime = System.currentTimeMillis();
            this.animator = new Animator();
            this.animator.add((GLAutoDrawable)((WorldWindowGLCanvas)this.getWwd()));
            this.animator.start();
        }

        @Override
        public void stageChanged(RenderingEvent renderingEvent) {
            if (renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.BeforeRendering")) {
                if (this.getWwd().getView().getGlobe() == null) {
                    return;
                }
                long l = System.currentTimeMillis();
                double d = this.rotationRate * (double)(l - this.lastTime) * 0.001;
                this.lastTime = l;
                double d2 = this.eyePosition.getLongitude().degrees;
                if ((d2 += d) > 180.0) {
                    d2 = -180.0 + (180.0 - d2);
                }
                this.eyePosition = Position.fromDegrees(this.eyePosition.getLatitude().degrees, d2, this.eyePosition.getAltitude());
                Position position = new Position(this.eyePosition.getLatitude(), this.eyePosition.getLongitude(), 0.0);
                this.getWwd().getView().setOrientation(this.eyePosition, position);
            }
        }
    }
}

