/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.exception.NoItemException;
import gov.nasa.worldwind.poi.Gazetteer;
import gov.nasa.worldwind.poi.PointOfInterest;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.ImageLibrary;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.features.FeaturePanel;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

public class GazetteerPanel
extends AbstractFeature
implements FeaturePanel {
    private JPanel panel = new JPanel(new BorderLayout());
    private Gazetteer gazetteer;

    public GazetteerPanel(Registry registry) {
        super("Gazetteer Panel", "gov.nasa.worldwindx.applications.worldwindow.feature.GazetteerPanel", registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.gazetteer = this.getGazetteer();
        this.panel.setOpaque(false);
        this.createComponents(this.panel);
    }

    @Override
    public JPanel getJPanel() {
        return this.panel;
    }

    @Override
    public JComponent[] getDialogControls() {
        return null;
    }

    private Gazetteer getGazetteer() {
        if (this.gazetteer != null) {
            return this.gazetteer;
        }
        Object object = this.controller.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.feature.Gazetteer");
        return object instanceof Gazetteer ? (Gazetteer)object : null;
    }

    private void createComponents(JPanel jPanel) {
        String string = "Any of these:  45.5 -120.2   or   45 30 0 n 120 12 0 w   or   Seattle";
        JComboBox jComboBox = new JComboBox();
        jComboBox.setOpaque(false);
        jComboBox.setEditable(true);
        jComboBox.setLightWeightPopupEnabled(false);
        jComboBox.setPreferredSize(new Dimension(200, jComboBox.getPreferredSize().height));
        jComboBox.setToolTipText(string);
        JLabel jLabel = new JLabel(ImageLibrary.getIcon("gov/nasa/worldwindx/applications/worldwindow/images/safari-24x24.png"));
        jLabel.setOpaque(false);
        jLabel.setToolTipText(string);
        jPanel.add((Component)jLabel, "West");
        jPanel.add(jComboBox, "Center");
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GazetteerPanel.this.performGazeteerAction(actionEvent);
            }
        });
    }

    private void performGazeteerAction(final ActionEvent actionEvent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    GazetteerPanel.this.handleEntryAction(actionEvent);
                }
                catch (NoItemException noItemException) {
                    GazetteerPanel.this.controller.showMessageDialog("No search string was specified", "No Search String", 0);
                }
                catch (Exception exception) {
                    GazetteerPanel.this.controller.showMessageDialog("Location not found", "Location Unknown", 0);
                }
            }
        });
    }

    private void handleEntryAction(ActionEvent actionEvent) throws IOException, ParserConfigurationException, XPathExpressionException, SAXException, NoItemException {
        if (this.getGazetteer() == null) {
            Util.getLogger().severe("No gazeteer is registered");
            return;
        }
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        String string = jComboBox.getSelectedItem().toString();
        if (string == null || string.length() < 1) {
            return;
        }
        List<PointOfInterest> list = this.gazetteer.findPlaces(string);
        if (list == null || list.size() == 0) {
            return;
        }
        this.controller.moveToLocation(list.get(0));
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            Object e = jComboBox.getItemAt(i);
            if (e == null || !e.toString().trim().equals(string)) continue;
            return;
        }
        jComboBox.insertItemAt(string, 0);
    }
}

