/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.data.BasicDataRasterReaderFactory;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWXML;
import java.io.File;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;

public class DataImportUtil {
    public static boolean isDataRaster(Object object, AVList aVList) {
        DataRasterReaderFactory dataRasterReaderFactory;
        if (object == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            dataRasterReaderFactory = (DataRasterReaderFactory)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.DataRasterReaderFactoryClassName");
        }
        catch (Exception exception) {
            dataRasterReaderFactory = new BasicDataRasterReaderFactory();
        }
        aVList = null == aVList ? new AVListImpl() : aVList;
        DataRasterReader dataRasterReader = dataRasterReaderFactory.findReaderFor(object, aVList);
        if (dataRasterReader == null) {
            return false;
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            try {
                dataRasterReader.readMetadata(object, aVList);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileReading", exception.getMessage());
                Logging.logger().finest(string);
            }
        }
        return "gov.nasa.worldwind.avkey.Image".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat")) || "gov.nasa.worldwind.avkey.Elevation".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWWDotNetLayerSet(Object object) {
        Object object2;
        if (object == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = WWIO.getSourcePath(object);
        if (string != null && (object2 = WWIO.getSuffix(string)) != null && !((String)object2).toLowerCase().endsWith("xml")) {
            return false;
        }
        object2 = null;
        try {
            object2 = WWXML.openEventReader(object);
            StartElement startElement = WWXML.nextStartElementEvent((XMLEventReader)object2);
            boolean bl = startElement != null && DataConfigurationUtils.isWWDotNetLayerSetConfigEvent(startElement);
            return bl;
        }
        catch (Exception exception) {
            Logging.logger().fine(Logging.getMessage("generic.ExceptionAttemptingToParseXml", object));
            boolean bl = false;
            return bl;
        }
        finally {
            WWXML.closeEventReader((XMLEventReader)object2, object.toString());
        }
    }

    public static File getDefaultImportLocation(FileStore fileStore) {
        if (fileStore == null) {
            String string = Logging.getMessage("nullValue.FileStoreIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (File file : fileStore.getLocations()) {
            if (!fileStore.isInstallLocation(file.getPath())) continue;
            return file;
        }
        return fileStore.getWriteLocation();
    }
}

