/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwindx.applications.worldwindow.core.AppFrame;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.MenuBar;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.StatusPanel;
import gov.nasa.worldwindx.applications.worldwindow.core.ToolBar;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.logging.Level;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;

public class AppFrameImpl
extends AbstractFeature
implements AppFrame {
    protected JFrame frame;
    protected JApplet applet;

    public AppFrameImpl(Registry registry) {
        super("App Frame", "gov.nasa.worldwindx.applications.worldwindow.AppFrame", registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.applet = (JApplet)this.controller.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.AppletPanel");
        if (this.applet != null) {
            this.initializeApplet(this.applet);
        } else {
            this.initializeApp();
        }
    }

    protected void initializeApp() {
        try {
            MenuBar menuBar;
            StatusPanel statusPanel;
            this.frame = new JFrame();
            this.frame.setTitle(this.controller.getAppTitle());
            this.frame.getContentPane().add((Component)this.controller.getAppPanel().getJPanel(), "Center");
            ToolBar toolBar = this.controller.getToolBar();
            if (toolBar != null) {
                this.frame.add((Component)toolBar.getJToolBar(), "First");
            }
            if ((statusPanel = this.controller.getStatusPanel()) != null) {
                this.frame.add((Component)statusPanel.getJPanel(), "Last");
            }
            if ((menuBar = this.controller.getMenuBar()) != null) {
                this.frame.setJMenuBar(menuBar.getJMenuBar());
            }
            this.frame.pack();
            ToolTipManager.sharedInstance().setDismissDelay(60000);
            Dimension dimension = this.frame.getPreferredSize();
            Point point = new Point(0, 0);
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = point.x + (dimension2.width - dimension.width) / 2;
            int n2 = point.y + (dimension2.height - dimension.height) / 2;
            this.frame.setLocation(n, n2);
            this.frame.setResizable(true);
            this.frame.setDefaultCloseOperation(3);
            this.frame.setVisible(true);
        }
        catch (Exception exception) {
            String string = "Unable to initialize the application.";
            Util.getLogger().log(Level.SEVERE, string, exception);
            this.controller.showErrorDialogLater(null, "Initialization Error", string, new Object[0]);
        }
    }

    protected void initializeApplet(JApplet jApplet) {
        jApplet.getContentPane().add((Component)this.controller.getAppPanel().getJPanel(), "Center");
        jApplet.add((Component)this.controller.getToolBar().getJToolBar(), "First");
    }

    @Override
    public Frame getFrame() {
        return this.frame != null ? this.frame : Util.findParentFrame(this.applet);
    }
}

