/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar.render;

import com.jogamp.opengl.util.awt.TextRenderer;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.MultiLineTextRenderer;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.sar.SARPosition;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.media.opengl.GL2;

public class TrackSegmentInfo
implements Renderable {
    protected boolean enabled;
    protected SARTrack track;
    protected int segmentIndex;
    protected Position segmentPosition;
    protected Object angleFormat;
    protected Object elevationUnit;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public SARTrack getTrack() {
        return this.track;
    }

    public void setTrack(SARTrack sARTrack) {
        this.track = sARTrack;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public void setSegmentIndex(int n) {
        this.segmentIndex = n;
    }

    public Position getSegmentPosition() {
        return this.segmentPosition;
    }

    public void setSegmentPosition(Position position) {
        this.segmentPosition = position;
    }

    public Object getAngleFormat() {
        return this.angleFormat;
    }

    public void setAngleFormat(Object object) {
        this.angleFormat = object;
    }

    public Object getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(Object object) {
        this.elevationUnit = object;
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isEnabled()) {
            return;
        }
        this.doRender(drawContext);
    }

    protected void doRender(DrawContext drawContext) {
        if (this.track == null) {
            return;
        }
        if (this.segmentIndex < 0 || this.segmentIndex >= this.track.size()) {
            return;
        }
        this.drawSegmentLabel(drawContext, this.track, this.segmentIndex);
        if (this.segmentIndex < this.track.size() - 1) {
            this.drawSegmentLabel(drawContext, this.track, this.segmentIndex + 1);
        }
        if (this.segmentPosition != null) {
            this.drawSegmentPositionLabel(drawContext, this.track, this.segmentIndex, this.segmentPosition);
        }
    }

    protected void drawSegmentLabel(DrawContext drawContext, SARTrack sARTrack, int n) {
        SARPosition sARPosition = sARTrack.get(n);
        Vec4 vec4 = this.getScreenPoint(drawContext, sARPosition);
        this.drawLatLonLabel(drawContext, (int)vec4.x, (int)vec4.y, Font.decode("Arial-BOLD-12"), WWUtil.makeColorBrighter(sARTrack.getColor()), sARPosition);
    }

    protected Vec4 getScreenPoint(DrawContext drawContext, Position position) {
        if (drawContext.getGlobe() == null || drawContext.getView() == null) {
            return null;
        }
        Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), position.getElevation());
        if (vec4 == null) {
            return null;
        }
        return drawContext.getView().project(vec4);
    }

    protected void drawSegmentPositionLabel(DrawContext drawContext, SARTrack sARTrack, int n, Position position) {
        Angle angle = null;
        if (n < sARTrack.size() - 1) {
            angle = LatLon.rhumbAzimuth(sARTrack.get(n), sARTrack.get(n + 1));
        } else if (n > 0) {
            angle = LatLon.rhumbAzimuth(sARTrack.get(n - 1), sARTrack.get(n));
        }
        Vec4 vec4 = this.getScreenPoint(drawContext, position);
        this.drawHeadingAltitudeLabel(drawContext, (int)vec4.x, (int)vec4.y, Font.decode("Arial-BOLD-12"), Color.YELLOW, angle, position);
    }

    protected void drawHeadingAltitudeLabel(DrawContext drawContext, int n, int n2, Font font, Color color, Angle angle, Position position) {
        double d = this.computeSurfaceElevation(drawContext, position.getLatitude(), position.getLongitude());
        double d2 = drawContext.getView().getEyePoint().distanceTo3(drawContext.getGlobe().computePointFromPosition(position));
        StringBuilder stringBuilder = new StringBuilder();
        if (angle != null) {
            stringBuilder.append("Heading: ");
            stringBuilder.append(angle.toDecimalDegreesString(0));
            stringBuilder.append("\n");
        }
        stringBuilder.append("Alt: ");
        stringBuilder.append(this.formatAltitude(position.getElevation()));
        stringBuilder.append("\n");
        stringBuilder.append("AGL: ");
        stringBuilder.append(this.formatAltitude(position.getElevation() - d));
        this.drawText(drawContext, stringBuilder.toString(), n, n2, font, color, d2);
    }

    protected void drawLatLonLabel(DrawContext drawContext, int n, int n2, Font font, Color color, Position position) {
        double d = drawContext.getView().getEyePoint().distanceTo3(drawContext.getGlobe().computePointFromPosition(position));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.formatAngle(position.getLatitude()));
        stringBuilder.append(", ");
        stringBuilder.append(this.formatAngle(position.getLongitude()));
        stringBuilder.append(")");
        this.drawText(drawContext, stringBuilder.toString(), n, n2, font, color, d);
    }

    protected void drawText(DrawContext drawContext, String string, int n, int n2, Font font, Color color, double d) {
        drawContext.addOrderedRenderable(new OrderedText(string, n, n2, font, color, d));
    }

    protected double computeSurfaceElevation(DrawContext drawContext, Angle angle, Angle angle2) {
        Vec4 vec4;
        if (drawContext.getSurfaceGeometry() != null && (vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(angle, angle2)) != null) {
            Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
            return position.getElevation();
        }
        return drawContext.getGlobe().getElevation(angle, angle2);
    }

    protected String formatAngle(Angle angle) {
        return "gov.nasa.worldwind.Geom.AngleDMS".equals(this.angleFormat) ? angle.toDMSString() : angle.toDecimalDegreesString(4);
    }

    protected String formatAltitude(double d) {
        return "Imperial".equals(this.elevationUnit) ? String.format("%d ft", (long)WWMath.convertMetersToFeet(d)) : String.format("%d m", (long)d);
    }

    protected static class OrderedText
    implements OrderedRenderable {
        private final String text;
        private final int x;
        private final int y;
        private final Font font;
        private final Color color;
        private final double distanceFromEye;

        public OrderedText(String string, int n, int n2, Font font, Color color, double d) {
            this.text = string;
            this.x = n;
            this.y = n2;
            this.font = font;
            this.color = color;
            this.distanceFromEye = d;
        }

        @Override
        public double getDistanceFromEye() {
            return this.distanceFromEye;
        }

        @Override
        public void render(DrawContext drawContext) {
            this.drawText(drawContext, this.text, this.x, this.y, this.font, this.color);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void drawText(DrawContext drawContext, String string, int n, int n2, Font font, Color color) {
            GL2 gL2 = drawContext.getGL().getGL2();
            Rectangle rectangle = drawContext.getView().getViewport();
            OGLStackHandler oGLStackHandler = new OGLStackHandler();
            oGLStackHandler.pushAttrib(gL2, 1);
            try {
                MultiLineTextRenderer multiLineTextRenderer = this.getTextRendererFor(drawContext, font);
                multiLineTextRenderer.setTextAlign("gov.nasa.worldwind.avkey.Center");
                multiLineTextRenderer.getTextRenderer().beginRendering(rectangle.width, rectangle.height);
                try {
                    multiLineTextRenderer.setTextColor(color);
                    multiLineTextRenderer.setBackColor(Color.BLACK);
                    Rectangle rectangle2 = multiLineTextRenderer.getBounds(string);
                    multiLineTextRenderer.draw(string, n, n2 + 3 * rectangle2.height / 2, "gov.nasa.worldwind.avkey.TextEffectOutline");
                }
                finally {
                    multiLineTextRenderer.getTextRenderer().endRendering();
                }
            }
            finally {
                oGLStackHandler.pop(gL2);
            }
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
        }

        protected MultiLineTextRenderer getTextRendererFor(DrawContext drawContext, Font font) {
            TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
            return new MultiLineTextRenderer(textRenderer);
        }
    }
}

