/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.CrosshairLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.ScalebarLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwindx.applications.sar.render.PlaneModel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ViewMenu
extends JMenu {
    private WorldWindow wwd;

    public ViewMenu() {
        super("View");
    }

    public void setWwd(WorldWindow worldWindow) {
        this.wwd = worldWindow;
        for (Layer layer : this.wwd.getModel().getLayers()) {
            if (!this.isAbstractLayerMenuItem(layer)) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new LayerVisibilityAction(this.wwd, layer));
            jCheckBoxMenuItem.setState(layer.isEnabled());
            this.add(jCheckBoxMenuItem);
        }
        Object object = new JMenuItem("Terrain profile...");
        ((AbstractButton)object).setMnemonic('T');
        ((JMenuItem)object).setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewMenu.this.wwd.firePropertyChange("TerrainProfilePanel.Open", null, null);
            }
        });
        this.add((JMenuItem)object);
        object = new JMenuItem("Cloud Contour...");
        ((AbstractButton)object).setMnemonic('C');
        ((JMenuItem)object).setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewMenu.this.wwd.firePropertyChange("CloudCeilingPanel.CloudCeilingOpen", null, null);
            }
        });
        this.add((JMenuItem)object);
    }

    private boolean isAbstractLayerMenuItem(Layer layer) {
        if (layer instanceof RenderableLayer) {
            Iterable<Renderable> iterable = ((RenderableLayer)layer).getRenderables();
            for (Renderable renderable : iterable) {
                if (!(renderable instanceof PlaneModel)) continue;
                return true;
            }
        }
        return layer instanceof ScalebarLayer || layer instanceof CrosshairLayer || layer instanceof CompassLayer;
    }

    private static class LayerVisibilityAction
    extends AbstractAction {
        private final Layer layer;
        private final WorldWindow wwd;

        public LayerVisibilityAction(WorldWindow worldWindow, Layer layer) {
            super(layer.getName());
            this.layer = layer;
            this.wwd = worldWindow;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.layer.setEnabled(((JCheckBoxMenuItem)actionEvent.getSource()).getState());
            this.wwd.redraw();
        }
    }
}

