/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwindx.applications.sar.PositionTable;
import gov.nasa.worldwindx.applications.sar.PositionsContextMenu;
import gov.nasa.worldwindx.applications.sar.SAR2;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TrackPanel
extends JPanel {
    private String elevationUnit;
    private String angleFormat;
    private JCheckBox visibilityFlag;
    private JScrollPane scrollPane;
    private PositionTable positionTable;
    private JCheckBox offsetToggleCheckBox;
    private JSpinner offsetSpinner;
    private JLabel offsetUnitLabel;

    public TrackPanel() {
        this.initComponents();
        this.layoutComponents();
        this.scrollPane.addMouseListener(new PositionsContextMenu(this.positionTable));
        this.positionTable.addMouseListener(new PositionsContextMenu(this.positionTable));
    }

    public void setTrack(SARTrack sARTrack) {
        this.positionTable.setSarTrack(sARTrack);
    }

    public SARTrack getTrack() {
        return this.positionTable.getSarTrack();
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        String string2 = this.elevationUnit;
        this.elevationUnit = string;
        this.positionTable.setElevationUnit(string);
        this.positionTable.updateTableData();
        this.changeOffsetUnit(string2, this.elevationUnit);
    }

    public String getAngleFormat() {
        return this.angleFormat;
    }

    public void setAngleFormat(String string) {
        this.angleFormat = string;
        this.positionTable.setAngleFormat(string);
        this.positionTable.updateTableData();
    }

    private void visibilityActionPerformed(ActionEvent actionEvent) {
        String string = this.visibilityFlag.isSelected() ? "TrackController.TrackEnabled" : "TrackController.TrackDisabled";
        this.positionTable.getSarTrack().firePropertyChange(string, null, this.positionTable.getSarTrack());
    }

    private void nextTrackPositionActionPerformed(ActionEvent actionEvent) {
        this.positionTable.getSarTrack().firePropertyChange("TrackController.MoveToNextPoint", null, this.positionTable.getSarTrack());
    }

    private void removeTrackPositionActionPerformed(ActionEvent actionEvent) {
        this.positionTable.getSarTrack().firePropertyChange("TrackController.RemoveLastPoint", null, this.positionTable.getSarTrack());
    }

    private void offsetSpinnerStateChanged(ChangeEvent changeEvent) {
        this.applyTrackOffset(this.parseOffsetInput());
    }

    private void offsetToggleCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.offsetSpinner.setEnabled(this.offsetToggleCheckBox.isSelected());
        double d = this.offsetToggleCheckBox.isSelected() ? this.parseOffsetInput() : 0.0;
        this.applyTrackOffset(d);
    }

    private double parseOffsetInput() {
        return ((SpinnerNumberModel)this.offsetSpinner.getModel()).getNumber().doubleValue();
    }

    private void applyTrackOffset(double d) {
        double d2 = "Imperial".equals(this.elevationUnit) ? SAR2.feetToMeters(d) : d;
        this.positionTable.getSarTrack().setOffset(d2);
        this.positionTable.getSarTrack().firePropertyChange("TrackController.TrackModified", null, this.positionTable.getSarTrack());
    }

    private void changeOffsetUnit(String string, String string2) {
        SpinnerNumberModel spinnerNumberModel;
        if (string2.equals(string)) {
            return;
        }
        double d = this.parseOffsetInput();
        if ("Imperial".equals(string2)) {
            d = SAR2.metersToFeet(d);
            this.offsetUnitLabel.setText("ft");
            spinnerNumberModel = new SpinnerNumberModel((int)d, -100000, 100000, 100);
        } else {
            d = SAR2.feetToMeters(d);
            this.offsetUnitLabel.setText("m");
            spinnerNumberModel = new SpinnerNumberModel((int)d, -100000, 100000, 100);
        }
        this.offsetSpinner.setModel(spinnerNumberModel);
    }

    private void initComponents() {
        this.setToolTipText("Track Positions");
        this.visibilityFlag = new JCheckBox();
        this.scrollPane = new JScrollPane();
        this.positionTable = new PositionTable();
        this.offsetSpinner = new JSpinner();
        this.offsetToggleCheckBox = new JCheckBox();
        this.offsetUnitLabel = new JLabel();
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
        jPanel.setOpaque(false);
        this.visibilityFlag.setText("Show Track");
        this.visibilityFlag.setSelected(true);
        this.visibilityFlag.setOpaque(false);
        this.visibilityFlag.setToolTipText("Display track on the globe");
        this.visibilityFlag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackPanel.this.visibilityActionPerformed(actionEvent);
            }
        });
        jPanel.add(this.visibilityFlag);
        jPanel.add(Box.createHorizontalStrut(15));
        this.offsetToggleCheckBox.setText("Offset Altitude");
        this.offsetToggleCheckBox.setSelected(true);
        this.offsetToggleCheckBox.setOpaque(false);
        this.offsetToggleCheckBox.setToolTipText("Visually offset track altitude on the globe");
        this.offsetToggleCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TrackPanel.this.offsetToggleCheckBoxItemStateChanged(itemEvent);
            }
        });
        jPanel.add(this.offsetToggleCheckBox);
        jPanel.add(Box.createHorizontalStrut(3));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, -100000, 100000, 100);
        this.offsetSpinner.setModel(spinnerNumberModel);
        this.offsetSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TrackPanel.this.offsetSpinnerStateChanged(changeEvent);
            }
        });
        jPanel.add(this.offsetSpinner);
        jPanel.add(Box.createHorizontalStrut(5));
        this.offsetUnitLabel.setText("ft");
        jPanel.add(this.offsetUnitLabel);
        jPanel.add(Box.createHorizontalGlue());
        this.add((Component)jPanel, "North");
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.positionTable.setPreferredScrollableViewportSize(new Dimension(340, 300));
        this.scrollPane.setViewportView(this.positionTable);
        this.add((Component)this.scrollPane, "Center");
    }

    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsBoolean(stateObject, "offsetEnabled", this.offsetToggleCheckBox.isSelected());
        double d = this.parseOffsetInput();
        if (this.elevationUnit.equals("Imperial")) {
            d = SAR2.feetToMeters(d);
        }
        restorableSupport.addStateValueAsDouble(stateObject, "offsetValue", d);
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "offsetEnabled");
        if (bl != null) {
            this.offsetToggleCheckBox.setSelected(bl);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "offsetValue")) != null) {
            if (this.elevationUnit.equals("Imperial")) {
                d = SAR2.metersToFeet(d);
            }
            this.offsetSpinner.setValue(d);
        }
    }
}

