/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwindx.applications.sar.SAR2;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlane;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlaneAttributes;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlaneController;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlaneEditor;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;

public class SARSegmentPlane
extends WWObjectImpl {
    private String angleFormat;
    private String elevationUnit;
    private WorldWindow wwd;
    private SegmentPlane segmentPlane = new SegmentPlane();
    private SegmentPlaneEditor segmentPlaneEditor = new SegmentPlaneEditor();
    private SegmentPlaneController segmentPlaneController = new SegmentPlaneController(null);
    private boolean modifiedSinceLastArm = false;
    private boolean ignorePlaneChangeEvents = false;

    public SARSegmentPlane() {
        this.segmentPlane.setVisible(false);
        this.segmentPlane.addPropertyChangeListener(this);
        this.segmentPlaneEditor.setSegmentPlane(this.segmentPlane);
        this.segmentPlaneController.setEditor(this.segmentPlaneEditor);
        this.initSegmentPlane();
    }

    public boolean isVisible() {
        return this.segmentPlane.isVisible();
    }

    public void setVisible(boolean bl) {
        this.segmentPlane.setVisible(bl);
    }

    public boolean isArmed() {
        return this.segmentPlaneEditor.isArmed();
    }

    public void setArmed(boolean bl) {
        if (bl && !this.segmentPlaneEditor.isArmed()) {
            this.modifiedSinceLastArm = false;
        }
        this.segmentPlaneEditor.setArmed(bl);
    }

    public boolean isSnapToGrid() {
        return this.segmentPlaneEditor.isSnapToGrid();
    }

    public void setSnapToGrid(boolean bl) {
        this.segmentPlaneEditor.setSnapToGrid(bl);
    }

    public double[] getGridCellDimensions() {
        return this.segmentPlane.getGridCellDimensions();
    }

    public void setGridCellDimensions(double d, double d2) {
        this.segmentPlane.setGridCellDimensions(d, d2);
    }

    public String getAngleFormat() {
        return this.angleFormat;
    }

    public void setAngleFormat(String string) {
        this.angleFormat = string;
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        this.elevationUnit = string;
    }

    public WorldWindow getWorldWindow() {
        return this.wwd;
    }

    public void setWorldWindow(WorldWindow worldWindow) {
        if (this.wwd == worldWindow) {
            return;
        }
        if (this.wwd != null) {
            this.wwd.removePropertyChangeListener(this);
            if (this.wwd.getModel().getLayers().contains(this.segmentPlaneEditor)) {
                this.wwd.getModel().getLayers().remove(this.segmentPlaneEditor);
            }
        }
        this.wwd = worldWindow;
        this.segmentPlaneController.setWorldWindow(worldWindow);
        if (this.wwd != null) {
            this.wwd.addPropertyChangeListener(this);
            if (!this.wwd.getModel().getLayers().contains(this.segmentPlaneEditor)) {
                this.wwd.getModel().getLayers().add(this.segmentPlaneEditor);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() == this.segmentPlane) {
            this.modifiedSinceLastArm = true;
        }
        if (string == "SegmentPlane.SegmentBegin" || string == "SegmentPlane.SegmentEnd") {
            if (!this.ignorePlaneChangeEvents) {
                super.propertyChange(propertyChangeEvent);
            }
        } else if (string == "AngleFormat") {
            if (propertyChangeEvent.getNewValue() != null) {
                this.setAngleFormat(propertyChangeEvent.getNewValue().toString());
                super.propertyChange(propertyChangeEvent);
            }
        } else if (string == "ElevationUnit" && propertyChangeEvent.getNewValue() != null) {
            this.setElevationUnit(propertyChangeEvent.getNewValue().toString());
            super.propertyChange(propertyChangeEvent);
        }
    }

    public Position[] getSegmentPositions() {
        return this.segmentPlane.getSegmentPositions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSegmentPositions(Position position, Position position2) {
        this.ignorePlaneChangeEvents = true;
        try {
            this.segmentPlane.setSegmentPositions(position, position2);
        }
        finally {
            this.ignorePlaneChangeEvents = false;
        }
    }

    public double[] getPlaneAltitudes() {
        return this.segmentPlane.getPlaneAltitudes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaneAltitudes(double d, double d2) {
        this.ignorePlaneChangeEvents = true;
        try {
            this.segmentPlane.setPlaneAltitudes(d, d2);
        }
        finally {
            this.ignorePlaneChangeEvents = false;
        }
    }

    public LatLon[] getPlaneLocations() {
        return this.segmentPlane.getPlaneLocations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaneLocations(LatLon latLon, LatLon latLon2) {
        this.ignorePlaneChangeEvents = true;
        try {
            this.segmentPlane.setPlaneLocations(latLon, latLon2);
        }
        finally {
            this.ignorePlaneChangeEvents = false;
        }
    }

    public SegmentPlaneAttributes getAttributes() {
        return this.segmentPlane.getAttributes();
    }

    public void setAttributes(SegmentPlaneAttributes segmentPlaneAttributes) {
        this.segmentPlane.setAttributes(segmentPlaneAttributes);
    }

    public void setObjectVisible(String string, boolean bl, boolean bl2) {
        SegmentPlaneAttributes.LabelAttributes labelAttributes;
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes = this.segmentPlane.getAttributes().getGeometryAttributes(string);
        if (geometryAttributes != null) {
            geometryAttributes.setVisible(bl);
        }
        if ((labelAttributes = this.segmentPlane.getAttributes().getLabelAttributes(string)) != null) {
            labelAttributes.setVisible(bl2);
        }
    }

    public double[] computeAltitudesToFitPositions(Iterable<? extends Position> iterable) {
        if (this.wwd == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return SARSegmentPlane.computeAltitudesToFitPositions(this.wwd, this.segmentPlane, iterable, this.modifiedSinceLastArm);
    }

    public LatLon[] computeLocationsToFitPositions(Position position, Position position2) {
        if (this.wwd == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return SARSegmentPlane.computeLocationsToFitPositions(this.wwd, this.segmentPlane, position, position2, this.modifiedSinceLastArm);
    }

    public Position getIntersectionPosition(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.wwd == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Globe globe = this.wwd.getModel().getGlobe();
        Vec4 vec4 = this.segmentPlaneEditor.getSegmentPlaneRenderer().intersect(globe, line, this.segmentPlane);
        if (vec4 == null) {
            return null;
        }
        return globe.computePositionFromPoint(vec4);
    }

    public double getObjectSize(String string, Vec4 vec4) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (vec4 == null) {
            String string3 = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (this.wwd == null) {
            String string4 = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string4);
            throw new IllegalStateException(string4);
        }
        View view = this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        return this.segmentPlaneEditor.getSegmentPlaneRenderer().computeObjectSize(view, globe, this.segmentPlane, string, vec4);
    }

    protected void initSegmentPlane() {
        double d = SAR2.feetToMeters(1000.0);
        this.segmentPlane.setGridCellDimensions(d, d);
        this.segmentPlane.setPlaneOutlineMask(1);
        this.segmentPlane.setBorderMask(4);
        Color color = new Color(90, 146, 200);
        Color color2 = new Color(163, 191, 222);
        Color color3 = Color.YELLOW;
        Color color4 = Color.RED;
        Color color5 = Color.YELLOW;
        Color color6 = Color.GREEN;
        Color color7 = Color.MAGENTA;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        SegmentPlaneAttributes segmentPlaneAttributes = new SegmentPlaneAttributes();
        this.segmentPlane.setAttributes(segmentPlaneAttributes);
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes = new SegmentPlaneAttributes.GeometryAttributes(new Material(color2), 0.6);
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes2 = new SegmentPlaneAttributes.GeometryAttributes(new Material(color), 1.0);
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes3 = new SegmentPlaneAttributes.GeometryAttributes(new Material(color), 1.0);
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes4 = new SegmentPlaneAttributes.GeometryAttributes(new Material(color), 1.0);
        geometryAttributes3.setSize(1.0);
        geometryAttributes3.setPickSize(10.0);
        geometryAttributes2.setSize(3.0);
        geometryAttributes4.setSize(3.0);
        segmentPlaneAttributes.setGeometryAttributes("SegmentPlane.PlaneBackground", geometryAttributes);
        segmentPlaneAttributes.setGeometryAttributes("SegmentPlane.PlaneOutline", geometryAttributes2);
        segmentPlaneAttributes.setGeometryAttributes("SegmentPlane.PlaneGrid", geometryAttributes3);
        segmentPlaneAttributes.setGeometryAttributes("SegmentPlane.PlaneBorder", geometryAttributes4);
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes5 = new SegmentPlaneAttributes.GeometryAttributes(new Material(color3), 1.0);
        AxisLabelAttributes axisLabelAttributes = new AxisLabelAttributes(color5, Font.decode("Arial-12"), "gov.nasa.worldwind.avkey.Left", "gov.nasa.worldwind.avkey.Center", this);
        geometryAttributes5.setSize(1.0);
        axisLabelAttributes.setVisible(false);
        axisLabelAttributes.setMaxActiveDistance(d2);
        segmentPlaneAttributes.setGeometryAttributes("SegmentPlane.Altimeter", geometryAttributes5);
        segmentPlaneAttributes.setLabelAttributes("SegmentPlane.Altimeter", axisLabelAttributes);
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes6 = new SegmentPlaneAttributes.GeometryAttributes(new Material(color3), 1.0);
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes7 = new SegmentPlaneAttributes.GeometryAttributes(new Material(color3), 1.0);
        ControlPointLabelAttributes controlPointLabelAttributes = new ControlPointLabelAttributes(color3, Font.decode("Arial-12"), "gov.nasa.worldwind.avkey.Right", "gov.nasa.worldwind.avkey.Center", this);
        ControlPointLabelAttributes controlPointLabelAttributes2 = new ControlPointLabelAttributes(color3, Font.decode("Arial-12"), "gov.nasa.worldwind.avkey.Right", "gov.nasa.worldwind.avkey.Center", this);
        geometryAttributes6.setEnablePicking(false);
        geometryAttributes6.setSize(8.0);
        geometryAttributes6.setPickSize(10.0);
        geometryAttributes7.setSize(8.0);
        geometryAttributes7.setPickSize(10.0);
        controlPointLabelAttributes.setMaxActiveDistance(d3);
        controlPointLabelAttributes.setShowAltitude(true);
        controlPointLabelAttributes.setShowHeightAboveSurface(true);
        controlPointLabelAttributes.setOffset(new Vec4(-10.0, 0.0, 0.0));
        controlPointLabelAttributes2.setPrefix("Aircraft");
        controlPointLabelAttributes2.setMaxActiveDistance(d4);
        controlPointLabelAttributes2.setShowAltitude(true);
        controlPointLabelAttributes2.setShowHeightAboveSurface(true);
        controlPointLabelAttributes2.setOffset(new Vec4(-10.0, 0.0, 0.0));
        segmentPlaneAttributes.setGeometryAttributes("SegmentPlane.SegmentBegin", geometryAttributes6.copy());
        segmentPlaneAttributes.setGeometryAttributes("SegmentPlane.SegmentEnd", geometryAttributes7.copy());
        segmentPlaneAttributes.setLabelAttributes("SegmentPlane.SegmentBegin", controlPointLabelAttributes);
        segmentPlaneAttributes.setLabelAttributes("SegmentPlane.SegmentEnd", controlPointLabelAttributes2);
        AxisLabelAttributes axisLabelAttributes2 = new AxisLabelAttributes(color4, Font.decode("Arial-10"), "gov.nasa.worldwind.avkey.Center", "gov.nasa.worldwind.avkey.Bottom", this);
        AltitudeLabelAttributes altitudeLabelAttributes = new AltitudeLabelAttributes(color5, Font.decode("Arial-10"), "gov.nasa.worldwind.avkey.Right", "gov.nasa.worldwind.avkey.Bottom", this);
        axisLabelAttributes2.setMaxActiveDistance(d2);
        altitudeLabelAttributes.setMaxActiveDistance(d2);
        segmentPlaneAttributes.setLabelAttributes("SegmentPlane.HorizontalAxisLabels", axisLabelAttributes2);
        segmentPlaneAttributes.setLabelAttributes("SegmentPlane.VerticalAxisLabels", altitudeLabelAttributes);
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes8 = new SegmentPlaneAttributes.GeometryAttributes(new Material(color6), 1.0);
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes9 = new SegmentPlaneAttributes.GeometryAttributes(new Material(color6), 1.0);
        ControlPointLabelAttributes controlPointLabelAttributes3 = new ControlPointLabelAttributes(color6, Font.decode("Arial-12"), "gov.nasa.worldwind.avkey.Left", "gov.nasa.worldwind.avkey.Center", this);
        ControlPointLabelAttributes controlPointLabelAttributes4 = new ControlPointLabelAttributes(color6, Font.decode("Arial-12"), "gov.nasa.worldwind.avkey.Left", "gov.nasa.worldwind.avkey.Center", this);
        geometryAttributes8.setSize(7.0);
        geometryAttributes8.setPickSize(10.0);
        geometryAttributes8.setOffset(new Vec4(0.0, 0.0, 7.0));
        geometryAttributes9.setSize(7.0);
        geometryAttributes9.setPickSize(10.0);
        controlPointLabelAttributes3.setVisible(false);
        controlPointLabelAttributes3.setMaxActiveDistance(d3);
        controlPointLabelAttributes4.setShowLocation(false);
        controlPointLabelAttributes4.setShowSegmentHeading(true);
        controlPointLabelAttributes4.setMaxActiveDistance(d3);
        controlPointLabelAttributes4.setOffset(new Vec4(15.0, 0.0, 0.0));
        segmentPlaneAttributes.setGeometryAttributes("SegmentPlane.ControlPointLowerRight", geometryAttributes8.copy());
        segmentPlaneAttributes.setGeometryAttributes("SegmentPlane.ControlPointUpperRight", geometryAttributes9.copy());
        segmentPlaneAttributes.setLabelAttributes("SegmentPlane.ControlPointLowerRight", controlPointLabelAttributes3);
        segmentPlaneAttributes.setLabelAttributes("SegmentPlane.ControlPointUpperRight", controlPointLabelAttributes4);
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes10 = new SegmentPlaneAttributes.GeometryAttributes(new Material(color7), 1.0);
        ControlPointLabelAttributes controlPointLabelAttributes5 = new ControlPointLabelAttributes(color7, Font.decode("Arial-10"), "gov.nasa.worldwind.avkey.Left", "gov.nasa.worldwind.avkey.Center", this);
        geometryAttributes10.setSize(7.0);
        geometryAttributes10.setPickSize(10.0);
        controlPointLabelAttributes5.setVisible(false);
        controlPointLabelAttributes5.setMaxActiveDistance(d3);
        segmentPlaneAttributes.setGeometryAttributes("SegmentPlane.ControlPointLeadingEdge", geometryAttributes10.copy());
        segmentPlaneAttributes.setGeometryAttributes("SegmentPlane.ControlPointTopEdge", geometryAttributes10.copy());
        segmentPlaneAttributes.setLabelAttributes("SegmentPlane.ControlPointLeadingEdge", controlPointLabelAttributes5.copy());
        segmentPlaneAttributes.setLabelAttributes("SegmentPlane.ControlPointTopEdge", controlPointLabelAttributes5.copy());
    }

    protected static String formatAngle(String string, Angle angle) {
        if ("gov.nasa.worldwind.Geom.AngleDMS".equals(string)) {
            return angle.toDMSString();
        }
        return angle.toDecimalDegreesString(4);
    }

    protected static String formatElevation(String string, double d) {
        if ("Imperial".equals(string)) {
            return String.format("%.0f ft", WWMath.convertMetersToFeet(d));
        }
        return String.format("%.0f m", d);
    }

    protected static double getSurfaceElevationAt(WorldWindow worldWindow, Angle angle, Angle angle2) {
        Vec4 vec4;
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Globe globe = worldWindow.getModel().getGlobe();
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        SectorGeometryList sectorGeometryList = worldWindow.getSceneController().getTerrain();
        if (sectorGeometryList != null && (vec4 = sectorGeometryList.getSurfacePoint(angle, angle2)) != null) {
            Position position = globe.computePositionFromPoint(vec4);
            return position.getElevation();
        }
        return globe.getElevation(angle, angle2);
    }

    protected static double[] computeAltitudesToFitPositions(WorldWindow worldWindow, SegmentPlane segmentPlane, Iterable<? extends Position> iterable, boolean bl) {
        Globe globe = worldWindow.getModel().getGlobe();
        double[] dArray = segmentPlane.getPlaneAltitudes();
        double[] dArray2 = segmentPlane.getGridCellDimensions();
        Position[] positionArray = segmentPlane.getSegmentPositions();
        double d = Math.max(positionArray[0].getElevation(), positionArray[1].getElevation());
        double[] dArray3 = globe.getMinAndMaxElevations(Sector.boundingSector(iterable));
        double d2 = -1.7976931348623157E308;
        for (Position position : iterable) {
            if (!(d2 < position.getElevation())) continue;
            d2 = position.getElevation();
        }
        double d3 = dArray[1] - d;
        if (!bl || d3 < 0.0) {
            d3 = SARSegmentPlane.computeInitialVerticalGap(worldWindow, segmentPlane, iterable);
        }
        return new double[]{dArray2[1] * Math.floor(dArray3[0] / dArray2[1]), d2 + d3};
    }

    protected static LatLon[] computeLocationsToFitPositions(WorldWindow worldWindow, SegmentPlane segmentPlane, Position position, Position position2, boolean bl) {
        LatLon[] latLonArray = segmentPlane.getPlaneLocations();
        Position[] positionArray = segmentPlane.getSegmentPositions();
        Angle angle = LatLon.rhumbDistance(positionArray[1], latLonArray[1]);
        if (!bl || angle.compareTo(Angle.ZERO) < 0) {
            angle = SARSegmentPlane.computeInitialHorizontalGap(worldWindow, segmentPlane, position, position2);
        }
        Angle angle2 = LatLon.rhumbAzimuth(position, position2);
        Angle angle3 = LatLon.rhumbDistance(position, position2).add(angle);
        return new LatLon[]{new LatLon(position), LatLon.rhumbEndPosition((LatLon)position, angle2, angle3)};
    }

    protected static double computeInitialVerticalGap(WorldWindow worldWindow, SegmentPlane segmentPlane, Iterable<? extends Position> iterable) {
        double[] dArray = segmentPlane.getGridCellDimensions();
        double d = -1.7976931348623157E308;
        for (Position position : iterable) {
            double d2 = position.getElevation() - SARSegmentPlane.getSurfaceElevationAt(worldWindow, position.getLatitude(), position.getLongitude());
            if (!(d2 > d)) continue;
            d = d2;
        }
        return Math.max(2.0 * dArray[1], d / 2.0);
    }

    protected static Angle computeInitialHorizontalGap(WorldWindow worldWindow, SegmentPlane segmentPlane, Position position, Position position2) {
        double[] dArray = segmentPlane.getGridCellDimensions();
        double d = dArray[0] / worldWindow.getModel().getGlobe().getRadius();
        double d2 = LatLon.rhumbDistance((LatLon)position, (LatLon)position2).radians;
        return Angle.fromRadians(Math.max(2.0 * d, d2 / 2.0));
    }

    public static class MessageLabelAttributes
    extends SegmentPlaneAttributes.LabelAttributes {
        private String message;

        public MessageLabelAttributes(Color color, Font font, String string, String string2, String string3) {
            super(color, font, string, string2);
            this.message = string3;
        }

        public MessageLabelAttributes() {
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String string) {
            this.message = string;
        }

        @Override
        public SegmentPlaneAttributes.LabelAttributes copy() {
            return this.copyTo(new MessageLabelAttributes());
        }

        @Override
        protected SegmentPlaneAttributes.LabelAttributes copyTo(SegmentPlaneAttributes.LabelAttributes labelAttributes) {
            super.copyTo(labelAttributes);
            if (labelAttributes instanceof MessageLabelAttributes) {
                ((MessageLabelAttributes)labelAttributes).setMessage(this.getMessage());
            }
            return labelAttributes;
        }

        @Override
        public String getText(SegmentPlane segmentPlane, Position position, AVList aVList) {
            return this.getMessage();
        }
    }

    public static class AxisLabelAttributes
    extends SARLabelAttributes {
        public AxisLabelAttributes(Color color, Font font, String string, String string2, SARSegmentPlane sARSegmentPlane) {
            super(color, font, string, string2, sARSegmentPlane);
        }

        public AxisLabelAttributes() {
        }

        @Override
        public SegmentPlaneAttributes.LabelAttributes copy() {
            return this.copyTo(new AxisLabelAttributes());
        }

        @Override
        public String getText(SegmentPlane segmentPlane, Position position, AVList aVList) {
            StringBuilder stringBuilder = new StringBuilder();
            if (aVList != null) {
                boolean bl;
                Double d = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.avkey.Width");
                Double d2 = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.avkey.Height");
                boolean bl2 = bl = d != null && d2 != null;
                if (bl) {
                    stringBuilder.append("(");
                }
                if (d != null) {
                    stringBuilder.append(this.formatElevation(d));
                }
                if (bl) {
                    stringBuilder.append(", ");
                }
                if (d2 != null) {
                    stringBuilder.append(this.formatElevation(d2));
                }
                if (bl) {
                    stringBuilder.append(")");
                }
            }
            if (stringBuilder.length() == 0) {
                return null;
            }
            return stringBuilder.toString();
        }
    }

    public static class AltitudeLabelAttributes
    extends SARLabelAttributes {
        public AltitudeLabelAttributes(Color color, Font font, String string, String string2, SARSegmentPlane sARSegmentPlane) {
            super(color, font, string, string2, sARSegmentPlane);
        }

        public AltitudeLabelAttributes() {
        }

        @Override
        public SegmentPlaneAttributes.LabelAttributes copy() {
            return this.copyTo(new AltitudeLabelAttributes());
        }

        @Override
        public String getText(SegmentPlane segmentPlane, Position position, AVList aVList) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.formatElevation(position.getElevation()));
            return stringBuilder.toString();
        }
    }

    public static class ControlPointLabelAttributes
    extends SARLabelAttributes {
        private String prefix;
        private boolean showLocation = true;
        private boolean showAltitude = false;
        private boolean showHeightAboveSurface = false;
        private boolean showSegmentHeading = false;

        public ControlPointLabelAttributes(Color color, Font font, String string, String string2, SARSegmentPlane sARSegmentPlane) {
            super(color, font, string, string2, sARSegmentPlane);
        }

        public ControlPointLabelAttributes() {
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public boolean isShowLocation() {
            return this.showLocation;
        }

        public void setShowLocation(boolean bl) {
            this.showLocation = bl;
        }

        public boolean isShowAltitude() {
            return this.showAltitude;
        }

        public void setShowAltitude(boolean bl) {
            this.showAltitude = bl;
        }

        public boolean isShowSegmentHeading() {
            return this.showSegmentHeading;
        }

        public void setShowSegmentHeading(boolean bl) {
            this.showSegmentHeading = bl;
        }

        public boolean isShowHeightAboveSurface() {
            return this.showHeightAboveSurface;
        }

        public void setShowHeightAboveSurface(boolean bl) {
            this.showHeightAboveSurface = bl;
        }

        @Override
        public SegmentPlaneAttributes.LabelAttributes copy() {
            return this.copyTo(new ControlPointLabelAttributes());
        }

        @Override
        protected SegmentPlaneAttributes.LabelAttributes copyTo(SegmentPlaneAttributes.LabelAttributes labelAttributes) {
            super.copyTo(labelAttributes);
            if (labelAttributes instanceof ControlPointLabelAttributes) {
                ((ControlPointLabelAttributes)labelAttributes).setPrefix(this.getPrefix());
                ((ControlPointLabelAttributes)labelAttributes).setShowLocation(this.isShowLocation());
                ((ControlPointLabelAttributes)labelAttributes).setShowAltitude(this.isShowAltitude());
                ((ControlPointLabelAttributes)labelAttributes).setShowHeightAboveSurface(this.isShowHeightAboveSurface());
                ((ControlPointLabelAttributes)labelAttributes).setShowSegmentHeading(this.isShowSegmentHeading());
            }
            return labelAttributes;
        }

        @Override
        public String getText(SegmentPlane segmentPlane, Position position, AVList aVList) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getPrefix() != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(this.getPrefix());
            }
            if (this.isShowLocation()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append("(");
                stringBuilder.append(this.formatAngle(position.getLatitude()));
                stringBuilder.append(", ");
                stringBuilder.append(this.formatAngle(position.getLongitude()));
                stringBuilder.append(")");
            }
            if (this.isShowSegmentHeading()) {
                object = segmentPlane.getPlaneLocations();
                Angle angle = LatLon.rhumbAzimuth(object[0], object[1]);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append("Heading: ").append(angle.toDecimalDegreesString(0));
            }
            if (this.isShowAltitude()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append("Alt: ").append(this.formatElevation(position.getElevation()));
            }
            if (this.isShowHeightAboveSurface() && aVList != null && (object = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.avkey.Height")) != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append("AGL: ").append(this.formatElevation((Double)object));
            }
            return stringBuilder.toString();
        }
    }

    public static class SARLabelAttributes
    extends SegmentPlaneAttributes.LabelAttributes {
        private SARSegmentPlane context;

        public SARLabelAttributes(Color color, Font font, String string, String string2, SARSegmentPlane sARSegmentPlane) {
            super(color, font, string, string2);
            this.context = sARSegmentPlane;
        }

        public SARLabelAttributes() {
        }

        public SARSegmentPlane getContext() {
            return this.context;
        }

        public void setContext(SARSegmentPlane sARSegmentPlane) {
            this.context = sARSegmentPlane;
        }

        @Override
        public SegmentPlaneAttributes.LabelAttributes copy() {
            return this.copyTo(new SARLabelAttributes());
        }

        @Override
        protected SegmentPlaneAttributes.LabelAttributes copyTo(SegmentPlaneAttributes.LabelAttributes labelAttributes) {
            super.copyTo(labelAttributes);
            if (labelAttributes instanceof SARLabelAttributes) {
                ((SARLabelAttributes)labelAttributes).setContext(this.getContext());
            }
            return labelAttributes;
        }

        protected String formatAngle(Angle angle) {
            return SARSegmentPlane.formatAngle(this.context.getAngleFormat(), angle);
        }

        protected String formatElevation(double d) {
            return SARSegmentPlane.formatElevation(this.context.getElevationUnit(), d);
        }
    }
}

