/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwindx.applications.sar.SAR2;
import gov.nasa.worldwindx.applications.sar.SARPosition;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class PositionTable
extends JTable {
    private static final int ITEM_NUM_COLUMN = 0;
    private static final int LATITUDE_COLUMN = 1;
    private static final int LONGITUDE_COLUMN = 2;
    private static final int ALTITUDE_COLUMN = 3;
    private SARTrack sarTrack;
    private String elevationUnit;
    private String angleFormat;
    private final PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            if (object != null && object instanceof Integer) {
                PositionTable.this.updateTableRow((Integer)object);
            } else {
                PositionTable.this.updateTableData();
            }
        }
    };

    public PositionTable() {
        this.setToolTipText("Track Positions");
        this.setModel(new MyTableModel(this));
        this.putClientProperty("terminateEditOnFocusLost", true);
        TableCellRenderer tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        this.getTableHeader().getColumnModel().getColumn(1).setHeaderRenderer(new AngleHeaderRenderer(tableCellRenderer, this));
        this.getTableHeader().getColumnModel().getColumn(2).setHeaderRenderer(new AngleHeaderRenderer(tableCellRenderer, this));
        this.getColumnModel().getColumn(1).setCellRenderer(new AngleCellRenderer(this));
        this.getColumnModel().getColumn(2).setCellRenderer(new AngleCellRenderer(this));
        this.getColumnModel().getColumn(1).setCellEditor(new AngleCellEditor(this, -90.0, 90.0));
        this.getColumnModel().getColumn(2).setCellEditor(new AngleCellEditor(this, -180.0, 180.0));
        this.getTableHeader().getColumnModel().getColumn(3).setHeaderRenderer(new AltitudeHeaderRenderer(tableCellRenderer, this));
        this.getColumnModel().getColumn(3).setCellRenderer(new AltitudeCellRenderer(this));
        this.getColumnModel().getColumn(3).setCellEditor(new AltitudeCellEditor(this));
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setResizable(false);
        tableColumnModel.getColumn(0).setMinWidth(35);
        tableColumnModel.getColumn(0).setPreferredWidth(35);
        tableColumnModel.getColumn(1).setResizable(false);
        tableColumnModel.getColumn(1).setMinWidth(70);
        tableColumnModel.getColumn(1).setPreferredWidth(80);
        tableColumnModel.getColumn(2).setResizable(false);
        tableColumnModel.getColumn(2).setMinWidth(70);
        tableColumnModel.getColumn(2).setPreferredWidth(80);
        tableColumnModel.getColumn(3).setResizable(false);
        tableColumnModel.getColumn(3).setMinWidth(70);
        tableColumnModel.getColumn(3).setPreferredWidth(70);
    }

    public SARTrack getSarTrack() {
        return this.sarTrack;
    }

    public void setSarTrack(SARTrack sARTrack) {
        if (this.sarTrack == sARTrack) {
            return;
        }
        if (this.sarTrack != null) {
            this.sarTrack.removePropertyChangeListener(this.propertyListener);
        }
        this.sarTrack = sARTrack;
        if (this.sarTrack != null) {
            this.sarTrack.addPropertyChangeListener(this.propertyListener);
        }
        this.setTableColors(this.sarTrack);
        this.updateTableData();
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        this.elevationUnit = string;
    }

    public String getAngleFormat() {
        return this.angleFormat;
    }

    public void setAngleFormat(String string) {
        this.angleFormat = string;
    }

    public void updateTableData() {
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
    }

    public void updateTableRow(int n) {
        ((AbstractTableModel)this.getModel()).fireTableRowsUpdated(n, n);
    }

    protected Color getTableColorForTrack(SARTrack sARTrack) {
        if (sARTrack == null) {
            return null;
        }
        Color color = sARTrack.getColor();
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        int n = Color.HSBtoRGB(f, f2 *= 0.2f, f3);
        return new Color(n);
    }

    protected void setTableColors(SARTrack sARTrack) {
        Color color = this.getTableColorForTrack(sARTrack);
        Color color2 = color != null ? Color.DARK_GRAY : null;
        Color color3 = color != null ? Color.WHITE : null;
        this.setBackground(color);
        this.setSelectionForeground(color3);
        this.setSelectionBackground(color2);
        this.setOpaque(true);
        Container container = this.getParent();
        if (container != null) {
            container.setBackground(color);
            if (container instanceof JComponent) {
                ((JComponent)container).setOpaque(true);
            }
        }
    }

    private Angle toAngle(String string) {
        if ("gov.nasa.worldwind.Geom.AngleDMS".equals(this.angleFormat)) {
            try {
                return Angle.fromDMS(string);
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            Number number = NumberFormat.getInstance().parse(string.trim());
            return Angle.fromDegrees(number.doubleValue());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String makeAngleDescription(double d) {
        return SAR2.formatAngle(this.angleFormat, Angle.fromDegrees(d));
    }

    private String makeElevationDescription(double d) {
        String string = "Imperial".equals(this.elevationUnit) ? NumberFormat.getInstance().format(SAR2.metersToFeet(d)) : NumberFormat.getInstance().format(d);
        return string;
    }

    private static class AltitudeCellEditor
    extends GeneralCellEditor {
        public AltitudeCellEditor(PositionTable positionTable) {
            super(new JTextField(), positionTable);
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        @Override
        protected Object validateEditorText(String string) throws Exception {
            Number number = NumberFormat.getInstance().parse(string);
            return number.doubleValue();
        }

        @Override
        protected String createEditorText(Object object) throws Exception {
            return this.getTable().makeElevationDescription((Double)object);
        }
    }

    private class AngleCellEditor
    extends GeneralCellEditor {
        double min;
        double max;

        public AngleCellEditor(PositionTable positionTable2, double d, double d2) {
            super(new JTextField(), positionTable2);
            this.min = d;
            this.max = d2;
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        @Override
        protected Object validateEditorText(String string) throws Exception {
            Angle angle = this.getTable().toAngle(string);
            if (angle == null) {
                throw new IllegalArgumentException(string);
            }
            if (angle.degrees < this.min || angle.degrees > this.max) {
                throw new IllegalArgumentException(string);
            }
            return string;
        }

        @Override
        protected String createEditorText(Object object) throws Exception {
            String string = this.getTable().makeAngleDescription((Double)object);
            string = string.replaceAll("[D|d|\u00b0|'|\u2019|\"|\u201d]", " ").replaceAll("\\s+", " ");
            return string;
        }
    }

    private static class GeneralCellEditor
    extends DefaultCellEditor {
        private PositionTable table;
        private Object value;

        public GeneralCellEditor(JTextField jTextField, PositionTable positionTable) {
            super(jTextField);
            this.table = positionTable;
        }

        public PositionTable getTable() {
            return this.table;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            try {
                this.value = this.validateEditorText(string);
            }
            catch (Exception exception) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            this.value = null;
            try {
                this.value = this.createEditorText(object);
            }
            catch (Exception exception) {
                return null;
            }
            return super.getTableCellEditorComponent(jTable, this.value, bl, n, n2);
        }

        protected Object validateEditorText(String string) throws Exception {
            return string;
        }

        protected String createEditorText(Object object) throws Exception {
            return object.toString();
        }
    }

    private static class AltitudeCellRenderer
    extends DefaultTableCellRenderer {
        private PositionTable table;

        private AltitudeCellRenderer(PositionTable positionTable) {
            this.table = positionTable;
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object object) {
            this.setText(this.table.makeElevationDescription((Double)object));
        }
    }

    private static class AngleCellRenderer
    extends DefaultTableCellRenderer {
        private PositionTable table;

        private AngleCellRenderer(PositionTable positionTable) {
            this.table = positionTable;
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object object) {
            this.setText(object != null ? this.table.makeAngleDescription((Double)object) : "");
        }
    }

    private static class AngleHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer delegate;
        private PositionTable table;

        public AngleHeaderRenderer(TableCellRenderer tableCellRenderer, PositionTable positionTable) {
            this.delegate = tableCellRenderer;
            this.table = positionTable;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.delegate == null) {
                return null;
            }
            Component component = this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component == null || !(component instanceof JLabel)) {
                return component;
            }
            JLabel jLabel = (JLabel)component;
            if (jLabel.getText() == null) {
                return component;
            }
            if ("gov.nasa.worldwind.Geom.AngleDMS".equals(this.table.angleFormat)) {
                jLabel.setText(jLabel.getText() + " (dms)");
            } else {
                jLabel.setText(jLabel.getText() + " (dd)");
            }
            return jLabel;
        }
    }

    private static class AltitudeHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer delegate;
        private PositionTable table;

        public AltitudeHeaderRenderer(TableCellRenderer tableCellRenderer, PositionTable positionTable) {
            this.delegate = tableCellRenderer;
            this.table = positionTable;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.delegate == null) {
                return null;
            }
            Component component = this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component == null || !(component instanceof JLabel)) {
                return component;
            }
            JLabel jLabel = (JLabel)component;
            if (jLabel.getText() == null) {
                return component;
            }
            if ("Imperial".equals(this.table.elevationUnit)) {
                jLabel.setText(jLabel.getText() + " (ft)");
            } else {
                jLabel.setText(jLabel.getText() + " (m)");
            }
            return jLabel;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"#", "Latitude", "Longitude", "Altitude"};
        Class[] columnTypes = new Class[]{Integer.class, String.class, String.class, Double.class};
        boolean[] columnEditable = new boolean[]{false, true, true, true};
        private PositionTable table;

        public MyTableModel(PositionTable positionTable2) {
            this.table = positionTable2;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.columnTypes[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.columnEditable[n2];
        }

        @Override
        public int getRowCount() {
            return PositionTable.this.sarTrack != null ? PositionTable.this.sarTrack.size() : 0;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (PositionTable.this.sarTrack == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return n;
                }
                case 1: {
                    return ((PositionTable)PositionTable.this).sarTrack.get((int)n).getLatitude().degrees;
                }
                case 2: {
                    return ((PositionTable)PositionTable.this).sarTrack.get((int)n).getLongitude().degrees;
                }
                case 3: {
                    return PositionTable.this.sarTrack.get(n).getElevation();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SARPosition sARPosition;
            if (PositionTable.this.sarTrack == null) {
                return;
            }
            SARPosition sARPosition2 = PositionTable.this.sarTrack.get(n);
            switch (n2) {
                case 1: {
                    if (!(object instanceof String)) {
                        return;
                    }
                    Angle angle = this.table.toAngle((String)object);
                    if (angle == null) {
                        return;
                    }
                    sARPosition = new SARPosition(angle, sARPosition2.getLongitude(), sARPosition2.getElevation());
                    break;
                }
                case 2: {
                    if (!(object instanceof String)) {
                        return;
                    }
                    Angle angle = this.table.toAngle((String)object);
                    if (angle == null) {
                        return;
                    }
                    sARPosition = new SARPosition(sARPosition2.getLatitude(), angle, sARPosition2.getElevation());
                    break;
                }
                case 3: {
                    if (!(object instanceof Double)) {
                        return;
                    }
                    double d = (Double)object;
                    if ("Imperial".equals(PositionTable.this.elevationUnit)) {
                        d = SAR2.feetToMeters(d);
                    }
                    sARPosition = new SARPosition(sARPosition2.getLatitude(), sARPosition2.getLongitude(), d);
                    break;
                }
                default: {
                    return;
                }
            }
            PositionTable.this.sarTrack.set(n, sARPosition);
        }
    }
}

