/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.glider;

import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.SurfaceImageLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwindx.applications.glider.GliderImage;
import gov.nasa.worldwindx.applications.glider.GliderRegionOfInterest;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GliderImageLayer
extends AbstractLayer {
    public static final String GLIDER_IMAGE = "gov.nasa.worldwind.glider.Image";
    protected GliderImage image;
    protected SurfaceImageLayer imageLayer = new SurfaceImageLayer();
    protected RenderableLayer regionLayer = new RenderableLayer();
    protected ImageListener imageListener = new ImageListener();

    @Override
    public void dispose() {
        if (this.image != null) {
            this.image.removePropertyChangeListener(this.imageListener);
        }
        this.imageLayer.dispose();
        this.regionLayer.dispose();
    }

    public void setImage(GliderImage gliderImage) throws IOException {
        if (gliderImage.getImageSource() instanceof String) {
            ((SurfaceImageLayer)this.getImageLayer()).addImage((String)gliderImage.getImageSource(), gliderImage.getCorners());
        } else if (gliderImage.getImageSource() instanceof BufferedImage) {
            ((SurfaceImageLayer)this.getImageLayer()).addImage(gliderImage.getName(), (BufferedImage)gliderImage.getImageSource(), gliderImage.getSector());
        } else {
            throw new IllegalArgumentException("Unsupported image source type");
        }
        this.setOpacity(gliderImage.opacity);
        if (gliderImage != this.image) {
            gliderImage.addPropertyChangeListener(this.imageListener);
            if (this.image != null) {
                this.image.removePropertyChangeListener(this.imageListener);
            }
        }
        this.regionLayer.removeAllRenderables();
        if (gliderImage.getRegionsOfInterest() != null) {
            this.regionLayer.addRenderables(GliderImageLayer.makePolylines(gliderImage.getRegionsOfInterest(), gliderImage.getAltitude()));
        }
        this.image = gliderImage;
        this.firePropertyChange(GLIDER_IMAGE, this.image, this.image);
    }

    @Override
    public String getName() {
        return this.image != null ? this.image.getName() : "Unnamed Layer";
    }

    protected Layer getImageLayer() {
        return this.imageLayer;
    }

    @Override
    protected void doRender(DrawContext drawContext) {
    }

    @Override
    public void render(DrawContext drawContext) {
        if (!this.isEnabled()) {
            return;
        }
        this.imageLayer.render(drawContext);
        this.regionLayer.render(drawContext);
    }

    @Override
    public void doPreRender(DrawContext drawContext) {
        this.imageLayer.preRender(drawContext);
        this.regionLayer.preRender(drawContext);
    }

    protected static List<Renderable> makePolylines(GliderRegionOfInterest.RegionSet regionSet, double d) {
        ArrayList<Renderable> arrayList = new ArrayList<Renderable>(regionSet.regions.size());
        for (GliderRegionOfInterest gliderRegionOfInterest : regionSet.regions) {
            Polyline polyline = new Polyline(gliderRegionOfInterest.getLocations(), d);
            polyline.setClosed(true);
            polyline.setColor(gliderRegionOfInterest.getColor());
            polyline.setFollowTerrain(true);
            arrayList.add(polyline);
        }
        return arrayList;
    }

    protected class ImageListener
    implements PropertyChangeListener {
        protected ImageListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() != GliderImageLayer.this.image && propertyChangeEvent.getPropagationId() != GliderImageLayer.this.image) {
                return;
            }
            if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.glider.ImageSource") {
                GliderImageLayer.this.imageLayer.removeImage(((GliderImage)propertyChangeEvent.getSource()).getName());
                if (propertyChangeEvent.getNewValue() != null) {
                    try {
                        GliderImageLayer.this.setImage((GliderImage)propertyChangeEvent.getNewValue());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                propertyChangeEvent.setPropagationId(GliderImageLayer.this);
                GliderImageLayer.this.firePropertyChange(propertyChangeEvent);
            } else if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.glider.ImageOpacity") {
                if (propertyChangeEvent.getNewValue() == null) {
                    return;
                }
                GliderImageLayer.this.imageLayer.setOpacity(((GliderImage)propertyChangeEvent.getNewValue()).getOpacity());
                propertyChangeEvent.setPropagationId(GliderImageLayer.this);
                GliderImageLayer.this.firePropertyChange(propertyChangeEvent);
            } else if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.glider.RegionOfInterest" || propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.glider.RegionsOfInterest") {
                GliderImageLayer.this.regionLayer.removeAllRenderables();
                GliderRegionOfInterest.RegionSet regionSet = (GliderRegionOfInterest.RegionSet)propertyChangeEvent.getNewValue();
                if (regionSet != null) {
                    GliderImageLayer.this.regionLayer.addRenderables(GliderImageLayer.makePolylines(regionSet, GliderImageLayer.this.image.getAltitude()));
                }
                propertyChangeEvent.setPropagationId(GliderImageLayer.this);
                GliderImageLayer.this.firePropertyChange(propertyChangeEvent);
            }
        }
    }
}

