/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwindx.applications.dataimporter.FileSet;
import gov.nasa.worldwindx.applications.dataimporter.FileSetMap;
import gov.nasa.worldwindx.applications.dataimporter.FileSetTableModel;
import gov.nasa.worldwindx.applications.dataimporter.TableCellColorRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableColumn;

public class FileSetTable
extends JTable {
    public FileSetTable(FileSetMap fileSetMap) {
        this.setModel(new FileSetTableModel(fileSetMap));
        this.setIntercellSpacing(new Dimension(10, 1));
        this.setRowHeight(36);
        this.setDefaultRenderer(Color.class, new TableCellColorRenderer(true));
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(10);
        tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(36);
        tableColumn = this.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(160);
        tableColumn = this.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(70);
        tableColumn = this.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(35);
        tableColumn = this.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(20);
    }

    public void setFileSetMap(FileSetMap fileSetMap) {
        ((FileSetTableModel)this.getModel()).setFileSetMap(fileSetMap);
    }

    public List<FileSet> getSelectedFileSets() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return null;
        }
        ArrayList<FileSet> arrayList = new ArrayList<FileSet>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.convertRowIndexToModel(nArray[i]);
            FileSet fileSet = ((FileSetTableModel)this.getModel()).getRow(n);
            arrayList.add(fileSet);
        }
        return arrayList;
    }

    public void scrollToFileSet(FileSet fileSet) {
        Integer n = ((FileSetTableModel)this.getModel()).getRowForFileSet(fileSet);
        if (n != null) {
            this.scrollToVisible(n, 0);
        }
    }

    public void scrollToVisible(int n, int n2) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = this.getCellRect(n, n2, true);
        Point point = jViewport.getViewPosition();
        rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
        jViewport.scrollRectToVisible(rectangle);
    }
}

