/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.dataimporter.DataInstaller;
import gov.nasa.worldwindx.applications.dataimporter.FileSet;
import gov.nasa.worldwindx.applications.dataimporter.FileSetFinder;
import gov.nasa.worldwindx.applications.dataimporter.FileSetHighlighter;
import gov.nasa.worldwindx.applications.dataimporter.FileSetTable;
import gov.nasa.worldwindx.applications.dataimporter.FileSetTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;

public class FileSetPanel
extends JPanel {
    protected WorldWindow wwd;
    protected FileSetFinder fileSetFinder;
    protected FileSetTable fileSetTable;
    protected FileSetHighlighter sectorHighlighter;
    protected JFileChooser fileChooser;
    protected Thread scanningThread;

    public FileSetPanel(WorldWindow worldWindow) {
        super(new BorderLayout(30, 30));
        this.wwd = worldWindow;
        this.setPreferredSize(new Dimension(1200, 400));
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("CancelSelection")) {
                    if (FileSetPanel.this.scanningThread != null && FileSetPanel.this.scanningThread.isAlive()) {
                        FileSetPanel.this.scanningThread.interrupt();
                    }
                    return;
                }
                File[] fileArray = FileSetPanel.this.fileChooser.getSelectedFiles();
                if (fileArray != null && fileArray.length > 0) {
                    FileSetPanel.this.resetTable(fileArray);
                }
            }
        });
        this.enableCancelAction(false);
        this.add((Component)this.fileChooser, "West");
        JPanel jPanel = this.createTablePanel();
        this.add((Component)jPanel, "Center");
        this.sectorHighlighter = new FileSetHighlighter(this.wwd, this);
    }

    protected JButton findCancelButton(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JButton jButton;
            Component component = container.getComponent(i);
            if (component instanceof JButton) {
                jButton = (JButton)component;
                if (!UIManager.getString("FileChooser.cancelButtonText").equals(jButton.getText())) continue;
                return jButton;
            }
            if (!(component instanceof Container) || (jButton = this.findCancelButton((Container)component)) == null) continue;
            return jButton;
        }
        return null;
    }

    protected void enableCancelAction(boolean bl) {
        JButton jButton = this.findCancelButton(this.fileChooser);
        if (jButton != null) {
            jButton.setEnabled(bl);
        }
    }

    protected void resetTable(final File[] fileArray) {
        this.fileSetTable.setFileSetMap(null);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.enableCancelAction(true);
        this.scanningThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    FileSetPanel.this.fileSetFinder.findFileSets(fileArray);
                }
                catch (Exception exception) {
                    try {
                        Logging.logger().log(Level.SEVERE, "Exception while finding available data", exception);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FileSetPanel.this.fileSetTable.setFileSetMap(FileSetPanel.this.fileSetFinder.getFileSetMap());
                                FileSetPanel.this.setCursor(Cursor.getDefaultCursor());
                                FileSetPanel.this.enableCancelAction(false);
                                FileSetPanel.this.scanningThread = null;
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        this.scanningThread.start();
    }

    protected JPanel createTablePanel() {
        this.fileSetFinder = new FileSetFinder();
        this.fileSetTable = new FileSetTable(null);
        JScrollPane jScrollPane = new JScrollPane(this.fileSetTable);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(new EmptyBorder(20, 5, 5, 20));
        jPanel.add((Component)jScrollPane, "Center");
        JButton jButton = new JButton(new AbstractAction("Install Selected Data"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<FileSet> arrayList = new ArrayList<FileSet>();
                int[] nArray = FileSetPanel.this.fileSetTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = FileSetPanel.this.fileSetTable.convertRowIndexToModel(nArray[i]);
                    FileSet fileSet = ((FileSetTableModel)FileSetPanel.this.fileSetTable.getModel()).getRow(n);
                    if (fileSet == null) continue;
                    arrayList.add(fileSet);
                }
                final List<FileSet> list = FileSetPanel.this.fileSetFinder.consolidateFileSets(arrayList);
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        FileSetPanel.this.performInstallation(list);
                    }
                });
                thread.start();
            }
        });
        jPanel.add((Component)jButton, "South");
        return jPanel;
    }

    public void addSelectionListener(ListSelectionListener listSelectionListener) {
        this.fileSetTable.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public List<FileSet> getSelectedFileSets() {
        return this.fileSetTable.getSelectedFileSets();
    }

    public void scrollToFileSet(FileSet fileSet) {
        this.fileSetTable.scrollToFileSet(fileSet);
    }

    protected void performInstallation(List<FileSet> list) {
        DataInstaller dataInstaller = new DataInstaller();
        for (final FileSet fileSet : list) {
            try {
                final Document document = dataInstaller.installDataFromFiles(this, fileSet);
                if (document == null || this.wwd == null) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataInstaller.addToWorldWindow(FileSetPanel.this.wwd, document.getDocumentElement(), fileSet, true);
                        FileSetPanel.this.firePropertyChange("gov.nasa.worldwindx.dataimport.DataInstaller.InstallComplete", document, null);
                    }
                });
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "Exception performing installation", exception);
            }
        }
    }
}

