/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.antenna;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.applications.antenna.AntennaAxes;
import gov.nasa.worldwindx.applications.antenna.AntennaModel;
import gov.nasa.worldwindx.applications.antenna.Interpolator2D;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.io.InputStream;

public class AntennaViewer
extends ApplicationTemplate {
    protected static Position ANTENNA_POSITION = Position.fromDegrees(35.0, -120.0, 1000.0);

    private static Interpolator2D makeInterpolator() {
        Interpolator2D interpolator2D = new Interpolator2D();
        interpolator2D.setWrapT(true);
        try {
            InputStream inputStream = WWIO.openFileOrResourceStream("gov/nasa/worldwindx/examples/data/ThetaPhi3.antennaTestFile.txt", AntennaViewer.class);
            interpolator2D.addFromStream(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return interpolator2D;
    }

    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", AntennaViewer.ANTENNA_POSITION.getLatitude().degrees);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", AntennaViewer.ANTENNA_POSITION.getLongitude().degrees);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 10000.0);
        ApplicationTemplate.start("World Wind Antenna Gain Visualization", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineOpacity(0.6);
            basicShapeAttributes.setInteriorOpacity(0.4);
            basicShapeAttributes.setOutlineMaterial(Material.WHITE);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes(basicShapeAttributes);
            basicShapeAttributes2.setOutlineOpacity(0.3);
            basicShapeAttributes2.setInteriorOpacity(0.6);
            AntennaModel antennaModel = new AntennaModel(AntennaViewer.makeInterpolator());
            antennaModel.setAltitudeMode(2);
            antennaModel.setPosition(ANTENNA_POSITION);
            antennaModel.setAzimuth(Angle.fromDegrees(30.0));
            antennaModel.setElevationAngle(Angle.fromDegrees(20.0));
            antennaModel.setAttributes(basicShapeAttributes);
            antennaModel.setHighlightAttributes(basicShapeAttributes2);
            antennaModel.setGainOffset(640.0);
            antennaModel.setGainScale(10.0);
            AntennaAxes antennaAxes = new AntennaAxes();
            antennaAxes.setLength(2.0 * antennaModel.getGainOffset());
            antennaAxes.setRadius(0.02 * antennaAxes.getLength());
            antennaAxes.setAltitudeMode(antennaModel.getAltitudeMode());
            antennaAxes.setPosition(antennaModel.getPosition());
            antennaAxes.setAzimuth(antennaModel.getAzimuth());
            antennaAxes.setElevationAngle(antennaModel.getElevationAngle());
            BasicShapeAttributes basicShapeAttributes3 = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorOpacity(0.5);
            basicShapeAttributes3.setInteriorMaterial(Material.RED);
            basicShapeAttributes3.setEnableLighting(true);
            antennaAxes.setAttributes(basicShapeAttributes3);
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.addRenderable(antennaModel);
            renderableLayer.setName("Antenna Gain");
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            renderableLayer = new RenderableLayer();
            renderableLayer.addRenderable(antennaAxes);
            renderableLayer.setName("Antenna Axes");
            renderableLayer.setPickEnabled(false);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

