/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import com.google.common.base.Function;
import com.google.common.collect.ComputationException;
import com.google.common.collect.MapMaker;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.metadata.cache.ScopeModel;
import org.jboss.weld.metadata.cache.StereotypeModel;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.reflection.Reflections;

public class MetaAnnotationStore
implements Service {
    private final ConcurrentMap<Class<Annotation>, StereotypeModel<Annotation>> stereotypes;
    private final ConcurrentMap<Class<Annotation>, ScopeModel<Annotation>> scopes;
    private final ConcurrentMap<Class<Annotation>, QualifierModel<Annotation>> qualifiers;
    private final ConcurrentMap<Class<Annotation>, InterceptorBindingModel<Annotation>> interceptorBindings;

    public MetaAnnotationStore(ClassTransformer classTransformer) {
        MapMaker mapMaker = new MapMaker();
        this.stereotypes = mapMaker.makeComputingMap(new StereotypeFunction(classTransformer));
        this.scopes = mapMaker.makeComputingMap(new ScopeFunction(classTransformer));
        this.qualifiers = mapMaker.makeComputingMap(new QualifierFunction(classTransformer));
        this.interceptorBindings = mapMaker.makeComputingMap(new InterceptorBindingFunction(classTransformer));
    }

    public void clearAnnotationData(Class<? extends Annotation> annotationClass) {
        this.stereotypes.remove(annotationClass);
        this.scopes.remove(annotationClass);
        this.qualifiers.remove(annotationClass);
        this.interceptorBindings.remove(annotationClass);
    }

    public <T extends Annotation> StereotypeModel<T> getStereotype(Class<T> stereotype) {
        return (StereotypeModel)Reflections.cast(this.stereotypes.get(stereotype));
    }

    public <T extends Annotation> ScopeModel<T> getScopeModel(Class<T> scope) {
        return (ScopeModel)Reflections.cast(this.scopes.get(scope));
    }

    public <T extends Annotation> QualifierModel<T> getBindingTypeModel(Class<T> bindingType) {
        return (QualifierModel)Reflections.cast(this.qualifiers.get(bindingType));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Metadata cache\n");
        buffer.append("Registered binding type models: ").append(this.qualifiers.size()).append("\n");
        buffer.append("Registered scope type models: ").append(this.scopes.size()).append("\n");
        buffer.append("Registered stereotype models: ").append(this.stereotypes.size()).append("\n");
        buffer.append("Registered interceptor binding models: ").append(this.interceptorBindings.size()).append("\n");
        return buffer.toString();
    }

    @Override
    public void cleanup() {
        this.qualifiers.clear();
        this.scopes.clear();
        this.stereotypes.clear();
        this.interceptorBindings.clear();
    }

    public <T extends Annotation> InterceptorBindingModel<T> getInterceptorBindingModel(Class<T> interceptorBinding) {
        try {
            return (InterceptorBindingModel)Reflections.cast(this.interceptorBindings.get(interceptorBinding));
        }
        catch (ComputationException e) {
            if (e.getCause() instanceof DeploymentException || e.getCause() instanceof DefinitionException) {
                throw (WeldException)e.getCause();
            }
            throw e;
        }
    }

    private static abstract class AbstractMetaAnnotationFunction<M extends AnnotationModel<Annotation>>
    implements Function<Class<Annotation>, M> {
        private final ClassTransformer classTransformer;

        private AbstractMetaAnnotationFunction(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        public ClassTransformer getClassTransformer() {
            return this.classTransformer;
        }
    }

    private static class InterceptorBindingFunction
    extends AbstractMetaAnnotationFunction<InterceptorBindingModel<Annotation>> {
        public InterceptorBindingFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        @Override
        public InterceptorBindingModel<Annotation> apply(Class<Annotation> from) {
            return new InterceptorBindingModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }

    private static class QualifierFunction
    extends AbstractMetaAnnotationFunction<QualifierModel<Annotation>> {
        public QualifierFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        @Override
        public QualifierModel<Annotation> apply(Class<Annotation> from) {
            return new QualifierModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }

    private static class ScopeFunction
    extends AbstractMetaAnnotationFunction<ScopeModel<Annotation>> {
        public ScopeFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        @Override
        public ScopeModel<Annotation> apply(Class<Annotation> from) {
            return new ScopeModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }

    private static class StereotypeFunction
    extends AbstractMetaAnnotationFunction<StereotypeModel<Annotation>> {
        public StereotypeFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        @Override
        public StereotypeModel<Annotation> apply(Class<Annotation> from) {
            return new StereotypeModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }
}

