/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.exceptions.CreationException;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.AroundConstructCallback;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.producer.AbstractInstantiator;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.slf4j.cal10n.LocLogger;

public class DefaultInstantiator<T>
extends AbstractInstantiator<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private final ConstructorInjectionPoint<T> constructor;
    private final boolean producible;

    public DefaultInstantiator(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl manager) {
        EnhancedAnnotatedConstructor<T> constructor;
        if (type.getJavaClass().isInterface()) {
            throw new DefinitionException(BeanMessage.INJECTION_TARGET_CANNOT_BE_CREATED_FOR_INTERFACE, type);
        }
        boolean producible = true;
        if (type.isAbstract()) {
            log.warn(BeanMessage.INJECTION_TARGET_CREATED_FOR_ABSTRACT_CLASS, type.getJavaClass());
            producible = false;
        }
        if ((constructor = Beans.getBeanConstructor(type)) == null) {
            if (bean != null) {
                throw new DefinitionException(BeanMessage.INJECTION_TARGET_CREATED_FOR_CLASS_WITHOUT_APPROPRIATE_CONSTRUCTOR, type.getJavaClass());
            }
            producible = false;
            this.constructor = null;
            log.warn(BeanMessage.INJECTION_TARGET_CREATED_FOR_CLASS_WITHOUT_APPROPRIATE_CONSTRUCTOR, type.getJavaClass());
        } else {
            this.constructor = InjectionPointFactory.instance().createConstructorInjectionPoint(bean, type.getJavaClass(), constructor, manager);
        }
        this.producible = producible;
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager, AroundConstructCallback<T> callback) {
        if (!this.producible) {
            throw new CreationException(BeanMessage.INJECTION_TARGET_CANNOT_PRODUCE_INSTANCE, new Object[0]);
        }
        return super.newInstance(ctx, manager, callback);
    }

    @Override
    public ConstructorInjectionPoint<T> getConstructorInjectionPoint() {
        return this.constructor;
    }

    @Override
    public Constructor<T> getConstructor() {
        if (this.constructor == null) {
            return null;
        }
        return this.constructor.getAnnotated().getJavaMember();
    }

    public List<ParameterInjectionPoint<?, T>> getParameterInjectionPoints() {
        if (this.constructor == null) {
            return Collections.emptyList();
        }
        return this.constructor.getParameterInjectionPoints();
    }

    public String toString() {
        return "SimpleInstantiator [constructor=" + this.constructor.getMember() + "]";
    }

    @Override
    public boolean hasInterceptorSupport() {
        return false;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return false;
    }
}

