/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.wanderer;

import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.wanderer.Wanderer;
import com.bbn.openmap.util.wanderer.WandererCallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class OneWaySync
extends Wanderer
implements WandererCallback {
    protected File src;
    protected File tgt;
    public String[] dirSuffixAvoids = null;
    public String[] fileSuffixAvoids = null;
    public String[] dirSuffixLimits = null;
    public String[] fileSuffixLimits = null;
    protected LinkedList notCopiedList = new LinkedList();
    protected boolean verbose = false;
    protected boolean fakeit = false;
    protected boolean overwrite = true;

    public OneWaySync(String srcDirName, String targetDirName) {
        this.setCallback(this);
        this.src = new File(srcDirName);
        this.tgt = new File(targetDirName);
    }

    protected boolean checkToSkipDirectory(String name) {
        int i;
        if (this.dirSuffixAvoids != null) {
            for (i = 0; i < this.dirSuffixAvoids.length; ++i) {
                if (!name.endsWith(this.dirSuffixAvoids[i])) continue;
                return true;
            }
        }
        if (this.dirSuffixLimits != null) {
            for (i = 0; i < this.dirSuffixLimits.length; ++i) {
                if (!name.endsWith(this.dirSuffixLimits[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean checkToSkipFile(String name) {
        int i;
        if (this.fileSuffixAvoids != null) {
            for (i = 0; i < this.fileSuffixAvoids.length; ++i) {
                if (!name.endsWith(this.fileSuffixAvoids[i])) continue;
                return true;
            }
        }
        if (this.fileSuffixLimits != null) {
            for (i = 0; i < this.fileSuffixLimits.length; ++i) {
                if (!name.endsWith(this.fileSuffixLimits[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void handleDirectory(File directory, String[] contentNames) {
        String newDirName = this.getRelativePathFromSource(directory);
        if (newDirName == null) {
            if (directory != this.src) {
                this.notCopiedList.add(directory);
            }
            super.handleDirectory(directory, contentNames);
            return;
        }
        if (!this.checkToSkipDirectory(newDirName)) {
            File newDir = this.getTargetFile(newDirName);
            if (!newDir.exists()) {
                if (this.verbose) {
                    Debug.output("Creating " + newDir);
                }
                if (!this.fakeit && this.overwrite) {
                    newDir.mkdir();
                }
            }
            super.handleDirectory(directory, contentNames);
        } else {
            this.notCopiedList.add(directory);
        }
    }

    public void handleDirectory(File file) {
    }

    public void handleFile(File file) {
        String newFileName = this.getRelativePathFromSource(file);
        if (!this.checkToSkipFile(newFileName)) {
            File newFile = this.getTargetFile(newFileName);
            if (this.verbose) {
                Debug.output("Copying " + file + " to " + newFile);
            }
            if (!this.fakeit && this.overwrite) {
                this.copy(file, newFile);
            }
        } else {
            this.notCopiedList.add(file);
        }
    }

    public void copy(File fromFile, File toFile) {
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            FileOutputStream fos = new FileOutputStream(toFile);
            int num = 0;
            byte[] stuff = new byte[4096];
            while ((num = fis.read(stuff)) > 0) {
                fos.write(stuff, 0, num);
            }
            fis.close();
            fos.close();
        }
        catch (IOException ioe) {
            Debug.error("Exception reading from " + fromFile + " and writing to " + toFile);
        }
    }

    public String getRelativePathFromSource(File file) {
        return this.subtractPathFromDirectory(this.src, file);
    }

    public String getRelativePathFromTarget(File file) {
        return this.subtractPathFromDirectory(this.tgt, file);
    }

    public File getSourceFile(String relativePath) {
        return new File(this.src, relativePath);
    }

    public File getTargetFile(String relativePath) {
        return new File(this.tgt, relativePath);
    }

    public void writeUnsynched() {
        Iterator it = this.notCopiedList.iterator();
        while (it.hasNext()) {
            Debug.output("  " + it.next());
        }
    }

    public void checkTargetSolos() {
        new BackCheck(this.tgt.getPath(), this.src.getPath());
    }

    protected String subtractPathFromDirectory(File dir, File file) {
        String dirName;
        String name = file.getPath();
        if (name.equals(dirName = dir.getPath())) {
            if (this.verbose) {
                Debug.output("OneWaySync avoiding subtraction operation on top-level directory");
            }
            return null;
        }
        int index = name.indexOf(dirName);
        if (index != -1) {
            try {
                String relative = name.substring(index + dirName.length() + 1);
                if (Debug.debugging("sync")) {
                    Debug.output("From " + file + ", returning " + relative);
                }
                return relative;
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                Debug.output("Problem clipping first " + (dirName.length() + 1) + " characters off " + file);
                return null;
            }
        }
        Debug.error("File " + file + " is not in directory " + dir);
        return null;
    }

    public void start() {
        String errorMessage = null;
        if (this.src == null) {
            errorMessage = "OneWaySync:  Source directory unspecified";
        } else if (!this.src.exists()) {
            errorMessage = "OneWaySync:  Source directory (" + this.src + ") doesn't exist!";
        }
        if (this.tgt != null) {
            if (!this.tgt.exists()) {
                if (this.verbose) {
                    Debug.output("OneWaySync:  target directory (" + this.tgt + ") doesn't exist, creating...");
                }
                try {
                    if (!this.fakeit && !this.tgt.mkdir()) {
                        errorMessage = "OneWaySync:  target directory (" + this.tgt + ") can't be created.";
                    }
                }
                catch (SecurityException se) {
                    errorMessage = "OneWaySync:  creating target directory (" + this.tgt + ") isn't allowed, Security Exception: " + se.getMessage();
                    se.printStackTrace();
                }
            }
        } else {
            errorMessage = "OneWaySync:  target directory unspecified";
        }
        if (errorMessage != null) {
            Debug.error(errorMessage);
            System.exit(0);
        }
        this.handleEntry(this.src);
    }

    public void setVerbose(boolean val) {
        this.verbose = val;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setFakeit(boolean val) {
        this.fakeit = val;
    }

    public boolean getFakeit() {
        return this.fakeit;
    }

    public void setDirSuffixAvoids(String[] avoids) {
        this.dirSuffixAvoids = avoids;
    }

    public void setFileSuffixAvoids(String[] avoids) {
        this.fileSuffixAvoids = avoids;
    }

    public void setDirSuffixLimits(String[] limits) {
        this.dirSuffixLimits = limits;
    }

    public void setFileSuffixLimits(String[] limits) {
        this.fileSuffixLimits = limits;
    }

    public static void main(String[] argv) {
        String[] targetDir;
        String[] sourceDir;
        Debug.init();
        ArgParser ap = new ArgParser("OneWaySync");
        ap.add("source", "The source directory to copy files and directories from.", 1);
        ap.add("target", "The target directory to receive the updated files and directories.", 1);
        ap.add("verbose", "Announce all changes, failures will still be reported.");
        ap.add("fakeit", "Just print what would happen, don't really do anything.");
        ap.add("report", "Print out what didn't get copied, and what files exist only on the target side.");
        if (argv.length < 4) {
            ap.bail("", true);
        }
        ap.parse(argv);
        boolean verbose = false;
        String[] verb = ap.getArgValues("verbose");
        if (verb != null) {
            verbose = true;
        }
        boolean fakeit = false;
        verb = ap.getArgValues("fakeit");
        if (verb != null) {
            verbose = true;
            fakeit = true;
        }
        boolean report = false;
        verb = ap.getArgValues("report");
        if (verb != null) {
            report = true;
        }
        if ((sourceDir = ap.getArgValues("source")) != null || sourceDir.length < 1) {
            if (verbose) {
                Debug.output("Source directory is " + sourceDir[0]);
            }
        } else {
            ap.bail("OneWaySync needs path to source directory", false);
        }
        if ((targetDir = ap.getArgValues("target")) != null || targetDir.length < 1) {
            if (verbose) {
                Debug.output("Target directory is " + targetDir[0]);
            }
        } else {
            ap.bail("OneWaySync needs path to source directory", false);
        }
        OneWaySync cc = new OneWaySync(sourceDir[0], targetDir[0]);
        cc.setVerbose(verbose);
        cc.setFakeit(fakeit);
        cc.setDirSuffixAvoids(new String[]{"CVS"});
        cc.setFileSuffixLimits(new String[]{".java", "Makefile", ".cvsignore", ".html", ".properties", ".txt", ".c", ".h"});
        cc.start();
        if (report) {
            Debug.output("-------- Not Copied --------");
            cc.writeUnsynched();
            Debug.output("----------------------------");
            cc.checkTargetSolos();
        }
    }

    public static class BackCheck
    extends OneWaySync {
        public BackCheck(String targetDirName, String srcDirName) {
            super(targetDirName, srcDirName);
            this.fakeit = true;
            this.overwrite = false;
            if (Debug.debugging("sync")) {
                this.verbose = true;
            }
            this.start();
            Debug.output("-------- Only In Target Directory--------");
            this.writeUnsynched();
            Debug.output("-----------------------------------------");
        }

        public void handleDirectory(File directory, String[] contentNames) {
            String newDirName = this.getRelativePathFromSource(directory);
            if (newDirName == null) {
                super.handleDirectory(directory, contentNames);
                return;
            }
            File newDir = this.getTargetFile(newDirName);
            if (!newDir.exists()) {
                this.notCopiedList.add(directory);
            }
            super.handleDirectory(directory, contentNames);
        }

        public void handleFile(File file) {
            if (!this.getTargetFile(this.getRelativePathFromSource(file)).exists()) {
                this.notCopiedList.add(file);
            }
        }
    }
}

