/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

public class VHTransform {
    public static final double K1 = 0.99435487;
    public static final double K2 = 0.00336523;
    public static final double K3 = -6.5596E-4;
    public static final double K4 = 5.606E-5;
    public static final double K5 = -1.88E-6;
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double EX = 0.40426992;
    public static final double EY = 0.68210848;
    public static final double EZ = 0.60933887;
    public static final double WX = 0.65517646;
    public static final double WY = 0.3773379;
    public static final double WZ = 0.6544921;
    public static final double PX = -0.5559778217300487;
    public static final double PY = -0.3457284881610899;
    public static final double PZ = 0.7558839026055241;
    public static final double rot = VHTransform.radians(76.597497064);
    public static final double ROTC = Math.cos(rot);
    public static final double ROTS = Math.sin(rot);
    public static final double TRANSV = 6363.235;
    public static final double TRANSH = 2250.7;
    public static final double RADIUS = 12481.103;
    public static final double K9 = 12481.103 * ROTC;
    public static final double K10 = 12481.103 * ROTS;
    private double resultV = 0.0;
    private double resultH = 0.0;
    private double resultLat = 0.0;
    private double resultLon = 0.0;

    public static double radians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static double degrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    public double getV() {
        return this.resultV;
    }

    public double getH() {
        return this.resultH;
    }

    public double getLat() {
        return this.resultLat;
    }

    public double getLon() {
        return this.resultLon;
    }

    public static double distance(double v1, double h1, double v2, double h2) {
        double dv = v2 - v1;
        double dh = h2 - h1;
        return Math.sqrt((dv * dv + dh * dh) / 10.0);
    }

    public void toVH(double lat, double lon) {
        lat = VHTransform.radians(lat);
        lon = VHTransform.radians(lon);
        double lon1 = lon + VHTransform.radians(52.0);
        double latsq = lat * lat;
        double lat1 = lat * (0.99435487 + (0.00336523 + (-6.5596E-4 + (5.606E-5 + -1.88E-6 * latsq) * latsq) * latsq) * latsq);
        double cos_lat1 = Math.cos(lat1);
        double x = cos_lat1 * Math.sin(-lon1);
        double y = cos_lat1 * Math.cos(-lon1);
        double z = Math.sin(lat1);
        double e = 0.40426992 * x + 0.68210848 * y + 0.60933887 * z;
        double w = 0.65517646 * x + 0.3773379 * y + 0.6544921 * z;
        e = e > 1.0 ? 1.0 : e;
        w = w > 1.0 ? 1.0 : w;
        e = 1.5707963267948966 - Math.atan(e / Math.sqrt(1.0 - e * e));
        w = 1.5707963267948966 - Math.atan(w / Math.sqrt(1.0 - w * w));
        double ht = (e * e - w * w + 0.16) / 0.8;
        double vt = Math.sqrt(Math.abs(e * e - ht * ht));
        vt = -0.5559778217300487 * x + -0.3457284881610899 * y + 0.7558839026055241 * z < 0.0 ? -vt : vt;
        double v = 6363.235 + K9 * ht - K10 * vt;
        double h = 2250.7 + K10 * ht + K9 * vt;
        this.resultV = v;
        this.resultH = h;
    }

    public void toLatLon(double v0, double h0) {
        double y;
        double x;
        double z;
        double c;
        double fy;
        double GX = 0.21650796190883498;
        double GY = -0.1346330148793682;
        double A = 0.1516466456210773;
        double Q = -0.2943550566164128;
        double Q2 = 0.08664489935565158;
        double EPSILON = 1.0E-7;
        double v = v0;
        double h = h0;
        double t1 = (v - 6363.235) / 12481.103;
        double t2 = (h - 2250.7) / 12481.103;
        double vhat = ROTC * t2 - ROTS * t1;
        double hhat = ROTS * t2 + ROTC * t1;
        double e = Math.cos(Math.sqrt(vhat * vhat + hhat * hhat));
        double w = Math.cos(Math.sqrt(vhat * vhat + (hhat - 0.4) * (hhat - 0.4)));
        double fx = 0.68210848 * w - 0.3773379 * e;
        double b = fx * 0.21650796190883498 + (fy = 0.40426992 * w - 0.65517646 * e) * -0.1346330148793682;
        double disc = b * b - 0.1516466456210773 * (c = fx * fx + fy * fy - 0.08664489935565158);
        if (Math.abs(disc) < 1.0E-7) {
            z = b / 0.1516466456210773;
            x = (0.21650796190883498 * z - fx) / -0.2943550566164128;
            y = (fy - -0.1346330148793682 * z) / -0.2943550566164128;
        } else {
            double delta = Math.sqrt(disc);
            z = (b + delta) / 0.1516466456210773;
            x = (0.21650796190883498 * z - fx) / -0.2943550566164128;
            if (vhat * (-0.5559778217300487 * x + -0.3457284881610899 * (y = (fy - -0.1346330148793682 * z) / -0.2943550566164128) + 0.7558839026055241 * z) < 0.0) {
                z = (b - delta) / 0.1516466456210773;
                x = (0.21650796190883498 * z - fx) / -0.2943550566164128;
                y = (fy - -0.1346330148793682 * z) / -0.2943550566164128;
            }
        }
        double lat = Math.asin(z);
        double[] bi = new double[]{1.0056772492072246, -0.0034423042556021026, 7.13971534527668E-4, -7.772400534992791E-5, 6.731803670532443E-6, -7.425953388857414E-7, 9.050589199261941E-8};
        double lat2 = lat * lat;
        double earthlat = lat * (bi[0] + lat2 * (bi[1] + lat2 * (bi[2] + lat2 * (bi[3] + lat2 * (bi[4] + lat2 * (bi[5] + lat2 * bi[6]))))));
        earthlat = VHTransform.degrees(earthlat);
        double lon = VHTransform.degrees(Math.atan2(x, y));
        double earthlon = lon + 52.0;
        this.resultLat = earthlat;
        this.resultLon = -earthlon;
    }

    public void toLatLon(int v0, int h0) {
        this.toLatLon((double)v0, (double)h0);
    }
}

