/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.roads;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.tools.roads.RoadGraphic;
import com.bbn.openmap.tools.roads.RoadLayer;
import com.bbn.openmap.tools.roads.RoadObject;
import com.bbn.openmap.tools.roads.Visual;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.logging.Logger;

public abstract class Waypoint
extends Visual
implements Serializable {
    protected LatLonPoint location;
    protected Point screenLocation = null;
    private boolean modified = false;
    static /* synthetic */ Class class$com$bbn$openmap$tools$roads$Waypoint$Graphic;

    public Waypoint(LatLonPoint loc, RoadLayer layer) {
        this.location = loc;
        this.layer = layer;
    }

    public static Class getGraphicClass() {
        return class$com$bbn$openmap$tools$roads$Waypoint$Graphic == null ? (class$com$bbn$openmap$tools$roads$Waypoint$Graphic = Waypoint.class$("com.bbn.openmap.tools.roads.Waypoint$Graphic")) : class$com$bbn$openmap$tools$roads$Waypoint$Graphic;
    }

    public void setModified(boolean newValue) {
        this.modified = newValue;
    }

    public boolean getModified() {
        return this.modified;
    }

    public LatLonPoint getLocation() {
        return this.location;
    }

    public void setLocation(LatLonPoint loc) {
        this.location = loc;
        this.update();
    }

    public Point getScreenLocation() {
        if (this.screenLocation == null) {
            this.screenLocation = this.getRoadLayer().getProjection().forward(this.location);
        }
        return this.screenLocation;
    }

    public void setScreenLocation(Point loc) {
        this.setLocation(this.getRoadLayer().getProjection().inverse(loc.x, loc.y));
    }

    public void update() {
        super.update();
        this.screenLocation = null;
    }

    public RoadLayer getRoadLayer() {
        return this.layer;
    }

    public void moveTo(Point loc) {
        this.setScreenLocation(loc);
    }

    public float getLatitude() {
        return this.getLocation().getLatitude();
    }

    public float getLongitude() {
        return this.getLocation().getLongitude();
    }

    public abstract void render(OMGraphicList var1, boolean var2);

    public String toString() {
        return "Waypoint : location " + this.location;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract class Graphic
    extends OMRect
    implements RoadGraphic {
        Logger logger = Logger.getLogger(this.getClass().getName());
        private boolean blinkState = false;

        protected Graphic(int radius) {
            super(Waypoint.this.getLocation().getLatitude(), Waypoint.this.getLocation().getLongitude(), -radius, -radius, radius, radius);
            this.setLinePaint(Color.black);
        }

        public void blink(boolean newState) {
            this.blinkState = newState;
        }

        public void render(Graphics g) {
            if (!this.blinkState) {
                super.render(g);
            }
        }

        public abstract RoadObject getRoadObject();
    }
}

