/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.icon;

import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.tools.icon.BasicIconPart;
import com.bbn.openmap.tools.icon.IconPart;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IconPartList
implements IconPart {
    protected List parts;
    protected DrawingAttributes renderingAttributes = null;
    protected Shape clip = null;

    protected List getList() {
        if (this.parts == null) {
            this.parts = new LinkedList();
        }
        return this.parts;
    }

    public Iterator iterator() {
        return this.parts.iterator();
    }

    public void add(IconPart part) {
        this.getList().add(part);
    }

    public boolean remove(IconPart part) {
        return this.getList().remove(part);
    }

    public void clear() {
        this.getList().clear();
    }

    public void render(Graphics g, int width, int height) {
        this.render(g, width, height, null);
    }

    public void render(Graphics g, int width, int height, DrawingAttributes appDA) {
        Shape clip = this.getClip();
        if (clip != null) {
            g.setClip(clip);
        }
        DrawingAttributes da = this.getRenderingAttributes();
        DrawingAttributes tmpDA = null;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            IconPart part = (IconPart)it.next();
            if (da != null) {
                tmpDA = part.getRenderingAttributes();
                part.setRenderingAttributes(da);
            }
            Graphics2D g2 = (Graphics2D)g.create();
            part.render(g2, width, height);
            g2.dispose();
            if (da == null) continue;
            part.setRenderingAttributes(tmpDA);
            tmpDA = null;
        }
    }

    public void setClip(Shape clipArea) {
        this.clip = clipArea;
    }

    public Shape getClip() {
        return this.clip;
    }

    public void setGeometry(Shape shape) {
        List list = this.getList();
        list.clear();
        list.add(new BasicIconPart(shape));
    }

    public Shape getGeometry() {
        Path2D geometry = null;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            IconPart part = (IconPart)it.next();
            Shape shp = part.getGeometry();
            if (shp == null) continue;
            if (geometry == null) {
                geometry = new GeneralPath(shp);
                continue;
            }
            geometry.append(shp, false);
        }
        return geometry;
    }

    public void setRenderingAttributes(DrawingAttributes da) {
        this.renderingAttributes = da;
    }

    public DrawingAttributes getRenderingAttributes() {
        return this.renderingAttributes;
    }

    public Object clone() {
        IconPartList clone = new IconPartList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            IconPart ip = (IconPart)it.next();
            clone.add((IconPart)ip.clone());
        }
        clone.setRenderingAttributes(this.getRenderingAttributes());
        clone.setClip(this.getClip());
        return clone;
    }
}

