/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.BasicProjectionLoader;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.UTMProjection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.Properties;

public class UTMProjectionLoader
extends BasicProjectionLoader {
    public static final String ZONE_NUMBER = "ZONE_NUMBER";
    public static final String ZONE_LETTER = "ZONE_LETTER";
    public static final String ELLIPSOID = "ELLIPSOID";
    static /* synthetic */ Class class$com$bbn$openmap$proj$UTMProjection;

    public UTMProjectionLoader() {
        super(class$com$bbn$openmap$proj$UTMProjection == null ? (class$com$bbn$openmap$proj$UTMProjection = UTMProjectionLoader.class$("com.bbn.openmap.proj.UTMProjection")) : class$com$bbn$openmap$proj$UTMProjection, "UTM Projection", "UTM Projection");
    }

    public Projection create(Properties props) throws ProjectionException {
        try {
            LatLonPoint center = (LatLonPoint)props.get("CENTER");
            float scale = PropUtils.floatFromProperties(props, "SCALE", 1.0E7f);
            int height = PropUtils.intFromProperties(props, "HEIGHT", 100);
            int width = PropUtils.intFromProperties(props, "WIDTH", 100);
            int type = 993387;
            int zone_number = PropUtils.intFromProperties(props, ZONE_NUMBER, 0);
            char zone_letter = ((String)props.get(ZONE_LETTER)).charAt(0);
            boolean isnorthern = zone_letter == 'N';
            Ellipsoid ellps = (Ellipsoid)props.get(ELLIPSOID);
            return new UTMProjection(center, scale, width, height, type, zone_number, isnorthern, ellps);
        }
        catch (Exception e) {
            if (Debug.debugging("proj")) {
                Debug.output("UTMProjectionLoader: problem creating UTM projection " + e.getMessage());
                e.printStackTrace();
            }
            throw new ProjectionException("UTMProjectionLoader: problem creating UTM projection");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

