/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.coords.UTMPoint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class UTMProjection
extends Proj {
    protected Point2D.Double xycenter = new Point2D.Double();
    protected int hy;
    protected int wx;
    protected float ppu;
    protected Point world;
    protected int half_world;
    private int zone_number;
    private boolean isnorthern;
    private Ellipsoid ellps;
    public static final transient int UTMType = 993387;

    public UTMProjection(LatLonPoint center, float s, int w, int h, int type, int zone_number, boolean isnorthern, Ellipsoid ellps) {
        super(center, s, w, h, type);
        this.zone_number = zone_number;
        this.isnorthern = isnorthern;
        this.ellps = ellps;
    }

    protected void computeParameters() {
        this.hy = this.height / 2;
        this.wx = this.width / 2;
        if (this.xycenter != null) {
            UTMPoint c = UTMPoint.LLtoUTM(this.getCenter(), this.ellps, new UTMPoint(), this.zone_number, this.isnorthern);
            this.xycenter.setLocation(c.easting, c.northing);
        }
        if (this.world == null) {
            this.world = new Point();
        }
        this.world.x = (int)(this.planetPixelCircumference / this.scale);
        this.half_world = this.world.x / 2;
        this.ppu = (float)this.pixelsPerMeter / this.getScale();
    }

    public float normalize_latitude(float lat) {
        if (lat > 1.5707964f) {
            return 1.5707964f;
        }
        if (lat < -1.5707964f) {
            return -1.5707964f;
        }
        return lat;
    }

    public Point forward(LatLonPoint llp, Point pt) {
        return this.forward(llp, pt, new UTMPoint());
    }

    private Point forward(LatLonPoint llp, Point pt, UTMPoint utmPoint) {
        utmPoint = UTMPoint.LLtoUTM(llp, this.ellps, utmPoint, this.zone_number, this.isnorthern);
        pt.x = (int)((long)this.wx + Math.round((double)this.ppu * ((double)utmPoint.easting - this.xycenter.getX())));
        pt.y = (int)((long)this.hy - Math.round((double)this.ppu * ((double)utmPoint.northing - this.xycenter.getY())));
        return pt;
    }

    public Point forward(float lat, float lon, Point pt) {
        return this.forward(new LatLonPoint(lat, lon), pt);
    }

    public Point forward(float lat, float lon, Point pt, boolean isRadian) {
        LatLonPoint ll = new LatLonPoint();
        ll.setLatLon(lat, lon, isRadian);
        return this.forward(ll, pt);
    }

    public LatLonPoint inverse(Point point, LatLonPoint llpt) {
        return this.inverse(point.x, point.y, llpt);
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llpt) {
        double northing = this.xycenter.getY() + (double)((float)(this.hy - y) / this.ppu);
        double easting = this.xycenter.getX() + (double)((float)(x - this.wx) / this.ppu);
        llpt = UTMPoint.UTMtoLL(this.ellps, (float)northing, (float)easting, this.zone_number, this.isnorthern, llpt);
        return llpt;
    }

    public float getScale(LatLonPoint ll1, LatLonPoint ll2, Point point1, Point point2) {
        float widthPX = point2.x - point1.x;
        float heightPX = point2.y - point1.y;
        UTMPoint xx1 = UTMPoint.LLtoUTM(ll1, this.ellps, new UTMPoint(), this.zone_number, this.isnorthern);
        UTMPoint xx2 = UTMPoint.LLtoUTM(ll2, this.ellps, new UTMPoint(), this.zone_number, this.isnorthern);
        float widthMap = xx2.easting - xx1.easting;
        float widthScale = (float)((double)this.getPPM() * (double)(widthMap / widthPX));
        float heightMap = xx2.northing - xx1.northing;
        float heightScale = (float)((double)this.getPPM() * (double)(heightMap / heightPX));
        return widthScale;
    }

    public boolean isPlotable(float lat, float lon) {
        return true;
    }

    protected ArrayList _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        int j;
        int i;
        int flag = 0;
        int min = 0;
        int max = 0;
        int xadj = 0;
        int len = rawllpts.length >> 1;
        if (len < 2) {
            return new ArrayList(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        Point temp = new Point(0, 0);
        int[] xs = new int[len];
        int[] ys = new int[len];
        UTMPoint tempUtm = new UTMPoint();
        LatLonPoint tempLL = new LatLonPoint();
        tempLL.setLatLon(rawllpts[0], rawllpts[1], true);
        this.forward(tempLL, temp, tempUtm);
        int xp = temp.x;
        xs[0] = temp.x;
        ys[0] = temp.y;
        int n = 1;
        int k = 2;
        while (n < len) {
            tempLL.setLatLon(rawllpts[k], rawllpts[k + 1], true);
            this.forward(tempLL, temp, tempUtm);
            xs[n] = temp.x;
            ys[n] = temp.y;
            if (Math.abs(xp - xs[n]) >= this.half_world) {
                min = (flag += xp < xs[n] ? -1 : 1) < min ? flag : min;
                max = flag > max ? flag : max;
                xadj = flag * this.world.x;
            }
            xp = temp.x;
            if (flag != 0) {
                int n2 = n;
                xs[n2] = xs[n2] + xadj;
            }
            ++n;
            k += 2;
        }
        ArrayList<int[]> ret_val = null;
        ret_val = new ArrayList<int[]>(2 + 2 * (max + (min *= -1)));
        ret_val.add(xs);
        ret_val.add(ys);
        int[] altx = null;
        for (i = 1; i <= min; ++i) {
            altx = new int[xs.length];
            xadj = i * this.world.x;
            for (j = 0; j < altx.length; ++j) {
                altx[j] = xs[j] + xadj;
            }
            ret_val.add(altx);
            ret_val.add(ys);
        }
        for (i = 1; i <= max; ++i) {
            altx = new int[xs.length];
            xadj = -i * this.world.x;
            for (j = 0; j < altx.length; ++j) {
                altx[j] = xs[j] + xadj;
            }
            ret_val.add(altx);
            ret_val.add(ys);
        }
        return ret_val;
    }

    public void drawBackground(Graphics2D g, Paint paint) {
        g.setPaint(paint);
        this.drawBackground(g);
    }

    public void drawBackground(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public boolean forwardRaw(float[] rawllpts, int rawoff, int[] xcoords, int[] ycoords, boolean[] visible, int copyoff, int copylen) {
        Point temp = new Point();
        UTMPoint tempUtm = new UTMPoint();
        LatLonPoint tempLL = new LatLonPoint();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            tempLL.setLatLon(rawllpts[j], rawllpts[j + 1], true);
            this.forward(tempLL, temp, tempUtm);
            xcoords[i] = temp.x;
            ycoords[i] = temp.y;
            visible[i] = true;
            ++i;
            j += 2;
        }
        return true;
    }

    public LatLonPoint getLowerRight() {
        return this.inverse(this.width - 1, this.height - 1);
    }

    public LatLonPoint getUpperLeft() {
        return this.inverse(0, 0);
    }
}

