/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.PropUtils;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class ProjectionFactoryLoader
extends OMComponent {
    protected Vector loaders;
    public static final String ProjectionLoadersProperty = "projectionLoaders";

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.add(ProjectionFactory.getInstance());
            if (this.loaders != null && this.loaders.size() > 0) {
                Iterator it = this.loaders.iterator();
                while (it.hasNext()) {
                    in_bc.add(it.next());
                }
            }
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String loaderPrefixesString = props.getProperty(prefix + ProjectionLoadersProperty);
        if (loaderPrefixesString != null) {
            Vector loaderPrefixes = PropUtils.parseSpacedMarkers(loaderPrefixesString);
            this.loaders = ComponentFactory.create(loaderPrefixes, prefix, props);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.loaders != null) {
            StringBuffer markerlist = new StringBuffer();
            int count = 0;
            Iterator it = this.loaders.iterator();
            while (it.hasNext()) {
                String markerName;
                ProjectionLoader pl = (ProjectionLoader)it.next();
                if (pl instanceof PropertyConsumer) {
                    PropertyConsumer pc = (PropertyConsumer)((Object)pl);
                    markerName = pc.getPropertyPrefix();
                    props.put(markerName + ".class", pl.getClass().getName());
                    if (markerName.startsWith(prefix)) {
                        markerName = markerName.substring(prefix.length());
                    }
                    pc.getProperties(props);
                } else {
                    markerName = "projectionLoader" + count++;
                    props.put(markerName + ".class", pl.getClass().getName());
                }
                markerlist.append(" " + markerName);
            }
            props.put(prefix + ProjectionLoadersProperty, markerlist.toString());
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        return super.getPropertyInfo(props);
    }
}

