/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Azimuth;
import com.bbn.openmap.proj.Orthographic;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;

public class OrthographicView
extends Orthographic {
    public static final transient String OrthographicViewName = "OrthographicView";
    public static final transient int OrthographicViewType = 77;
    private OrthographicViewHelper helper;
    protected LatLonPoint uCtr;
    protected float uCtrLat;
    protected float uCtrLon;
    protected int sCtrX;
    protected int sCtrY;
    protected int uCtrX;
    protected int uCtrY;
    protected int dUSX;
    protected int dUSY;

    public OrthographicView(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height, 7);
        this.setMinScale(1000.0f);
        this.computeParameters();
    }

    public String toString() {
        return "OrthographicView[" + super.toString();
    }

    public void setCenter(float lat, float lon) {
        this.ctrLat = this.normalize_latitude(ProjMath.degToRad(lat));
        this.ctrLon = OrthographicView.wrap_longitude(ProjMath.degToRad(lon));
        this.computeParameters();
        this.projID = null;
    }

    public void setCenter(LatLonPoint pt) {
        this.setCenter(pt.getLatitude(), pt.getLongitude());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeParameters() {
        Debug.message("orthographicview", "OrthographicView.computeParameters()");
        if (this.uCtr == null) {
            this.uCtrLat = 0.0f;
            this.uCtrLon = 0.0f;
            this.uCtr = new LatLonPoint(this.uCtrLat, this.uCtrLon);
        }
        if (this.helper == null) {
            this.helper = new OrthographicViewHelper(this.uCtr, this.scale, this.width, this.height);
        }
        OrthographicViewHelper orthographicViewHelper = this.helper;
        synchronized (orthographicViewHelper) {
            super.computeParameters();
            Point temp = new Point();
            this.helper.setAllParams(this.pixelsPerMeter, this.planetRadius, this.planetPixelRadius, this.planetPixelCircumference, this.minscale, this.maxscale, this.scale, this.scaled_radius, this.width, this.height, this.uCtrLat, this.uCtrLon);
            this.hy = this.height / 2;
            this.wx = this.width / 2;
            this.helper.forward(this.ctrLat, this.ctrLon, temp, true);
            this.sCtrX = temp.x;
            this.sCtrY = temp.y;
            this.helper.forward(this.uCtrLat, this.uCtrLon, temp);
            this.uCtrX = temp.x;
            this.uCtrY = temp.y;
            this.dUSX = this.sCtrX - this.uCtrX;
            this.dUSY = this.sCtrY - this.uCtrY;
        }
        Debug.message("orthographicview", "User Center LL: " + this.uCtrLon + "," + this.uCtrLat + " User Center xy: " + this.uCtrX + "," + this.uCtrY + " Screen Center LL: " + ProjMath.radToDeg(this.ctrLon) + "," + ProjMath.radToDeg(this.ctrLat) + " Screen Center xy: " + this.sCtrX + "," + this.sCtrY + " Screen wh: " + this.width + "x" + this.height + " Screen halfwh: " + this.wx + "x" + this.hy + " Delta xy: " + this.dUSX + "," + this.dUSY);
    }

    protected Point _forward(float phi, float lambda, Point p, Azimuth.AzimuthVar azVar) {
        this.helper._forward(phi, lambda, p, azVar);
        Debug.message("orthographicview-f", "forward p,p,p,a: " + ProjMath.radToDeg(lambda) + "," + ProjMath.radToDeg(phi) + " orth xy: " + p.x + "," + p.y);
        p.x = p.x + this.wx - this.dUSX;
        p.y = this.hy - p.y + this.dUSY;
        Debug.message("orthographicview-f", "forward p,p,p,a: " + ProjMath.radToDeg(lambda) + "," + ProjMath.radToDeg(phi) + " view xy: " + p.x + "," + p.y);
        return p;
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
        int tx = x - this.wx + this.dUSX;
        int ty = this.hy - y + this.dUSY;
        LatLonPoint tllp = this.helper.inverse(tx, ty, llp);
        Debug.message("mercatorview-i", "xy: " + x + "," + y + " txty: " + tx + "," + ty + " llp: " + tllp.getLongitude() + "," + tllp.getLatitude());
        return this.helper.inverse(tx, ty, llp);
    }

    public LatLonPoint inverse(Point pt, LatLonPoint llp) {
        return this.inverse(pt.x, pt.y, llp);
    }

    public void drawBackground(Graphics2D g, Paint paint) {
        g.setPaint(paint);
        this.drawBackground(g);
    }

    public void drawBackground(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public LatLonPoint getUpperLeft() {
        return this.helper.getUpperLeft();
    }

    public LatLonPoint getLowerRight() {
        return this.helper.getLowerRight();
    }

    private class OrthographicViewHelper
    extends Orthographic {
        public OrthographicViewHelper(LatLonPoint center, float scale, int width, int height) {
            super(center, scale, width, height, 7);
        }

        public void setAllParams(int hPixelsPerMeter, float hPlanetRadius, float hPlanetPixelRadius, float hPlanetPixelCircumference, float hMinscale, float hMaxscale, float hScale, float hScaled_radius, int hWidth, int hHeight, float hCtrLat, float hCtrLon) {
            this.pixelsPerMeter = hPixelsPerMeter;
            this.planetRadius = hPlanetRadius;
            this.planetPixelRadius = hPlanetPixelRadius;
            this.planetPixelCircumference = hPlanetPixelCircumference;
            this.minscale = hMinscale;
            this.maxscale = hMaxscale;
            this.scale = hScale;
            this.scaled_radius = hScaled_radius;
            this.width = hWidth;
            this.height = hHeight;
            this.ctrLat = hCtrLat;
            this.ctrLon = hCtrLon;
            this.computeParameters();
        }

        public String toString() {
            return "OrthographicViewHelper[" + super.toString();
        }

        public Point _forward(float phi, float lambda, Point p, Azimuth.AzimuthVar azVar) {
            super._forward(phi, lambda, p, azVar);
            Debug.message("ortrhographicview-f", "forward p,l,l,a: " + ProjMath.radToDeg(lambda) + "," + ProjMath.radToDeg(phi) + " help xy: " + p.x + "," + p.y);
            p.x -= this.wx;
            p.y = this.hy - p.y;
            return p;
        }

        public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
            y = this.hy - y;
            return super.inverse(x += this.wx, y, llp);
        }
    }
}

