/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.util.Debug;

public class Length {
    public static final Length MILE = new Length("mile", "miles", 24901.460807187756);
    public static final Length FEET = new Length("feet", "feet", 1.3147971306195135E8);
    public static final Length METER = new Length("meter", "m", 4.007501668557849E7);
    public static final Length KM = new Length("kilometer", "km", 40075.016685578485);
    public static final Length NM = new Length("nautical mile", "nm", 21600.0);
    public static final Length DECIMAL_DEGREE = new Length("decimal degree", "deg", 360.0);
    public static final Length RADIAN = new Length("radian", "rad", Math.PI * 2);
    public static final Length DM = new Length("datamile", "dm", 21913.285510325226);
    protected final double constant;
    protected final String name;
    protected final String abbr;
    protected double unitEquatorCircumference;
    protected I18n i18n = Environment.getI18n();

    public Length(String name, String abbr, double unitEquatorCircumference) {
        this.name = this.i18n.get(this, abbr + ".name", name).toLowerCase().intern();
        this.unitEquatorCircumference = unitEquatorCircumference;
        this.constant = unitEquatorCircumference / (Math.PI * 2);
        this.abbr = abbr.toLowerCase().intern();
    }

    public float toRadians(float numUnits) {
        if (Debug.debugging("length")) {
            Debug.output("Translating " + this.name + " from radians");
        }
        return numUnits / (float)this.constant;
    }

    public double toRadians(double numUnits) {
        if (Debug.debugging("length")) {
            Debug.output("Translating " + this.name + " from radians");
        }
        return numUnits / this.constant;
    }

    public float fromRadians(float numRadians) {
        if (Debug.debugging("length")) {
            Debug.output("Translating radians from " + this.name);
        }
        return numRadians * (float)this.constant;
    }

    public double fromRadians(double numRadians) {
        if (Debug.debugging("length")) {
            Debug.output("Translating radians from " + this.name);
        }
        return numRadians * this.constant;
    }

    public String toString() {
        return this.name;
    }

    public String getAbbr() {
        return this.abbr;
    }

    public static Length[] getAvailable() {
        return new Length[]{METER, KM, FEET, MILE, DM, NM, DECIMAL_DEGREE};
    }

    public static Length get(String name) {
        Length[] choices = Length.getAvailable();
        for (int i = 0; i < choices.length; ++i) {
            if (name.toLowerCase().intern() != choices[i].toString() && name.toLowerCase().intern() != choices[i].getAbbr()) continue;
            return choices[i];
        }
        return null;
    }
}

