/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.BasicProjectionLoader;
import com.bbn.openmap.proj.LambertConformal;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.Properties;

public class LambertConformalLoader
extends BasicProjectionLoader
implements ProjectionLoader {
    public static final String CentralMeridianProperty = "centralMeridian";
    public static final String StandardParallelOneProperty = "standardParallel1";
    public static final String StandardParallelTwoProperty = "standardParallel2";
    public static final String ReferenceLatitudeProperty = "referenceLatitude";
    public static final String FalseEastingProperty = "falseEasting";
    public static final String FalseNorthingProperty = "faleNorthing";
    protected double centralMeridian = -71.5;
    protected double standardParallel1 = 41.71666717529297;
    protected double standardParallel2 = 42.68333435058594;
    protected double referenceLatitude = 41.0;
    protected double falseEasting = 200000.0;
    protected double falseNorthing = 750000.0;
    static /* synthetic */ Class class$com$bbn$openmap$proj$LambertConformal;
    static /* synthetic */ Class class$com$bbn$openmap$proj$LambertConformalLoader;
    static /* synthetic */ Class class$com$bbn$openmap$proj$ProjectionLoader;

    public LambertConformalLoader() {
        super(class$com$bbn$openmap$proj$LambertConformal == null ? (class$com$bbn$openmap$proj$LambertConformal = LambertConformalLoader.class$("com.bbn.openmap.proj.LambertConformal")) : class$com$bbn$openmap$proj$LambertConformal, "Lambert Conformal", "Lambert Conformal Projection");
    }

    public Projection create(Properties props) throws ProjectionException {
        try {
            LatLonPoint llp = (LatLonPoint)props.get("CENTER");
            float scale = PropUtils.floatFromProperties(props, "SCALE", 1.0E7f);
            int height = PropUtils.intFromProperties(props, "HEIGHT", 100);
            int width = PropUtils.intFromProperties(props, "WIDTH", 100);
            double central_meridian = PropUtils.doubleFromProperties(props, CentralMeridianProperty, this.centralMeridian);
            double sp_one = PropUtils.doubleFromProperties(props, StandardParallelOneProperty, this.standardParallel1);
            double sp_two = PropUtils.doubleFromProperties(props, StandardParallelTwoProperty, this.standardParallel2);
            double rl = PropUtils.doubleFromProperties(props, ReferenceLatitudeProperty, this.referenceLatitude);
            double fe = PropUtils.doubleFromProperties(props, FalseEastingProperty, this.falseEasting);
            double fn = PropUtils.doubleFromProperties(props, FalseNorthingProperty, this.falseNorthing);
            return new LambertConformal(llp, scale, width, height, central_meridian, sp_one, sp_two, rl, fe, fn);
        }
        catch (Exception e) {
            if (Debug.debugging("proj")) {
                Debug.output("LambertConformalLoader: problem creating LambertConformal projection " + e.getMessage());
            }
            throw new ProjectionException("LambertConformalLoader: problem creating LambertConformal projection");
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.centralMeridian = PropUtils.doubleFromProperties(props, prefix + CentralMeridianProperty, this.centralMeridian);
        this.standardParallel1 = PropUtils.doubleFromProperties(props, prefix + StandardParallelOneProperty, this.standardParallel1);
        this.standardParallel2 = PropUtils.doubleFromProperties(props, prefix + StandardParallelTwoProperty, this.standardParallel2);
        this.referenceLatitude = PropUtils.doubleFromProperties(props, prefix + ReferenceLatitudeProperty, this.referenceLatitude);
        this.falseEasting = PropUtils.doubleFromProperties(props, prefix + FalseEastingProperty, this.falseEasting);
        this.falseNorthing = PropUtils.doubleFromProperties(props, prefix + FalseNorthingProperty, this.falseNorthing);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + CentralMeridianProperty, Double.toString(this.centralMeridian));
        props.put(prefix + StandardParallelOneProperty, Double.toString(this.standardParallel1));
        props.put(prefix + StandardParallelTwoProperty, Double.toString(this.standardParallel2));
        props.put(prefix + ReferenceLatitudeProperty, Double.toString(this.referenceLatitude));
        props.put(prefix + FalseEastingProperty, Double.toString(this.falseEasting));
        props.put(prefix + FalseNorthingProperty, Double.toString(this.falseNorthing));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String internString = this.i18n.get(class$com$bbn$openmap$proj$LambertConformalLoader == null ? (class$com$bbn$openmap$proj$LambertConformalLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.LambertConformalLoader")) : class$com$bbn$openmap$proj$LambertConformalLoader, CentralMeridianProperty, "Central Meridian");
        props.put("centralMeridian.label", internString);
        internString = this.i18n.get(class$com$bbn$openmap$proj$ProjectionLoader == null ? (class$com$bbn$openmap$proj$ProjectionLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.ProjectionLoader")) : class$com$bbn$openmap$proj$ProjectionLoader, CentralMeridianProperty, 3, "Central Meridian Longitude for Projection");
        props.put(CentralMeridianProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$proj$LambertConformalLoader == null ? (class$com$bbn$openmap$proj$LambertConformalLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.LambertConformalLoader")) : class$com$bbn$openmap$proj$LambertConformalLoader, StandardParallelOneProperty, "Standard Parallel 1");
        props.put("standardParallel1.label", internString);
        internString = this.i18n.get(class$com$bbn$openmap$proj$ProjectionLoader == null ? (class$com$bbn$openmap$proj$ProjectionLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.ProjectionLoader")) : class$com$bbn$openmap$proj$ProjectionLoader, StandardParallelOneProperty, 3, "First Standard Parallel Latitude for Projection");
        props.put(StandardParallelOneProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$proj$LambertConformalLoader == null ? (class$com$bbn$openmap$proj$LambertConformalLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.LambertConformalLoader")) : class$com$bbn$openmap$proj$LambertConformalLoader, StandardParallelTwoProperty, "Standard Parallel 2");
        props.put("standardParallel2.label", internString);
        internString = this.i18n.get(class$com$bbn$openmap$proj$ProjectionLoader == null ? (class$com$bbn$openmap$proj$ProjectionLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.ProjectionLoader")) : class$com$bbn$openmap$proj$ProjectionLoader, StandardParallelTwoProperty, 3, "Second Standard Parallel Latitude for Projection");
        props.put(StandardParallelTwoProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$proj$LambertConformalLoader == null ? (class$com$bbn$openmap$proj$LambertConformalLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.LambertConformalLoader")) : class$com$bbn$openmap$proj$LambertConformalLoader, ReferenceLatitudeProperty, "Reference Latitude");
        props.put("referenceLatitude.label", internString);
        internString = this.i18n.get(class$com$bbn$openmap$proj$ProjectionLoader == null ? (class$com$bbn$openmap$proj$ProjectionLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.ProjectionLoader")) : class$com$bbn$openmap$proj$ProjectionLoader, ReferenceLatitudeProperty, 3, "The Reference Latitude of the Projection Origin");
        props.put(ReferenceLatitudeProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$proj$LambertConformalLoader == null ? (class$com$bbn$openmap$proj$LambertConformalLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.LambertConformalLoader")) : class$com$bbn$openmap$proj$LambertConformalLoader, FalseEastingProperty, "False Easting");
        props.put("falseEasting.label", internString);
        internString = this.i18n.get(class$com$bbn$openmap$proj$ProjectionLoader == null ? (class$com$bbn$openmap$proj$ProjectionLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.ProjectionLoader")) : class$com$bbn$openmap$proj$ProjectionLoader, FalseEastingProperty, 3, "Meters added to projected location of origin E/W");
        props.put(FalseEastingProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$proj$LambertConformalLoader == null ? (class$com$bbn$openmap$proj$LambertConformalLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.LambertConformalLoader")) : class$com$bbn$openmap$proj$LambertConformalLoader, FalseNorthingProperty, "False Northing");
        props.put("faleNorthing.label", internString);
        internString = this.i18n.get(class$com$bbn$openmap$proj$ProjectionLoader == null ? (class$com$bbn$openmap$proj$ProjectionLoader = LambertConformalLoader.class$("com.bbn.openmap.proj.ProjectionLoader")) : class$com$bbn$openmap$proj$ProjectionLoader, FalseNorthingProperty, 3, "Meters added to projected location of origin N/S");
        props.put(FalseNorthingProperty, internString);
        props.put("initProperties", "prettyName description centralMeridian standardParallel1 standardParallel2 referenceLatitude falseEasting faleNorthing");
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

