/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.Azimuth;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;

public class Gnomonic
extends Azimuth {
    public static final transient String GnomonicName = "Gnomonic";
    public static final transient int GnomonicType = 12;
    protected int hy;
    protected int wx;
    protected float cosCtrLat;
    protected float sinCtrLat;
    public static final transient float epsilon = 1.0E-4f;
    public static final transient float HEMISPHERE_EDGE = 1.3962634f;
    public static final transient float hPrime = 1.0f / (float)Math.pow(Math.cos(1.3962633609771729), 2.0);
    protected static final float NORTH_BOUNDARY = 1.5706964f;
    protected static final float SOUTH_BOUNDARY = -1.5706964f;

    public Gnomonic(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height, 12);
        this.setMinScale(1000.0f);
    }

    public String toString() {
        return "Gnomonic[" + super.toString();
    }

    protected void computeParameters() {
        Debug.message("proj", "Gnomonic.computeParameters()");
        super.computeParameters();
        this.minscale = (float)Math.ceil(2.0f * hPrime * this.planetPixelRadius / 2.1474836E9f);
        if (this.minscale < 1.0f) {
            this.minscale = 1.0f;
        }
        if (this.scale < this.minscale) {
            this.scale = this.minscale;
        }
        float f = this.maxscale = this.width < this.height ? this.planetPixelRadius * 2.0f * hPrime / (float)this.width : this.planetPixelRadius * 2.0f * hPrime / (float)this.height;
        if (this.maxscale < this.minscale) {
            this.maxscale = this.minscale;
        }
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        this.scaled_radius = this.planetPixelRadius / this.scale;
        this.world.x = (int)(this.planetPixelRadius * 2.0f * hPrime / this.scale);
        this.XSCALE_THRESHOLD = (int)(this.planetPixelRadius * 2.0f * hPrime / 64000.0f);
        this.cosCtrLat = (float)Math.cos(this.ctrLat);
        this.sinCtrLat = (float)Math.sin(this.ctrLat);
        this.hy = this.height / 2;
        this.wx = this.width / 2;
    }

    public void drawBackground(Graphics2D g, Paint paint) {
        g.setPaint(paint);
        this.drawBackground(g);
    }

    public void drawBackground(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public float normalize_latitude(float lat) {
        if (lat > 1.5706964f) {
            return 1.5706964f;
        }
        if (lat < -1.5706964f) {
            return -1.5706964f;
        }
        return lat;
    }

    public static final float hemisphere_distance(float phi1, float lambda0, float phi, float lambda) {
        return GreatCircle.spherical_distance(phi1, lambda0, phi, lambda);
    }

    public static final boolean hemisphere_clip(float phi1, float lambda0, float phi, float lambda) {
        return GreatCircle.spherical_distance(phi1, lambda0, phi, lambda) <= 1.3962634f;
    }

    private Point edge_point(Point p, float current_azimuth) {
        float c = 1.3962634f;
        LatLonPoint tmpll = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, c, current_azimuth);
        float phi = tmpll.radlat_;
        float lambda = tmpll.radlon_;
        float kPrime = 1.0f / (float)Math.cos(c);
        float cosPhi = (float)Math.cos(phi);
        float sinPhi = (float)Math.sin(phi);
        float lambdaMinusCtrLon = lambda - this.ctrLon;
        float cosLambdaMinusCtrLon = (float)Math.cos(lambdaMinusCtrLon);
        float sinLambdaMinusCtrLon = (float)Math.sin(lambdaMinusCtrLon);
        p.x = (int)(this.scaled_radius * kPrime * cosPhi * sinLambdaMinusCtrLon) + this.wx;
        p.y = this.hy - (int)(this.scaled_radius * kPrime * (this.cosCtrLat * sinPhi - this.sinCtrLat * cosPhi * cosLambdaMinusCtrLon));
        return p;
    }

    public boolean isPlotable(float lat, float lon) {
        lat = this.normalize_latitude(ProjMath.degToRad(lat));
        lon = Gnomonic.wrap_longitude(ProjMath.degToRad(lon));
        return Gnomonic.hemisphere_clip(this.ctrLat, this.ctrLon, lat, lon);
    }

    protected Point _forward(float phi, float lambda, Point p, Azimuth.AzimuthVar azVar) {
        float c = Gnomonic.hemisphere_distance(this.ctrLat, this.ctrLon, phi, lambda);
        if (c > 1.3962634f) {
            float az = GreatCircle.spherical_azimuth(this.ctrLat, this.ctrLon, phi, lambda);
            if (azVar != null) {
                azVar.invalid_forward = true;
                azVar.current_azimuth = az;
            }
            return this.edge_point(p, az);
        }
        float kPrime = 1.0f / (float)Math.cos(c);
        float cosPhi = (float)Math.cos(phi);
        float sinPhi = (float)Math.sin(phi);
        float lambdaMinusCtrLon = lambda - this.ctrLon;
        float cosLambdaMinusCtrLon = (float)Math.cos(lambdaMinusCtrLon);
        float sinLambdaMinusCtrLon = (float)Math.sin(lambdaMinusCtrLon);
        p.x = (int)(this.scaled_radius * kPrime * cosPhi * sinLambdaMinusCtrLon) + this.wx;
        p.y = this.hy - (int)(this.scaled_radius * kPrime * (this.cosCtrLat * sinPhi - this.sinCtrLat * cosPhi * cosLambdaMinusCtrLon));
        return p;
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
        float rho;
        if ((rho = (float)Math.sqrt((x -= this.wx) * x + (y = this.hy - y) * y)) == 0.0f) {
            Debug.message("proj", "Gnomonic.inverse: center!");
            llp.setLatLon(ProjMath.radToDeg(this.ctrLat), ProjMath.radToDeg(this.ctrLon));
            return llp;
        }
        float c = (float)Math.atan2(rho, this.scaled_radius);
        float cosC = (float)Math.cos(c);
        float sinC = (float)Math.sin(c);
        float lat = (float)Math.asin(cosC * this.sinCtrLat + (float)y * sinC * (this.cosCtrLat / rho));
        float lon = this.ctrLon + (float)Math.atan2((float)x * sinC, rho * this.cosCtrLat * cosC - (float)y * this.sinCtrLat * sinC);
        if (Float.isNaN(lat) || Float.isNaN(lon)) {
            Debug.message("proj", "Gnomonic.inverse(): outer space!");
            lat = this.ctrLat;
            lon = this.ctrLon;
        }
        llp.setLatLon(ProjMath.radToDeg(lat), ProjMath.radToDeg(lon));
        return llp;
    }

    public LatLonPoint inverse(Point pt, LatLonPoint llp) {
        return this.inverse(pt.x, pt.y, llp);
    }

    public boolean overEquator() {
        LatLonPoint llN = this.inverse(this.width / 2, 0, new LatLonPoint());
        LatLonPoint llS = this.inverse(this.width / 2, this.height, new LatLonPoint());
        return MoreMath.sign(llN.radlat_) != MoreMath.sign(llS.radlat_);
    }

    public LatLonPoint getUpperLeft() {
        float lon;
        float lat;
        LatLonPoint tmp = new LatLonPoint();
        if (this.overNorthPole()) {
            lat = 1.5707964f;
            lon = (float)(-Math.PI);
        } else if (this.overSouthPole()) {
            lon = (float)(-Math.PI);
            if (this.overEquator()) {
                tmp = this.inverse(this.width / 2, 0, tmp);
                lat = tmp.radlat_;
            } else {
                tmp = this.inverse(0, 0, tmp);
                lat = tmp.radlat_;
            }
        } else if (this.ctrLat >= 0.0f) {
            tmp = this.inverse(0, 0, tmp);
            lon = tmp.radlon_;
            tmp = this.inverse(this.width / 2, 0, tmp);
            lat = tmp.radlat_;
        } else {
            tmp = this.inverse(0, this.height, tmp);
            lon = tmp.radlon_;
            if (this.overEquator()) {
                tmp = this.inverse(this.width / 2, 0, tmp);
                lat = tmp.radlat_;
            } else {
                tmp = this.inverse(0, 0, tmp);
                lat = tmp.radlat_;
            }
        }
        tmp.setLatLon(lat, lon, true);
        return tmp;
    }

    public LatLonPoint getLowerRight() {
        float lat;
        float lon;
        LatLonPoint tmp = new LatLonPoint();
        if (this.overNorthPole()) {
            lon = (float)Math.PI;
            if (this.overEquator()) {
                tmp = this.inverse(this.width / 2, this.height, tmp);
                lat = tmp.radlat_;
            } else {
                tmp = this.inverse(this.width, this.height, tmp);
                lat = tmp.radlat_;
            }
        } else if (this.overSouthPole()) {
            lat = -1.5707964f;
            lon = (float)Math.PI;
        } else if (this.ctrLat >= 0.0f) {
            tmp = this.inverse(this.width, 0, tmp);
            lon = tmp.radlon_;
            if (this.overEquator()) {
                tmp = this.inverse(this.width / 2, this.height, tmp);
                lat = tmp.radlat_;
            } else {
                tmp = this.inverse(this.width, this.height, tmp);
                lat = tmp.radlat_;
            }
        } else {
            tmp = this.inverse(this.width, this.height, tmp);
            lon = tmp.radlon_;
            tmp = this.inverse(this.width / 2, this.height, tmp);
            lat = tmp.radlat_;
        }
        tmp.setLatLon(lat, lon, true);
        return tmp;
    }

    public String getName() {
        return GnomonicName;
    }
}

