/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.editable;

import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.editable.EOMGCursors;
import com.bbn.openmap.omGraphics.editable.EOMGEditState;
import com.bbn.openmap.util.Debug;
import java.awt.event.MouseEvent;

public class GraphicEditState
extends State
implements EOMGEditState {
    protected EditableOMGraphic graphic;

    public GraphicEditState(EditableOMGraphic eomg) {
        this.graphic = eomg;
    }

    public boolean mouseDragged(MouseEvent e) {
        Debug.message("eomg", "GraphicStateMachine|edit state|mouseDragged");
        if (this.graphic.getMovingPoint() != null) {
            this.graphic.redraw(e);
        } else {
            this.graphic.getStateMachine().setSelected();
        }
        return this.getMapMouseListenerResponse();
    }

    public boolean mouseReleased(MouseEvent e) {
        Debug.message("eomg", "GraphicStateMachine|edit state|mouseReleased");
        if (this.graphic.getStateMachine().isOffsetNeeded()) {
            this.graphic.getStateMachine().setOffset();
            this.graphic.getStateMachine().setOffsetNeeded(false);
        } else {
            this.graphic.getStateMachine().setSelected();
            GrabPoint mp = this.graphic.getMovingPoint();
            if (mp == null && !this.graphic.getCanGrabGraphic()) {
                this.graphic.fireEvent(EOMGCursors.DEFAULT, "", e);
            } else {
                this.graphic.fireEvent(EOMGCursors.EDIT, "", e);
            }
        }
        this.graphic.redraw(e, true);
        this.graphic.setMovingPoint(null);
        return this.getMapMouseListenerResponse();
    }
}

