/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMAbstractLine;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.TexturePaint;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.util.ArrayList;

public class OMPoly
extends OMAbstractLine
implements Serializable {
    public static final int COORDMODE_ORIGIN = 0;
    public static final int COORDMODE_PREVIOUS = 1;
    protected int units = -1;
    protected float lat = 0.0f;
    protected float lon = 0.0f;
    protected int coordMode = 0;
    protected int[] xs = null;
    protected int[] ys = null;
    protected boolean isPolygon = false;
    protected float[] rawllpts = null;
    protected boolean doShapes = false;
    protected boolean geometryClosed = false;

    public OMPoly() {
        super(0, 0, 0);
    }

    public OMPoly(float[] llPoints, int units, int lType) {
        this(llPoints, units, lType, -1);
    }

    public OMPoly(float[] llPoints, int units, int lType, int nsegs) {
        super(1, lType, 0);
        this.setLocation(llPoints, units);
        this.nsegs = nsegs;
    }

    public OMPoly(int[] xypoints) {
        super(2, 0, 0);
        this.setLocation(xypoints);
    }

    public OMPoly(int[] xPoints, int[] yPoints) {
        super(2, 0, 0);
        this.setLocation(xPoints, yPoints);
    }

    public OMPoly(float latPoint, float lonPoint, int[] xypoints, int cMode) {
        super(3, 0, 0);
        this.setLocation(latPoint, lonPoint, 0, xypoints);
        this.coordMode = cMode;
    }

    public OMPoly(float latPoint, float lonPoint, int[] xPoints, int[] yPoints, int cMode) {
        super(3, 0, 0);
        this.setLocation(latPoint, lonPoint, 0, xPoints, yPoints);
        this.coordMode = cMode;
    }

    public void setLocation(float[] llPoints, int units) {
        this.units = 1;
        if (units == 0) {
            ProjMath.arrayDegToRad(llPoints);
        }
        this.rawllpts = llPoints;
        this.setNeedToRegenerate(true);
        this.setRenderType(1);
    }

    public void setLocation(int[] xypoints) {
        int end = xypoints.length >> 1;
        this.xs = new int[end];
        this.ys = new int[end];
        int i = 0;
        int j = 0;
        while (i < end) {
            this.xs[i] = xypoints[j];
            this.ys[i] = xypoints[j + 1];
            ++i;
            j += 2;
        }
        this.setNeedToRegenerate(true);
        this.setRenderType(2);
    }

    public void setLocation(int[] xPoints, int[] yPoints) {
        this.xs = xPoints;
        this.ys = yPoints;
        this.setNeedToRegenerate(true);
        this.setRenderType(2);
    }

    public void setLocation(float latPoint, float lonPoint, int units, int[] xypoints) {
        this.units = 1;
        if (units == 0) {
            this.lat = ProjMath.degToRad(latPoint);
            this.lon = ProjMath.degToRad(lonPoint);
        } else {
            this.lat = latPoint;
            this.lon = lonPoint;
        }
        int end = xypoints.length >> 1;
        this.xs = new int[end];
        this.ys = new int[end];
        int i = 0;
        int j = 0;
        while (i < end) {
            this.xs[i] = xypoints[j];
            this.ys[i] = xypoints[j + 1];
            ++i;
            j += 2;
        }
        this.setNeedToRegenerate(true);
        this.setRenderType(3);
    }

    public void setLocation(float latPoint, float lonPoint, int units, int[] xPoints, int[] yPoints) {
        this.units = 1;
        if (units == 0) {
            this.lat = ProjMath.degToRad(latPoint);
            this.lon = ProjMath.degToRad(lonPoint);
        } else {
            this.lat = latPoint;
            this.lon = lonPoint;
        }
        this.xs = xPoints;
        this.ys = yPoints;
        this.setNeedToRegenerate(true);
        this.setRenderType(3);
    }

    public float[] getLatLonArray() {
        return this.rawllpts;
    }

    public void setLat(float lat) {
        this.lat = ProjMath.degToRad(lat);
        this.setNeedToRegenerate(true);
    }

    public float getLat() {
        return ProjMath.radToDeg(this.lat);
    }

    public void setLon(float lon) {
        this.lon = ProjMath.degToRad(lon);
        this.setNeedToRegenerate(true);
    }

    public float getLon() {
        return ProjMath.radToDeg(this.lon);
    }

    public void setXs(int[] x) {
        this.xs = x;
        this.setNeedToRegenerate(true);
    }

    public int[] getXs() {
        return this.xs;
    }

    public void setYs(int[] y) {
        this.ys = y;
        this.setNeedToRegenerate(true);
    }

    public int[] getYs() {
        return this.ys;
    }

    public void setFillPaint(Paint paint) {
        super.setFillPaint(paint);
        this.isPolygon = !OMPoly.isClear(paint);
    }

    public boolean isPolygon() {
        return this.isPolygon;
    }

    public void setIsPolygon(boolean set) {
        if (!set) {
            this.fillPaint = OMColor.clear;
        }
        this.isPolygon = set;
    }

    public void setNumSegs(int nsegs) {
        this.nsegs = nsegs;
    }

    public int getNumSegs() {
        return this.nsegs;
    }

    public void setCoordMode(int coordMode) {
        this.coordMode = coordMode;
    }

    public int getCoordMode() {
        return this.coordMode;
    }

    public void setDoShapes(boolean set) {
        this.doShapes = set;
    }

    public boolean getDoShapes() {
        return this.doShapes;
    }

    public boolean generate(Projection proj) {
        this.setShape(null);
        this.setNeedToRegenerate(true);
        if (proj == null) {
            Debug.message("omgraphic", "OMPoly: null projection in generate!");
            return false;
        }
        this.isGeometryClosed();
        switch (this.renderType) {
            case 2: {
                if (this.xs == null) {
                    Debug.message("omgraphic", "OMPoly x/y rendertype null coordinates");
                    return false;
                }
                this.xpoints = new int[1][0];
                this.xpoints[0] = this.xs;
                this.ypoints = new int[1][0];
                this.ypoints[0] = this.ys;
                break;
            }
            case 3: {
                if (this.xs == null) {
                    Debug.message("omgraphic", "OMPoly offset rendertype null coordinates");
                    return false;
                }
                int npts = this.xs.length;
                int[] _x = new int[npts];
                int[] _y = new int[npts];
                Point origin = proj.forward(this.lat, this.lon, new Point(0, 0), true);
                if (this.coordMode == 0) {
                    for (int i = 0; i < npts; ++i) {
                        _x[i] = this.xs[i] + origin.x;
                        _y[i] = this.ys[i] + origin.y;
                    }
                } else {
                    _x[0] = this.xs[0] + origin.x;
                    _y[0] = this.ys[0] + origin.y;
                    for (int i = 1; i < npts; ++i) {
                        _x[i] = this.xs[i] + _x[i - 1];
                        _y[i] = this.ys[i] + _y[i - 1];
                    }
                }
                this.xpoints = new int[1][0];
                this.xpoints[0] = _x;
                this.ypoints = new int[1][0];
                this.ypoints[0] = _y;
                break;
            }
            case 1: {
                ArrayList vector = proj.forwardPoly(this.rawllpts, this.lineType, this.nsegs, this.isPolygon);
                int size = vector.size();
                this.xpoints = new int[size / 2][0];
                this.ypoints = new int[this.xpoints.length][0];
                int i = 0;
                int j = 0;
                while (i < size) {
                    this.xpoints[j] = (int[])vector.get(i);
                    this.ypoints[j] = (int[])vector.get(i + 1);
                    i += 2;
                    ++j;
                }
                if (this.doShapes) break;
                if (size > 1) {
                    if (this.arrowhead != null) {
                        this.arrowhead.generate(this);
                    }
                    this.setNeedToRegenerate(false);
                    this.initLabelingDuringGenerate();
                    if (this.checkPoints(this.xpoints, this.ypoints)) {
                        this.setLabelLocation(this.xpoints[0], this.ypoints[0]);
                    }
                    return true;
                }
                return false;
            }
            case 0: {
                Debug.error("OMPoly.generate: invalid RenderType");
                return false;
            }
        }
        if (this.arrowhead != null) {
            this.arrowhead.generate(this);
        }
        this.setNeedToRegenerate(false);
        this.createShape();
        return true;
    }

    protected boolean checkPoints(int[][] xpoints2, int[][] ypoints2) {
        return this.xpoints != null && this.ypoints != null && this.xpoints.length != 0 && this.ypoints.length != 0;
    }

    public boolean shouldRenderFill() {
        return !OMPoly.isClear(this.getFillPaint()) && this.isPolygon();
    }

    public void render(Graphics g) {
        block13: {
            if (this.shape != null) {
                super.render(g);
                if (this.arrowhead != null) {
                    this.arrowhead.render(g);
                }
                return;
            }
            if (this.getNeedToRegenerate() || !this.isVisible()) {
                return;
            }
            int[][] xpts = this.xpoints;
            int[][] ypts = this.ypoints;
            if (xpts == null || ypts == null) {
                this.setNeedToRegenerate(true);
                return;
            }
            int len = xpts.length;
            Paint displayPaint = this.getDisplayPaint();
            Paint fillPaint = this.getFillPaint();
            boolean isFillClear = OMPoly.isClear(fillPaint);
            boolean isLineClear = OMPoly.isClear(displayPaint);
            TexturePaint tm = this.getTextureMask();
            try {
                for (int i = 0; i < len; ++i) {
                    int[] _x = xpts[i];
                    int[] _y = ypts[i];
                    if (_x == null || _y == null) continue;
                    if (this.isPolygon) {
                        if (!isFillClear) {
                            this.setGraphicsForFill(g);
                            g.fillPolygon(_x, _y, _x.length);
                            if (tm != null && tm != fillPaint) {
                                this.setGraphicsColor(g, tm);
                                g.fillPolygon(_x, _y, _x.length);
                            }
                        }
                        if (!this.matted && isLineClear && this.edgeMatchesFill) continue;
                        if (this.matted && g instanceof Graphics2D && this.stroke instanceof BasicStroke) {
                            ((Graphics2D)g).setStroke(new BasicStroke(((BasicStroke)this.stroke).getLineWidth() + 2.0f));
                            this.setGraphicsColor(g, this.mattingPaint);
                            g.drawPolyline(_x, _y, _x.length);
                        }
                        this.setGraphicsForEdge(g);
                        g.drawPolygon(_x, _y, _x.length);
                        continue;
                    }
                    if (this.matted && g instanceof Graphics2D && this.stroke instanceof BasicStroke) {
                        ((Graphics2D)g).setStroke(new BasicStroke(((BasicStroke)this.stroke).getLineWidth() + 2.0f));
                        if (this.arrowhead != null) {
                            this.setGraphicsColor(g, this.mattingPaint);
                            this.arrowhead.render(g);
                        }
                        this.setGraphicsColor(g, this.mattingPaint);
                        g.drawPolyline(_x, _y, _x.length);
                    }
                    this.setGraphicsForEdge(g);
                    g.drawPolyline(_x, _y, _x.length);
                    if (this.arrowhead == null) continue;
                    this.arrowhead.render(g);
                }
                this.renderLabel(g);
            }
            catch (Exception e) {
                Debug.output("OMPoly: caught Java rendering exception\n" + e.getMessage());
                if (!Debug.debugging("ompoly")) break block13;
                e.printStackTrace();
            }
        }
    }

    public float distance(int x, int y) {
        if (this.shape != null) {
            return super.distance(x, y);
        }
        float distance = Float.POSITIVE_INFINITY;
        if (this.getNeedToRegenerate()) {
            return distance;
        }
        int[][] xpts = this.xpoints;
        int[][] ypts = this.ypoints;
        int len = xpts.length;
        for (int i = 0; i < len; ++i) {
            int[] _x = xpts[i];
            int[] _y = ypts[i];
            if (this.isPolygon && DrawUtil.inside_polygon(_x, _y, x, y)) {
                return 0.0f;
            }
            float temp = DrawUtil.closestPolyDistance(_x, _y, x, y, false);
            if (!(temp < distance)) continue;
            distance = temp;
        }
        return this.normalizeDistanceForLineWidth(distance);
    }

    public GeneralPath getShape() {
        if (this.shape == null) {
            this.createShape();
        }
        return this.shape;
    }

    protected void createShape() {
        if (this.getNeedToRegenerate() || !this.checkPoints(this.xpoints, this.ypoints)) {
            return;
        }
        this.initLabelingDuringGenerate();
        switch (this.renderType) {
            case 2: 
            case 3: {
                this.shape = OMPoly.createShape(this.xpoints[0], this.ypoints[0], this.isPolygon);
                break;
            }
            case 1: {
                int size = this.xpoints.length;
                for (int i = 0; i < size; ++i) {
                    GeneralPath gp = OMPoly.createShape(this.xpoints[i], this.ypoints[i], this.isPolygon);
                    if (this.shape == null) {
                        this.shape = gp;
                        continue;
                    }
                    this.shape.append(gp, false);
                }
                break;
            }
        }
        this.setLabelLocation(this.xpoints[0], this.ypoints[0]);
    }

    protected boolean isGeometryClosed() {
        this.geometryClosed = false;
        switch (this.renderType) {
            case 2: 
            case 3: {
                if (this.xs == null || this.xs.length <= 2) break;
                this.geometryClosed = this.xs[0] == this.xs[this.xs.length - 1] && this.ys[0] == this.ys[this.ys.length - 1];
                break;
            }
            case 1: {
                int l;
                if (this.rawllpts == null || (l = this.rawllpts.length) <= 4) break;
                this.geometryClosed = (double)Math.abs(this.rawllpts[0] - this.rawllpts[l - 2]) < 1.0E-5 && (double)Math.abs(this.rawllpts[1] - this.rawllpts[l - 1]) < 1.0E-5;
                break;
            }
            case 0: {
                Debug.error("OMPoly.generate: invalid RenderType");
            }
        }
        return this.geometryClosed;
    }

    public float[] getRawllpts() {
        return this.rawllpts;
    }

    public int getUnits() {
        return this.units;
    }
}

