/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.Environment;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMScalingIcon;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.omGraphics.OffsetGrabPoint;
import com.bbn.openmap.omGraphics.editable.GraphicEditState;
import com.bbn.openmap.omGraphics.editable.GraphicSelectedState;
import com.bbn.openmap.omGraphics.editable.GraphicSetOffsetState;
import com.bbn.openmap.omGraphics.editable.ScalingRasterStateMachine;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.FileUtils;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class EditableOMScalingRaster
extends EditableOMGraphic {
    protected GrabPoint gpnw;
    protected GrabPoint gpne;
    protected GrabPoint gpsw;
    protected GrabPoint gpse;
    protected OffsetGrabPoint gpc;
    protected OffsetGrabPoint gpo;
    protected OMScalingRaster raster;
    public static final String OffsetResetCmd = "OffsetResetCmd";
    public static final int CENTER_POINT_INDEX = 0;
    public static final int NW_POINT_INDEX = 1;
    public static final int NE_POINT_INDEX = 2;
    public static final int SW_POINT_INDEX = 3;
    public static final int SE_POINT_INDEX = 4;
    public static final int OFFSET_POINT_INDEX = 5;
    float diffx;
    float diffy;
    protected int lastRenderType = -1;

    public EditableOMScalingRaster() {
        this.createGraphic(null);
    }

    public EditableOMScalingRaster(GraphicAttributes ga) {
        this.createGraphic(ga);
    }

    public EditableOMScalingRaster(OMScalingRaster omsr) {
        this.setGraphic(omsr);
    }

    public void init() {
        Debug.message("eomg", "EditableOMScalingRaster.init()");
        this.setCanGrabGraphic(false);
        this.setStateMachine(new ScalingRasterStateMachine(this));
        this.gPoints = new GrabPoint[6];
    }

    public void setGraphic(OMGraphic graphic) {
        this.init();
        if (graphic instanceof OMScalingRaster) {
            this.raster = (OMScalingRaster)graphic;
            this.stateMachine.setSelected();
            this.setGrabPoints(this.raster);
        } else {
            this.createGraphic(null);
        }
    }

    public void createGraphic(GraphicAttributes ga) {
        this.init();
        this.stateMachine.setUndefined();
        String pathToFile = null;
        if (!Environment.isApplet()) {
            pathToFile = FileUtils.getFilePathToOpenFromUser("Choose Image File for Raster");
        } else {
            JOptionPane.showMessageDialog(null, "Can't search for images in an applet!", "Can't Choose Image", 0);
        }
        if (pathToFile == null) {
            return;
        }
        try {
            ImageIcon ii = new ImageIcon(pathToFile);
            this.raster = new OMScalingRaster(90.0f, -180.0f, 89.0f, -179.0f, ii);
        }
        catch (IllegalArgumentException iae) {
            Debug.error("EditableOMScalingRaster:  " + pathToFile + " doesn't appear to be an image file");
            this.raster = new OMScalingRaster(90.0f, -180.0f, 89.0f, -179.0f, (Image)new BufferedImage(1, 1, 1));
        }
        if (ga != null) {
            ga.setTo(this.raster, true);
        }
        this.assertGrabPoints();
    }

    public OMGraphic getGraphic() {
        return this.raster;
    }

    public void attachToMovingGrabPoint(OffsetGrabPoint gp) {
        gp.addGrabPoint(this.gpo);
    }

    public void detachFromMovingGrabPoint(OffsetGrabPoint gp) {
        gp.removeGrabPoint(this.gpo);
    }

    public void setMovingPoint(GrabPoint gp) {
        super.setMovingPoint(gp);
    }

    public void initRectSize() {
        this.diffx = Math.abs(this.raster.getLRLon() - this.raster.getULLon()) / 2.0f;
        this.diffy = Math.abs(this.raster.getULLat() - this.raster.getLRLat()) / 2.0f;
    }

    public void assertGrabPoints() {
        OMGraphic omg = this.getGraphic();
        if (omg == null) {
            return;
        }
        int rt = omg.getRenderType();
        if (rt != this.lastRenderType) {
            this.clearGrabPoints();
            this.lastRenderType = rt;
        }
        if (this.gpnw == null) {
            this.gPoints[1] = this.gpnw = new GrabPoint(-1, -1);
        }
        if (this.gpne == null) {
            this.gPoints[2] = this.gpne = new GrabPoint(-1, -1);
        }
        if (this.gpsw == null) {
            this.gPoints[3] = this.gpsw = new GrabPoint(-1, -1);
        }
        if (this.gpse == null) {
            this.gPoints[4] = this.gpse = new GrabPoint(-1, -1);
        }
        if (this.gpc == null) {
            this.gpc = new OffsetGrabPoint(-1, -1);
            this.gPoints[0] = this.gpc;
            if (this.getGraphic().getRenderType() != 1) {
                this.gpc.addGrabPoint(this.gpnw);
                this.gpc.addGrabPoint(this.gpne);
                this.gpc.addGrabPoint(this.gpsw);
                this.gpc.addGrabPoint(this.gpse);
            }
        }
        if (this.gpo == null) {
            this.gpo = new OffsetGrabPoint(-1, -1);
            this.gPoints[5] = this.gpo;
            this.gpo.addGrabPoint(this.gpc);
        }
    }

    protected void clearGrabPoints() {
        this.gpc = null;
        this.gpnw = null;
        this.gpne = null;
        this.gpsw = null;
        this.gpse = null;
        this.gpo = null;
        this.gPoints[0] = this.gpc;
        this.gPoints[1] = this.gpnw;
        this.gPoints[2] = this.gpne;
        this.gPoints[3] = this.gpsw;
        this.gPoints[4] = this.gpse;
        this.gPoints[5] = this.gpo;
    }

    public void setGrabPoints(OMGraphic graphic) {
        Debug.message("eomg", "EditableOMScalingRaster.setGrabPoints(graphic)");
        if (!(graphic instanceof OMScalingRaster)) {
            return;
        }
        this.assertGrabPoints();
        OMScalingRaster raster = (OMScalingRaster)graphic;
        if (graphic instanceof OMScalingIcon) {
            this.setGrabPointsForOMSI((OMScalingIcon)graphic);
            return;
        }
        boolean ntr = raster.getNeedToRegenerate();
        int renderType = raster.getRenderType();
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        int latoffset = 0;
        int lonoffset = 0;
        boolean doStraight = true;
        if (!ntr) {
            if ((renderType == 1 || renderType == 3) && this.projection != null) {
                float wlon = raster.getULLon();
                float nlat = raster.getULLat();
                float elon = raster.getLRLon();
                float slat = raster.getLRLat();
                LatLonPoint llp = new LatLonPoint(nlat, wlon);
                Point p = this.projection.forward(llp);
                if (renderType == 1) {
                    doStraight = false;
                    top = (int)p.getY();
                    left = (int)p.getX();
                    this.gpnw.set((int)p.getX(), (int)p.getY());
                    p = this.projection.forward(slat, elon);
                    this.gpse.set((int)p.getX(), (int)p.getY());
                    p = this.projection.forward(nlat, elon);
                    this.gpne.set((int)p.getX(), (int)p.getY());
                    p = this.projection.forward(slat, wlon);
                    this.gpsw.set((int)p.getX(), (int)p.getY());
                    p = this.projection.forward(nlat - (nlat - slat) / 2.0f, wlon + (elon - wlon) / 2.0f);
                    this.gpc.set((int)p.getX(), (int)p.getY());
                } else {
                    latoffset = (int)p.getY();
                    lonoffset = (int)p.getX();
                    this.gpo.set(lonoffset, latoffset);
                }
            }
            if (doStraight) {
                Debug.message("eomg", "EditableOMScalingRaster: drawing straight line rectangle");
                top = raster.getY() + latoffset;
                bottom = raster.getY() + raster.getHeight() + latoffset;
                right = raster.getX() + raster.getWidth() + lonoffset;
                left = raster.getX() + lonoffset;
                if (this.movingPoint == this.gpc || this.movingPoint == this.gpo || this.movingPoint == null) {
                    this.gpne.set(right, top);
                    this.gpnw.set(left, top);
                    this.gpse.set(right, bottom);
                    this.gpsw.set(left, bottom);
                } else if (this.movingPoint == this.gpnw) {
                    this.gpne.set(this.gpse.getX(), this.gpnw.getY());
                    this.gpsw.set(this.gpnw.getX(), this.gpse.getY());
                } else if (this.movingPoint == this.gpse) {
                    this.gpne.set(this.gpse.getX(), this.gpnw.getY());
                    this.gpsw.set(this.gpnw.getX(), this.gpse.getY());
                } else if (this.movingPoint == this.gpsw) {
                    this.gpnw.set(this.gpsw.getX(), this.gpne.getY());
                    this.gpse.set(this.gpne.getX(), this.gpsw.getY());
                } else if (this.movingPoint == this.gpne) {
                    this.gpnw.set(this.gpsw.getX(), this.gpne.getY());
                    this.gpse.set(this.gpne.getX(), this.gpsw.getY());
                }
                int middlex = (right - left) / 2;
                int middley = (bottom - top) / 2;
                this.gpc.set(left + middlex, top + middley);
                this.gpc.updateOffsets();
            }
            if (renderType == 3) {
                this.gpo.updateOffsets();
            }
        } else {
            Debug.message("eomg", "EditableOMScalingRaster.setGrabPoints: graphic needs to be regenerated");
        }
    }

    protected void setGrabPointsForOMSI(OMScalingIcon icon) {
        if (this.projection != null) {
            float lon = icon.getLon();
            float lat = icon.getLat();
            int renderType = icon.getRenderType();
            LatLonPoint llp = new LatLonPoint(lat, lon);
            Point p = this.projection.forward(llp);
            if (renderType == 1) {
                this.gpc.set((int)p.getX(), (int)p.getY());
            }
        }
    }

    protected void setGrabPointsForOMSI() {
        if (this.projection != null) {
            LatLonPoint llp1 = this.projection.inverse(this.gpc.getX(), this.gpc.getY());
            this.raster.setLat(llp1.getLatitude());
            this.raster.setLon(llp1.getLongitude());
        }
        if (this.projection != null) {
            this.regenerate(this.projection);
        }
    }

    public void setGrabPoints() {
        LatLonPoint llp2;
        int halfwidth;
        int halfheight;
        boolean settingOffset;
        LatLonPoint llp1;
        int renderType = this.raster.getRenderType();
        Debug.message("eomg", "EditableOMScalingRaster.setGrabPoints()");
        if (renderType == 1 && this.projection != null) {
            if (this.raster instanceof OMScalingIcon) {
                this.setGrabPointsForOMSI();
                return;
            }
            if (this.movingPoint == this.gpne) {
                llp1 = this.projection.inverse(this.gpne.getX(), this.gpne.getY());
                this.raster.setULLat(llp1.getLatitude());
                this.raster.setLRLon(llp1.getLongitude());
            } else if (this.movingPoint == this.gpnw) {
                llp1 = this.projection.inverse(this.gpnw.getX(), this.gpnw.getY());
                this.raster.setULLat(llp1.getLatitude());
                this.raster.setULLon(llp1.getLongitude());
            } else if (this.movingPoint == this.gpsw) {
                llp1 = this.projection.inverse(this.gpsw.getX(), this.gpsw.getY());
                this.raster.setLRLat(llp1.getLatitude());
                this.raster.setULLon(llp1.getLongitude());
            } else if (this.movingPoint == this.gpse) {
                llp1 = this.projection.inverse(this.gpse.getX(), this.gpse.getY());
                LatLonPoint llp22 = this.projection.inverse(this.gpnw.getX(), this.gpnw.getY());
                this.raster.setULLat(llp22.getLatitude());
                this.raster.setULLon(llp22.getLongitude());
                this.raster.setLRLat(llp1.getLatitude());
                this.raster.setLRLon(llp1.getLongitude());
            } else {
                llp1 = this.projection.inverse(this.gpc.getX(), this.gpc.getY());
                this.raster.setULLat(llp1.getLatitude() + this.diffy);
                this.raster.setULLon(llp1.getLongitude() - this.diffx);
                this.raster.setLRLat(llp1.getLatitude() - this.diffy);
                this.raster.setLRLon(llp1.getLongitude() + this.diffx);
            }
            this.raster.setNeedToRegenerate(true);
        }
        boolean bl = settingOffset = this.getStateMachine().getState() instanceof GraphicSetOffsetState && this.movingPoint == this.gpo;
        if (renderType == 3) {
            llp1 = this.projection.inverse(this.gpo.getX(), this.gpo.getY());
            this.raster.setULLat(llp1.getLatitude());
            this.raster.setULLon(llp1.getLongitude());
            if (settingOffset || this.movingPoint == this.gpc) {
                halfheight = (this.gpse.getY() - this.gpnw.getY()) / 2;
                halfwidth = (this.gpse.getX() - this.gpnw.getX()) / 2;
                llp1 = this.projection.inverse(this.gpc.getX() - halfwidth - this.gpo.getX(), this.gpc.getY() - halfheight - this.gpo.getY());
                llp2 = this.projection.inverse(this.gpc.getX() + halfwidth - this.gpo.getX(), this.gpc.getY() + halfheight - this.gpo.getY());
                this.raster.setULLat(llp1.getLatitude());
                this.raster.setULLon(llp1.getLongitude());
                this.raster.setLRLat(llp2.getLatitude());
                this.raster.setLRLon(llp2.getLongitude());
            }
            if (!settingOffset) {
                Debug.message("eomg", "EditableOMScalingRaster: updating offset rect");
                if (this.movingPoint == this.gpnw || this.movingPoint == this.gpse) {
                    llp1 = this.projection.inverse(this.gpnw.getX() - this.gpo.getX(), this.gpnw.getY() - this.gpo.getY());
                    LatLonPoint llp23 = this.projection.inverse(this.gpse.getX() - this.gpo.getX(), this.gpse.getY() - this.gpo.getY());
                    this.raster.setULLat(llp1.getLatitude());
                    this.raster.setULLon(llp1.getLongitude());
                    this.raster.setLRLat(llp23.getLatitude());
                    this.raster.setLRLon(llp23.getLongitude());
                } else if (this.movingPoint == this.gpne || this.movingPoint == this.gpsw) {
                    llp1 = this.projection.inverse(this.gpsw.getX() - this.gpo.getX(), this.gpne.getY() - this.gpo.getY());
                    LatLonPoint llp24 = this.projection.inverse(this.gpne.getX() - this.gpo.getX(), this.gpsw.getY() - this.gpo.getY());
                    this.raster.setULLat(llp1.getLatitude());
                    this.raster.setULLon(llp1.getLongitude());
                    this.raster.setLRLat(llp24.getLatitude());
                    this.raster.setLRLon(llp24.getLongitude());
                }
                this.raster.setNeedToRegenerate(true);
            }
            this.raster.setRenderType(3);
        }
        if (renderType == 2) {
            Debug.message("eomg", "EditableOMScalingRaster: updating x/y rect");
            if (this.movingPoint == this.gpc) {
                halfheight = (this.gpse.getY() - this.gpnw.getY()) / 2;
                halfwidth = (this.gpse.getX() - this.gpnw.getX()) / 2;
                llp1 = this.projection.inverse(this.gpc.getX() - halfwidth, this.gpc.getY() - halfheight);
                llp2 = this.projection.inverse(this.gpc.getX() + halfwidth, this.gpc.getY() + halfheight);
                this.raster.setULLat(llp1.getLatitude());
                this.raster.setULLon(llp1.getLongitude());
                this.raster.setLRLat(llp2.getLatitude());
                this.raster.setLRLon(llp2.getLongitude());
            } else if (this.movingPoint == this.gpnw || this.movingPoint == this.gpse) {
                llp1 = this.projection.inverse(this.gpnw.getX(), this.gpnw.getY());
                LatLonPoint llp25 = this.projection.inverse(this.gpse.getX(), this.gpse.getY());
                this.raster.setULLat(llp1.getLatitude());
                this.raster.setULLon(llp1.getLongitude());
                this.raster.setLRLat(llp25.getLatitude());
                this.raster.setLRLon(llp25.getLongitude());
            } else if (this.movingPoint == this.gpne || this.movingPoint == this.gpsw) {
                llp1 = this.projection.inverse(this.gpsw.getX(), this.gpne.getY());
                LatLonPoint llp26 = this.projection.inverse(this.gpne.getX(), this.gpsw.getY());
                this.raster.setULLat(llp1.getLatitude());
                this.raster.setULLon(llp1.getLongitude());
                this.raster.setLRLat(llp26.getLatitude());
                this.raster.setLRLon(llp26.getLongitude());
            }
        }
        if (this.projection != null) {
            this.regenerate(this.projection);
        }
    }

    public void move(MouseEvent e) {
    }

    public boolean generate(Projection proj) {
        Debug.message("eomgdetail", "EditableOMScalingRaster.generate()");
        if (this.raster != null) {
            this.raster.generate(proj);
        }
        for (int i = 0; i < this.gPoints.length; ++i) {
            GrabPoint gp = this.gPoints[i];
            if (gp == null) continue;
            gp.generate(proj);
        }
        return true;
    }

    public void regenerate(Projection proj) {
        Debug.message("eomg", "EditableOMScalingRaster.regenerate()");
        if (this.raster != null) {
            this.raster.regenerate(proj);
        }
        this.setGrabPoints(this.raster);
        this.generate(proj);
    }

    public void render(Graphics graphics) {
        Debug.message("eomgdetail", "EditableOMScalingRaster.render()");
        State state = this.getStateMachine().getState();
        if (this.raster != null) {
            this.raster.setVisible(true);
            this.raster.render(graphics);
            this.raster.setVisible(false);
        } else {
            Debug.message("eomg", "EditableOMScalingRaster.render: null rect.");
        }
        int renderType = this.raster.getRenderType();
        if (state instanceof GraphicSelectedState || state instanceof GraphicEditState) {
            for (int i = 0; i < this.gPoints.length; ++i) {
                GrabPoint gp = this.gPoints[i];
                if (gp == null || (i != 5 || renderType != 3 || this.movingPoint != this.gpo) && (!(state instanceof GraphicSelectedState) || (i == 5 || renderType == 3) && renderType != 3)) continue;
                gp.setVisible(true);
                gp.render(graphics);
                gp.setVisible(false);
            }
        }
    }
}

