/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.DcwCrossTileID;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.TilingAdapter;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.util.Debug;
import java.util.ArrayList;
import java.util.List;

public class EdgeTable
extends PrimitiveTable {
    private static final String[] edgcolumns = new String[]{"id", "start_node", "end_node", "right_face", "left_face", "right_edge", "left_edge", "coordinates"};

    public EdgeTable(CoverageTable cov, TileDirectory tile) throws FormatException {
        super(cov, tile, "edg");
        if (Debug.debugging("vpf")) {
            Debug.output("EdgeTable(): " + this.filename);
        }
        if (cov.cachedLineSchema == null) {
            cov.cachedLineSchema = this.lookupSchema(edgcolumns, false);
        }
    }

    public final int getId(List l) {
        return ((Number)l.get(this.covtable.cachedLineSchema[0])).intValue();
    }

    public final int getStartNode(List l) {
        return ((Number)l.get(this.covtable.cachedLineSchema[1])).intValue();
    }

    public final int getEndNode(List l) {
        return ((Number)l.get(this.covtable.cachedLineSchema[2])).intValue();
    }

    public final DcwCrossTileID getRightFace(List l) {
        return (DcwCrossTileID)l.get(this.covtable.cachedLineSchema[3]);
    }

    public final TilingAdapter getRightFaceTilingAdapter() {
        return this.getTilingAdapter("right_face");
    }

    public final DcwCrossTileID getLeftFace(List l) {
        return (DcwCrossTileID)l.get(this.covtable.cachedLineSchema[4]);
    }

    public final TilingAdapter getLeftFaceTilingAdapter() {
        return this.getTilingAdapter("left_face");
    }

    public final DcwCrossTileID getRightEdge(List l) {
        return (DcwCrossTileID)l.get(this.covtable.cachedLineSchema[5]);
    }

    public final TilingAdapter getRightEdgeTilingAdapter() {
        return this.getTilingAdapter("right_edge");
    }

    public final DcwCrossTileID getLeftEdge(List l) {
        return (DcwCrossTileID)l.get(this.covtable.cachedLineSchema[6]);
    }

    public final TilingAdapter getLeftEdgeTilingAdapter() {
        return this.getTilingAdapter("left_edge");
    }

    public final CoordFloatString getCoordinates(List l) {
        return (CoordFloatString)l.get(this.covtable.cachedLineSchema[7]);
    }

    public int topologyLevel() {
        if (this.covtable.cachedLineSchema[1] == -1) {
            return 0;
        }
        if (this.covtable.cachedLineSchema[3] == -1) {
            return 2;
        }
        return 3;
    }

    public CoverageTable getCoverageTable() {
        return this.covtable;
    }

    public void drawTile(VPFGraphicWarehouse warehouse, float dpplat, float dpplon, LatLonPoint ll1, LatLonPoint ll2) {
        if (warehouse == null) {
            return;
        }
        try {
            this.seekToRow(1);
            ArrayList edge = new ArrayList();
            while (this.parseRow(edge)) {
                warehouse.createEdge(this.covtable, this, edge, ll1, ll2, dpplat, dpplon, this.getCoordinates(edge));
            }
        }
        catch (FormatException f) {
            System.out.println("Exception: " + f.getClass() + " " + f.getMessage());
        }
    }

    public void drawFeature(VPFFeatureWarehouse warehouse, float dpplat, float dpplon, LatLonPoint ll1, LatLonPoint ll2, List edge, String featureType) {
        if (warehouse == null) {
            return;
        }
        warehouse.createEdge(this.covtable, this, edge, ll1, ll2, dpplat, dpplon, this.getCoordinates(edge), featureType);
    }
}

