/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.util.stateMachine;

import com.bbn.openmap.layer.util.stateMachine.State;
import java.util.Enumeration;
import java.util.Vector;

public class StateMachine {
    protected Vector states = new Vector();
    protected State currentState;
    protected State resetState;

    public StateMachine() {
    }

    public StateMachine(State[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.states.addElement(s[i]);
        }
    }

    public void reset() {
        this.currentState = this.resetState;
    }

    public void setStates(State[] s) {
        this.states.clear();
        this.addStates(s);
    }

    public void setStates(Vector s) {
        this.states = s;
    }

    public Vector getStates() {
        return this.states;
    }

    public void addStates(State[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.states.addElement(s[i]);
        }
    }

    public void setState(State state) {
        if (!this.states.contains(state)) {
            this.states.addElement(state);
        }
        this.currentState = state;
    }

    public void setState(int stateIndex) {
        try {
            this.currentState = (State)this.states.elementAt(stateIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.reset();
            System.err.println("StateMachine: out of bounds exception caught!");
        }
    }

    public void setStateAt(int stateIndex, State state) {
        try {
            this.states.setElementAt(state, stateIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("StateMachine: out of bounds exception caught when trying to replace State that didn't exist.");
        }
    }

    public State getState() {
        return this.currentState;
    }

    public State getState(int stateIndex) {
        try {
            return (State)this.states.elementAt(stateIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("StateMachine: out of bounds exception caught!");
            return null;
        }
    }

    public void setResetState(State state) {
        if (!this.states.contains(state)) {
            this.states.addElement(state);
        }
        this.resetState = state;
    }

    public void setResetState(int stateIndex) {
        block2: {
            try {
                this.resetState = (State)this.states.elementAt(stateIndex);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("StateMachine: out of bounds exception caught!");
                if (this.states.size() <= 1) break block2;
                this.resetState = (State)this.states.elementAt(0);
            }
        }
    }

    public State getResetState() {
        return this.resetState;
    }

    public void setMapMouseListenerResponses(boolean value) {
        Enumeration sItems = this.states.elements();
        while (sItems.hasMoreElements()) {
            State state = (State)sItems.nextElement();
            state.setMapMouseListenerResponse(value);
        }
    }
}

