/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.test;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.geo.BoundaryCrossing;
import com.bbn.openmap.geo.BoundingCircle;
import com.bbn.openmap.geo.ExtentIndex;
import com.bbn.openmap.geo.ExtentIndexImpl;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoPath;
import com.bbn.openmap.geo.GeoPoint;
import com.bbn.openmap.geo.GeoRegion;
import com.bbn.openmap.geo.GeoSegment;
import com.bbn.openmap.geo.Intersection;
import com.bbn.openmap.layer.editor.EditorLayer;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMAbstractLine;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import com.bbn.openmap.omGraphics.SinkGraphic;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.FileUtils;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class GeoIntersectionLayer
extends EditorLayer
implements PropertyChangeListener {
    protected OMGraphicList drawnList = new OMGraphicList();
    protected OMGraphicList fileDataList = new OMGraphicList();
    protected OMGraphicList intersectionResultList = new OMGraphicList();
    protected ExtentIndexImpl regionIndex = null;
    protected DrawingAttributes shapeDA = new DrawingAttributes();
    protected DrawingAttributes shapeDASelected = new DrawingAttributes();
    public static final String ShapeFileListProperty = "shapeFileList";
    public static final String ShapeFileProperty = "shapeFile";
    public static final String ShowCrossingPointsProperty = "showCrossingPoints";
    public static final String PointCheckProperty = "pointCheck";
    public static final String SHAPE_FILE_NAME_ATTRIBUTE = "SHAPE_FILE_NAME";
    public static final String SHAPE_VISIBILITY_CONTROL_ATTRIBUTE = "SHAPE_VISIBILITY_CONTROL";
    public static final String SHAPE_CONTROL_ATTRIBUTE = "SHAPE_CONTROL";
    protected boolean showCrossingPoints = false;
    protected boolean createPointCheck = false;
    public static boolean DEBUG = false;
    JPanel fileListControl;
    JPanel panel = null;
    JCheckBox showCrossingsButton;
    JCheckBox pointCheckButton;

    public GeoIntersectionLayer() {
        DEBUG = Debug.debugging("geo");
        this.shapeDA.getPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.shapeDA.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.shapeDASelected.setProperties(prefix + "selected", props);
        Vector v = PropUtils.parseSpacedMarkers(props.getProperty(prefix + ShapeFileListProperty));
        Iterator it = v.iterator();
        while (it.hasNext()) {
            File sf;
            String markerName = (String)it.next();
            String shapeFileName = props.getProperty(prefix + markerName);
            if (shapeFileName == null || !(sf = new File(shapeFileName)).exists()) continue;
            this.addShapeFile(sf);
        }
    }

    public OMGraphicList prepare() {
        OMGraphicList list = this.getList();
        if (list == null) {
            list = new OMGraphicList();
            if (this.fileDataList.size() == 0) {
                this.addShapeFileFromUser();
            }
        } else {
            list.clear();
        }
        this.calculateIntersectionsWithDrawnList();
        list.add(this.intersectionResultList);
        list.add(this.drawnList);
        if (DEBUG) {
            Debug.output("GeoIntersectLayer(" + this.getName() + "): Adding lines to main list");
        }
        list.add(this.fileDataList);
        if (DEBUG) {
            Debug.output("GeoIntersectLayer(" + this.getName() + "): Adding shapes to main list");
        }
        list.generate(this.getProjection());
        if (DEBUG) {
            Debug.output("GeoIntersectLayer(" + this.getName() + "): Projected main list, returning");
        }
        return list;
    }

    public void calculateIntersectionsWithDrawnList() {
        this.intersectionResultList.clear();
        ExtentIndex rIndex = this.getRegionIndex(true);
        Iterator it = this.drawnList.iterator();
        while (it.hasNext()) {
            OMGraphic omg = (OMGraphic)it.next();
            if (omg instanceof OMLine || omg instanceof OMPoly && !((OMPoly)omg).isPolygon()) {
                if (DEBUG) {
                    Debug.output("GeoIntersectLayer(" + this.getName() + "): Checking line against RegionIndex");
                }
                GeoPath path = this.getPathFromOMGraphic(omg);
                Iterator intrsctns = null;
                Iterator crssngs = null;
                if (this.showCrossingPoints) {
                    BoundaryCrossing.Collector results = BoundaryCrossing.getCrossings(path, rIndex);
                    intrsctns = results.iterator();
                    crssngs = results.getCrossings();
                } else {
                    intrsctns = Intersection.intersect(path, rIndex);
                }
                while (intrsctns.hasNext()) {
                    OMPolyRegion ompr = (OMPolyRegion)intrsctns.next();
                    this.setRegionAsSelected(ompr);
                    if (!DEBUG) continue;
                    Debug.output("GeoIntersectLayer(" + this.getName() + "): Set Poly for hit");
                }
                int num = 0;
                while (crssngs != null && crssngs.hasNext()) {
                    BoundaryCrossing bc = (BoundaryCrossing)crssngs.next();
                    Geo geo = bc.getGeo();
                    OMPoint pgeo = new OMPoint((float)geo.getLatitude(), (float)geo.getLongitude());
                    pgeo.setFillPaint(Color.WHITE);
                    pgeo.putAttribute("Label", new OMTextLabeler(Integer.toString(num++)));
                    this.intersectionResultList.add(pgeo);
                }
                continue;
            }
            if (omg instanceof OMPoly) {
                Iterator hits = Intersection.intersect(new OMPolyRegion((OMPoly)omg), rIndex);
                while (hits.hasNext()) {
                    this.setRegionAsSelected((OMPolyRegion)hits.next());
                    if (!DEBUG) continue;
                    Debug.output("GeoIntersectLayer(" + this.getName() + "): Set Poly for hit");
                }
                continue;
            }
            if (!(omg instanceof OMPoint)) continue;
            OMPoint omp = (OMPoint)omg;
            Iterator hits = Intersection.intersect(new GeoPoint.Impl(omp.getLat(), omp.getLon()), rIndex);
            while (hits.hasNext()) {
                this.setRegionAsSelected((OMPolyRegion)hits.next());
                if (!DEBUG) continue;
                Debug.output("GeoIntersectLayer(" + this.getName() + "): Set Poly for hit");
            }
        }
    }

    protected void setRegionAsSelected(OMPolyRegion ompr) {
        this.shapeDASelected.setTo(ompr.poly);
    }

    protected GeoPath getPathFromOMGraphic(OMGraphic omg) {
        GeoPath path = null;
        if (omg instanceof OMLine) {
            path = this.getPath((OMLine)omg);
        } else if (omg instanceof OMPoly) {
            path = this.getPath((OMPoly)omg);
        }
        return path;
    }

    protected GeoPath getPath(OMLine oml) {
        return new GeoPath.Impl(oml.getLL());
    }

    protected GeoPath getPath(OMPoly omp) {
        return new GeoPath.Impl(omp.getLatLonArray(), false);
    }

    public void addShapeFileFromUser() {
        String shpFileName = FileUtils.getFilePathToOpenFromUser("Pick Shape File", new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith("shp");
            }

            public String getDescription() {
                return "ESRI Shape (.shp) file";
            }
        });
        if (shpFileName != null) {
            this.addShapeFile(new File(shpFileName));
        }
    }

    public void addShapeFile(File shpFile) {
        if (shpFile != null) {
            try {
                String shpFilePath = shpFile.getAbsolutePath();
                String shpFileName = shpFile.getName();
                DrawingAttributes da = new DrawingAttributes();
                da.setSelectPaint(new Color(200, 100, 100, 200));
                EsriGraphicList shapeList = EsriGraphicList.getEsriGraphicList(shpFile.toURL(), da, DbfTableModel.getDbfTableModel(new File(shpFilePath.replaceAll(".shp", ".dbf")).toURL()));
                if (DEBUG) {
                    Debug.output("GeoIntersectLayer(" + this.getName() + "): Adding shapes from " + shpFileName);
                }
                JCheckBox visibilityControl = new JCheckBox("Show", true);
                visibilityControl.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        GeoIntersectionLayer.this.setShapeListVisibilityForCheckbox();
                        GeoIntersectionLayer.this.repaint();
                    }
                });
                JButton removeButton = new JButton("Remove");
                removeButton.addActionListener(new RemoveShapesActionListener(this.fileDataList, shapeList));
                JLabel label = new JLabel(shpFileName, 2);
                JPanel panel = new JPanel();
                GridBagLayout gridbag = new GridBagLayout();
                panel.setLayout(gridbag);
                GridBagConstraints c = new GridBagConstraints();
                c.weightx = 1.0;
                c.insets = new Insets(2, 2, 2, 2);
                c.anchor = 17;
                c.fill = 2;
                gridbag.setConstraints(label, c);
                panel.add(label);
                c.weightx = 0.0;
                c.anchor = 13;
                c.fill = 0;
                gridbag.setConstraints(visibilityControl, c);
                panel.add(visibilityControl);
                gridbag.setConstraints(removeButton, c);
                panel.add(removeButton);
                shapeList.putAttribute(SHAPE_FILE_NAME_ATTRIBUTE, shpFileName);
                shapeList.putAttribute(SHAPE_VISIBILITY_CONTROL_ATTRIBUTE, visibilityControl);
                shapeList.putAttribute(SHAPE_CONTROL_ATTRIBUTE, panel);
                int type = shapeList.getType();
                if (type != 5 && type != 3) {
                    this.fireRequestMessage("The type of shapes contained in the file\n" + shpFileName + "\nisn't handled by this layer.  Choose a file that\ncontains lines or polygons.");
                    return;
                }
                this.fileDataList.add(shapeList);
                this.rebuildFileListControl();
                if (this.getProjection() != null) {
                    this.doPrepare();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    protected void setShapeListVisibilityForCheckbox() {
        Iterator it = this.fileDataList.iterator();
        while (it.hasNext()) {
            OMGraphicList omgl;
            Object obj = it.next();
            if (!(obj instanceof OMGraphicList) || (obj = (omgl = (OMGraphicList)obj).getAttribute(SHAPE_VISIBILITY_CONTROL_ATTRIBUTE)) == null) continue;
            omgl.setVisible(((JCheckBox)obj).isSelected());
        }
    }

    public ExtentIndex getRegionIndex(boolean resetRegionSelection) {
        if (this.regionIndex == null) {
            this.regionIndex = new ExtentIndexImpl();
        }
        if (resetRegionSelection) {
            Iterator reset = this.regionIndex.iterator();
            while (reset.hasNext()) {
                this.shapeDA.setTo(((OMPolyRegion)reset.next()).poly);
            }
            if (DEBUG) {
                Debug.output("GeoIntersectLayer(" + this.getName() + "): Reset region fills");
            }
        }
        return this.regionIndex;
    }

    protected void addToRegionIndex(OMPoly p, ExtentIndex regionIndex) {
        if (regionIndex.addExtent(new OMPolyRegion(p)) && DEBUG) {
            Debug.output("GeoIntersectLayer(" + this.getName() + "): Added poly region to RegionIndex");
        }
    }

    protected void addToRegionIndex(OMGraphicList omgl, ExtentIndex regionIndex) {
        Iterator it = omgl.iterator();
        while (it.hasNext()) {
            Object someObj = it.next();
            if (someObj instanceof OMPoly) {
                this.addToRegionIndex((OMPoly)someObj, regionIndex);
                continue;
            }
            this.addToRegionIndex((OMGraphicList)someObj, regionIndex);
        }
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        this.releaseProxyMouseMode();
        if ((omg instanceof OMLine || omg instanceof OMPoly || omg instanceof OMPoint) && this.drawnList != null) {
            this.drawnList.doAction(omg, action);
            this.deselect(this.drawnList);
            this.doPrepare();
        } else {
            Debug.error("GeoIntersectLayer(" + this.getName() + "):  received " + omg + " and " + action + " with no list ready");
        }
        if (this.editorTool != null) {
            this.editorTool.drawingComplete(omg, action);
        }
    }

    public OMGraphicList getDrawnIntersectorList() {
        return this.drawnList;
    }

    public boolean receivesMapEvents() {
        return false;
    }

    public boolean mouseOver(MapMouseEvent mme) {
        if (this.regionIndex != null) {
            LatLonPoint llp = mme.getLatLon();
            GeoPoint.Impl geop = new GeoPoint.Impl(llp.getLatitude(), llp.getLongitude());
            Iterator hits = Intersection.intersect(geop, this.regionIndex);
            while (hits.hasNext()) {
                OMPolyRegion ompr = (OMPolyRegion)hits.next();
                ompr.poly.select();
                ompr.poly.generate(this.getProjection());
            }
            this.repaint();
        }
        return true;
    }

    public boolean isHighlightable(OMGraphic omg) {
        return this.createPointCheck || this.drawnList != null && this.drawnList.contains(omg);
    }

    public String getToolTipTextFor(OMGraphic omg) {
        if (this.drawnList != null && this.drawnList.contains(omg)) {
            return super.getToolTipTextFor(omg);
        }
        if (this.createPointCheck) {
            return "Click to create point test image mask";
        }
        return null;
    }

    public void highlight(OMGraphic omg) {
        omg.setMatted(true);
        super.highlight(omg);
    }

    public void unhighlight(OMGraphic omg) {
        omg.setMatted(false);
        super.unhighlight(omg);
    }

    public boolean isSelectable(OMGraphic omg) {
        return this.createPointCheck || this.drawnList != null && this.drawnList.contains(omg);
    }

    public void select(OMGraphicList omgl) {
        Iterator it = omgl.iterator();
        while (it.hasNext()) {
            OMGraphic omg = (OMGraphic)it.next();
            if (this.drawnList != null && this.drawnList.contains(omg)) {
                super.select(omgl);
                continue;
            }
            if (!this.createPointCheck) continue;
            this.intersectionResultList.add(this.getPointIntersectionImage(omg));
        }
        this.repaint();
    }

    public void deselect(OMGraphicList omgl) {
        this.intersectionResultList.clear();
        this.repaint();
    }

    public OMGraphic getPointIntersectionImage(OMGraphic omg) {
        GeneralPath s = omg.getShape();
        Projection p = this.getProjection();
        if (s != null && p != null && omg instanceof OMPoly) {
            Rectangle r = s.getBounds();
            double x = r.getX();
            double y = r.getY();
            double h = r.getHeight();
            double w = r.getWidth();
            float[] rawll = ((OMPoly)omg).getLatLonArray();
            LatLonPoint llHolder = new LatLonPoint();
            Geo g = new Geo(0.0, 0.0);
            int[] pix = new int[(int)(h * w)];
            for (double j = 0.0; j < h; j += 1.0) {
                for (double i = 0.0; i < w; i += 1.0) {
                    boolean inShape = s.contains(i + x, j + y);
                    p.inverse((int)(i + x), (int)(j + y), llHolder);
                    g.initialize(llHolder.getLatitude(), llHolder.getLongitude());
                    boolean inGeo = Intersection.isPointInPolygon(g, rawll, false);
                    int val = 0;
                    val = inShape == inGeo ? 1644232448 : 1660878848;
                    pix[(int)(w * j + i)] = val;
                }
            }
            OMRaster omr = new OMRaster((int)x, (int)y, (int)w, (int)h, pix);
            omr.setSelectPaint(OMColor.clear);
            omr.generate(p);
            return omr;
        }
        return SinkGraphic.getSharedInstance();
    }

    protected JPanel getFileListControl() {
        if (this.fileListControl == null) {
            this.fileListControl = PaletteHelper.createHorizontalPanel("Shape Files Being Used for Intersections");
        }
        return this.fileListControl;
    }

    public void rebuildFileListControl() {
        Color dark;
        JPanel p = this.getFileListControl();
        p.setBackground(Color.white);
        Color light = Color.white;
        Color current = dark = Color.LIGHT_GRAY;
        p.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        p.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.getRegionIndex(false).clear();
        Iterator it = this.fileDataList.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof EsriGraphicList)) continue;
            EsriGraphicList shapeList = (EsriGraphicList)obj;
            JPanel control = (JPanel)shapeList.getAttribute(SHAPE_CONTROL_ATTRIBUTE);
            if (control != null) {
                control.setBackground(current);
                Component[] comps = control.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    comps[i].setBackground(current);
                }
                current = current == dark ? light : dark;
                gridbag.setConstraints(control, c);
                p.add(control);
            }
            this.addToRegionIndex(shapeList, this.getRegionIndex(false));
        }
        if (this.fileDataList.size() == 0) {
            JLabel label = new JLabel("No Shape Files Loaded", 0);
            c.anchor = 10;
            gridbag.setConstraints(label, c);
            p.add(label);
        }
        c.fill = 1;
        c.weighty = 1.0;
        JLabel filler = new JLabel("");
        gridbag.setConstraints(filler, c);
        p.add(filler);
        p.revalidate();
    }

    public Component getGUI() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.panel.setLayout(gridbag);
            c.gridx = 0;
            c.weightx = 1.0;
            c.insets = new Insets(1, 5, 1, 5);
            c.fill = 2;
            JPanel daPanel1 = PaletteHelper.createHorizontalPanel("Paint Settings for Shapes");
            daPanel1.add(this.shapeDA.getGUI());
            JPanel daPanel2 = PaletteHelper.createHorizontalPanel("Paint Settings for Intersected Shapes");
            daPanel2.add(this.shapeDASelected.getGUI());
            gridbag.setConstraints(daPanel1, c);
            gridbag.setConstraints(daPanel2, c);
            this.panel.add(daPanel1);
            this.panel.add(daPanel2);
            c.weighty = 1.0;
            c.fill = 1;
            JPanel tablePanel = this.getFileListControl();
            gridbag.setConstraints(tablePanel, c);
            this.panel.add(tablePanel);
            JPanel checkPanel = new JPanel();
            GridBagLayout gb = new GridBagLayout();
            checkPanel.setLayout(gb);
            GridBagConstraints c2 = new GridBagConstraints();
            c2.anchor = 17;
            c2.gridx = 0;
            this.showCrossingsButton = new JCheckBox("Show Crossing Points", this.showCrossingPoints);
            this.showCrossingsButton.setToolTipText("<html>Show ordered points where drawn lines cross Shapes.");
            this.showCrossingsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    GeoIntersectionLayer.this.setShowCrossingPoints(((JCheckBox)ae.getSource()).isSelected());
                    GeoIntersectionLayer.this.doPrepare();
                }
            });
            gb.setConstraints(this.showCrossingsButton, c2);
            checkPanel.add(this.showCrossingsButton);
            this.pointCheckButton = new JCheckBox("Click Creates Image Mask", this.showCrossingPoints);
            this.pointCheckButton.setToolTipText("<html>When clicking on Shape, create image mask that shows Geo point<br>intersection vs. Java 2D. Green is good.");
            this.pointCheckButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    GeoIntersectionLayer.this.setCreatePointCheck(((JCheckBox)ae.getSource()).isSelected());
                    GeoIntersectionLayer.this.doPrepare();
                }
            });
            gb.setConstraints(this.pointCheckButton, c2);
            checkPanel.add(this.pointCheckButton);
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            gridbag.setConstraints(checkPanel, c);
            this.panel.add(checkPanel);
            JButton addButton = new JButton("Add Shape File...");
            addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    GeoIntersectionLayer.this.addShapeFileFromUser();
                }
            });
            c.insets = new Insets(5, 5, 5, 5);
            gridbag.setConstraints(addButton, c);
            this.panel.add(addButton);
        }
        return this.panel;
    }

    public boolean isShowCrossingPoints() {
        return this.showCrossingPoints;
    }

    public void setShowCrossingPoints(boolean showCrossingPoints) {
        this.showCrossingPoints = showCrossingPoints;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.shapeDA.setTo(this.fileDataList);
        this.repaint();
    }

    public DrawingAttributes getShapeDA() {
        return this.shapeDA;
    }

    public void setShapeDA(DrawingAttributes shapeDA) {
        this.shapeDA = shapeDA;
    }

    public DrawingAttributes getShapeDASelected() {
        return this.shapeDASelected;
    }

    public void setShapeDASelected(DrawingAttributes shapeDASelected) {
        this.shapeDASelected = shapeDASelected;
    }

    public boolean isCreatePointCheck() {
        return this.createPointCheck;
    }

    public void setCreatePointCheck(boolean createPointCheck) {
        this.createPointCheck = createPointCheck;
    }

    public void runGeoTests(int numIterations, int numToSkipAtStart) {
        Mercator proj = new Mercator(new LatLonPoint(35.0f, -90.0f), 1.0E8f, 800, 800);
        double[] results = new double[7];
        for (int i = 0; i < numIterations; ++i) {
            boolean countThisIteration = i >= numToSkipAtStart;
            long startTime = System.currentTimeMillis();
            this.setProjection(proj.makeClone());
            this.calculateIntersectionsWithDrawnList();
            long endTime = System.currentTimeMillis();
            if (countThisIteration) {
                results[0] = results[0] + (double)(endTime - startTime);
            }
            OMAbstractLine omg = new OMLine(20.0f, -125.0f, 30.0f, -70.0f, 3);
            this.getDrawnIntersectorList().add(omg);
            startTime = System.currentTimeMillis();
            this.calculateIntersectionsWithDrawnList();
            endTime = System.currentTimeMillis();
            if (countThisIteration) {
                results[1] = results[1] + (double)(endTime - startTime);
            }
            this.setShowCrossingPoints(true);
            startTime = System.currentTimeMillis();
            this.calculateIntersectionsWithDrawnList();
            endTime = System.currentTimeMillis();
            if (countThisIteration) {
                results[2] = results[2] + (double)(endTime - startTime);
            }
            this.getDrawnIntersectorList().clear();
            this.setShowCrossingPoints(false);
            float[] coords = new float[]{33.4f, -77.2f, 34.0f, -79.5f, 35.0f, -90.0f, 40.0f, -100.0f, 45.0f, -101.0f, 50.0f, -83.2f, 35.0f, -65.7f, -34.0f, -70.5f, 33.4f, -77.2f};
            omg = new OMPoly(coords, 0, 3);
            this.getDrawnIntersectorList().add(omg);
            startTime = System.currentTimeMillis();
            this.calculateIntersectionsWithDrawnList();
            endTime = System.currentTimeMillis();
            if (countThisIteration) {
                results[3] = results[3] + (double)(endTime - startTime);
            }
            this.setShowCrossingPoints(true);
            startTime = System.currentTimeMillis();
            this.calculateIntersectionsWithDrawnList();
            endTime = System.currentTimeMillis();
            if (countThisIteration) {
                results[4] = results[4] + (double)(endTime - startTime);
            }
            omg.setFillPaint(Color.red);
            this.setShowCrossingPoints(false);
            startTime = System.currentTimeMillis();
            this.calculateIntersectionsWithDrawnList();
            endTime = System.currentTimeMillis();
            if (countThisIteration) {
                results[5] = results[5] + (double)(endTime - startTime);
            }
            this.setShowCrossingPoints(true);
            startTime = System.currentTimeMillis();
            this.calculateIntersectionsWithDrawnList();
            endTime = System.currentTimeMillis();
            if (countThisIteration) {
                results[6] = results[6] + (double)(endTime - startTime);
            }
            System.out.print(".");
            System.out.flush();
        }
        double numIterationsCounted = numIterations - numToSkipAtStart;
        Debug.output("For " + numIterationsCounted + " iterations");
        Debug.output(" avg time to calculate without Intersection: " + results[0] / numIterationsCounted + " ms");
        Debug.output(" avg time to calculate with Intersection line: " + results[1] / numIterationsCounted + " ms");
        Debug.output(" avg time to calculate with Intersection line with crossing points: " + results[2] / numIterationsCounted + " ms");
        Debug.output(" avg time to calculate with Intersection poly: " + results[3] / numIterationsCounted + " ms");
        Debug.output(" avg time to calculate with Intersection poly with crossing points: " + results[4] / numIterationsCounted + " ms");
        Debug.output(" avg time to calculate with Intersection Containment poly: " + results[5] / numIterationsCounted + " ms");
        Debug.output(" avg time to calculate with Intersection Containment poly and crossing points: " + results[6] / numIterationsCounted + " ms");
    }

    public static void main(String[] argv) {
        Debug.init();
        ArgParser argp = new ArgParser("GeoIntersectionLayer");
        argp.add("shape", "Shape file to use for GeoRegions in index.", 1);
        argp.parse(argv);
        String[] files = argp.getArgValues("shape");
        if (files != null && files.length > 0 && files[0].endsWith(".shp")) {
            File file = new File(files[0]);
            GeoIntersectionLayer gil = new GeoIntersectionLayer();
            Debug.output("Loading shape file: " + file.getName());
            long startTime = System.currentTimeMillis();
            gil.addShapeFile(file);
            long endTime = System.currentTimeMillis();
            Debug.output(" time to load file: " + (endTime - startTime) + " ms");
            gil.runGeoTests(25, 3);
        } else {
            argp.printUsage();
            System.exit(0);
        }
    }

    protected class RemoveShapesActionListener
    implements ActionListener {
        protected OMGraphicList mainDataList;
        protected OMGraphicList toBeRemoved;

        public RemoveShapesActionListener(OMGraphicList mdl, OMGraphicList tbr) {
            this.mainDataList = mdl;
            this.toBeRemoved = tbr;
        }

        public void actionPerformed(ActionEvent ae) {
            this.mainDataList.remove(this.toBeRemoved);
            GeoIntersectionLayer.this.rebuildFileListControl();
            GeoIntersectionLayer.this.doPrepare();
        }
    }

    public static class OMLineSegment
    implements GeoSegment {
        Geo[] geos;
        float[] segArray;

        public OMLineSegment(OMLine oml) {
            this.segArray = oml.getLL();
            this.geos = new Geo[2];
            this.geos[0] = new Geo(this.segArray[0], this.segArray[1]);
            this.geos[1] = new Geo(this.segArray[2], this.segArray[3]);
        }

        public Geo[] getSeg() {
            return this.geos;
        }

        public float[] getSegArray() {
            return this.segArray;
        }

        public Object getID() {
            return this;
        }

        public BoundingCircle getBoundingCircle() {
            return new BoundingCircle.Impl(this.getSeg());
        }
    }

    public static class OMPolyRegion
    extends GeoRegion.Impl {
        public OMPoly poly;

        public OMPolyRegion(OMPoly omp) {
            super(omp.getLatLonArray(), false);
            this.poly = omp;
        }

        public Object getID() {
            return this;
        }
    }
}

