/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.util.Debug;
import java.awt.Point;

public class RpfCoverageBox {
    public double nw_lat;
    public double nw_lon;
    public double se_lat;
    public double se_lon;
    public double subframeLatInterval;
    public double subframeLonInterval;
    public String chartCode;
    public Point startIndexes;
    public Point endIndexes;
    public int zone;
    public int tocNumber;
    public int entryNumber;
    public float scale;
    public float percentCoverage;
    protected String id;

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(" nw_lat " + this.nw_lat + ", nw_lon " + this.nw_lon + "\n");
        s.append(" se_lat " + this.se_lat + ", se_lon " + this.se_lon + "\n");
        s.append(" chart code " + this.chartCode + "\n");
        s.append(" scale (parsed and decoded) " + this.scale + "\n");
        s.append(" vertical subframes " + this.verticalSubframes() + "\n");
        s.append(" horizontal subframes " + this.horizontalSubframes() + "\n");
        s.append(" percent coverage " + this.percentCoverage);
        return s.toString();
    }

    public String getID() {
        if (this.id == null) {
            this.id = (double)(this.tocNumber + this.entryNumber) + this.nw_lat + this.nw_lon + this.se_lat + this.se_lon + this.chartCode;
        }
        return this.id;
    }

    public int verticalSubframes() {
        double value = Math.abs((this.nw_lat - this.se_lat) / this.subframeLatInterval);
        int lower = (int)value;
        int upper = lower + 1;
        if ((double)upper - value < 1.0E-6) {
            return upper;
        }
        return lower;
    }

    public int horizontalSubframes() {
        double value = Math.abs((this.se_lon - this.nw_lon) / this.subframeLonInterval);
        int lower = (int)value;
        int upper = lower + 1;
        if ((double)upper - value < 1.0E-6) {
            return upper;
        }
        return lower;
    }

    public int setBoundaryHits(float ullat, float ullon, float lrlat, float lrlon) {
        int boundaryHits = 0;
        if ((double)lrlat < this.nw_lat) {
            ++boundaryHits;
        }
        if ((double)ullat > this.se_lat) {
            ++boundaryHits;
        }
        if ((double)lrlon > this.nw_lon) {
            ++boundaryHits;
        }
        if ((double)ullon < this.se_lon) {
            ++boundaryHits;
        }
        if ((double)ullat < this.nw_lat) {
            ++boundaryHits;
        }
        if ((double)lrlat > this.se_lat) {
            ++boundaryHits;
        }
        if ((double)ullon > this.nw_lon) {
            ++boundaryHits;
        }
        if ((double)lrlon < this.se_lon) {
            ++boundaryHits;
        }
        return boundaryHits;
    }

    public float setPercentCoverage(float ullat, float ullon, float lrlat, float lrlon) {
        this.startIndexes = new Point();
        this.endIndexes = new Point();
        return this.setPercentCoverage(ullat, ullon, lrlat, lrlon, this.startIndexes, this.endIndexes);
    }

    public float setPercentCoverage(float ullat, float ullon, float lrlat, float lrlon, Point start, Point end) {
        this.startIndexes = start;
        this.endIndexes = end;
        double tempInterval = ((double)ullon - this.nw_lon) / this.subframeLonInterval;
        start.x = (int)tempInterval;
        if (tempInterval < 0.0 && tempInterval < (double)start.x) {
            --start.x;
        }
        tempInterval = (this.nw_lat - (double)ullat) / this.subframeLatInterval;
        start.y = (int)tempInterval;
        if (tempInterval < 0.0 && tempInterval < (double)start.y) {
            --start.y;
        }
        tempInterval = ((double)lrlon - this.nw_lon) / this.subframeLonInterval;
        end.x = (int)tempInterval;
        if (tempInterval < 0.0 && tempInterval < (double)end.x) {
            --end.x;
        }
        tempInterval = (this.nw_lat - (double)lrlat) / this.subframeLatInterval;
        end.y = (int)tempInterval;
        if (tempInterval < 0.0 && tempInterval < (double)end.y) {
            --end.y;
        }
        int num_horiz_subframes = this.horizontalSubframes();
        int num_vert_subframes = this.verticalSubframes();
        if (!(start.y < 0 && end.y < 0 || start.x < 0 && end.x < 0 || start.x >= num_horiz_subframes && end.x >= num_horiz_subframes || start.y >= num_vert_subframes && end.y >= num_vert_subframes)) {
            int left = start.x < 0 ? 0 : start.x;
            int right = end.x >= num_horiz_subframes ? num_horiz_subframes - 1 : end.x;
            int top = start.y < 0 ? 0 : start.y;
            int bottom = end.y >= num_vert_subframes ? num_vert_subframes - 1 : end.y;
            this.percentCoverage = ((float)Math.abs(right - left) + 1.0f) * ((float)Math.abs(bottom - top) + 1.0f) / (((float)Math.abs(end.x - start.x) + 1.0f) * (float)(Math.abs(end.y - start.y) + 1)) * 100.0f;
            if (this.percentCoverage > 100.0f) {
                this.percentCoverage = 100.0f;
            }
            if (Debug.debugging("rpf")) {
                System.out.println("Calculated percentage = " + this.percentCoverage + " <= " + (Math.abs(right - left) + 1) * (Math.abs(bottom - top) + 1) + " subframes / " + (Math.abs(end.x - start.x) + 1) * (Math.abs(end.y - start.y) + 1) + " subframes\n (" + right + " - " + left + ") * (" + bottom + " - " + top + ") / (" + end.x + " - " + start.x + ") * (" + end.y + " - " + start.y + ")");
            }
        } else {
            this.percentCoverage = 0.0f;
        }
        return this.percentCoverage;
    }

    public float getPercentCoverage() {
        return this.percentCoverage;
    }

    public boolean within(float lat, float lon) {
        double y = lat;
        double x = lon;
        return y < this.nw_lat && y > this.se_lat && x < this.se_lon && x > this.nw_lon;
    }

    public void reset() {
        this.percentCoverage = 0.0f;
        this.scale = 0.0f;
    }
}

