/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location.db;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;

public class RawDataRecordSet {
    protected Connection connection;
    protected String tableName;
    protected String rawDataColumnName;
    protected String rawDataKeyColumnName;
    protected Hashtable byteCache = new Hashtable();
    public static final String tableNameProperty = "rawDataTableName";
    public static final String rawDataColumnNameProperty = "rawDataColumnName";
    public static final String rawDataKeyColumnNameProperty = "rawDataKeyColumnName";

    public RawDataRecordSet() {
    }

    public RawDataRecordSet(Connection inConnection) {
        this.setConnection(inConnection);
    }

    public RawDataRecordSet(Connection inconnection, String prefix, Properties properties) {
        prefix = prefix != null ? prefix + "." : "";
        this.setConnection(inconnection);
        this.setTableName(properties.getProperty(prefix + tableNameProperty));
        this.setRawDataColumnName(properties.getProperty(prefix + rawDataColumnNameProperty));
        this.setRawDataKeyColumnName(properties.getProperty(prefix + rawDataKeyColumnNameProperty));
    }

    public byte[] getRawData(String lookUpKey) throws SQLException {
        byte[] foundit = (byte[])this.byteCache.get(lookUpKey.toLowerCase().intern());
        if (foundit != null) {
            return foundit;
        }
        String query = "Select " + this.rawDataColumnName + " from " + this.tableName + " where " + this.rawDataKeyColumnName + " = '" + lookUpKey.toLowerCase() + "' ";
        try {
            Statement stmt = this.connection.createStatement();
            ResultSet rset = stmt.executeQuery(query);
            rset.next();
            InputStream dbis = rset.getBinaryStream(1);
            int chunksize = 4096;
            byte[] barr = new byte[chunksize];
            int imagelength = 0;
            try {
                imagelength = dbis.read(barr);
            }
            catch (IOException ioE) {
                System.err.println("ERROR - while reading raw data\n" + ioE.getMessage());
            }
            byte[] image = new byte[imagelength];
            System.arraycopy(barr, 0, image, 0, imagelength);
            rset.close();
            stmt.close();
            this.byteCache.put(lookUpKey.toLowerCase().intern(), image);
            return image;
        }
        catch (SQLException sqlE) {
            System.err.println("ERROR - " + sqlE.getMessage() + "\n" + "SQL String: " + query);
            return null;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection inConnection) {
        this.connection = inConnection;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String inTableName) {
        this.tableName = inTableName;
    }

    public String getRawDataColumnName() {
        return this.rawDataColumnName;
    }

    public void setRawDataColumnName(String inrawDataColumnName) {
        this.rawDataColumnName = inrawDataColumnName;
    }

    public String getRawDataKeyColumnName() {
        return this.rawDataKeyColumnName;
    }

    public void setRawDataKeyColumnName(String inrawDataKeyColumnName) {
        this.rawDataKeyColumnName = inrawDataKeyColumnName;
    }
}

