/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.location.LocationLayer;
import com.bbn.openmap.layer.location.LocationPopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;

public class LocationMenuItem
extends JMenuItem
implements ActionListener {
    protected LocationPopupMenu clp;
    protected LocationLayer layer;

    public LocationMenuItem() {
    }

    public LocationMenuItem(String text) {
        super(text);
        this.addActionListener(this);
    }

    public LocationMenuItem(String text, int mnemonic) {
        super(text, mnemonic);
        this.addActionListener(this);
    }

    public LocationMenuItem(String text, LocationPopupMenu aCLP, LocationLayer aLayer) {
        this(text);
        this.setLocationPopupMenu(aCLP);
        this.setLayer(aLayer);
    }

    public void setLocationPopupMenu(LocationPopupMenu aCLP) {
        this.clp = aCLP;
    }

    public LocationPopupMenu getLocationPopupMenu() {
        return this.clp;
    }

    public void setLayer(LocationLayer aLayer) {
        this.layer = aLayer;
    }

    public LocationLayer getLayer() {
        return this.layer;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (this.layer != null && e.getSource().equals(this)) {
            if (command == "Re-center map") {
                MouseEvent evt = this.clp.getEvent();
                LatLonPoint llp = this.layer.getProjection().inverse(evt.getX(), evt.getY());
                this.clp.getMap().setCenter(llp.getLatitude(), llp.getLongitude());
            } else if (command.equals("Show Details")) {
                this.clp.getLoc().showDetails(this.layer);
            }
        }
    }
}

