/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link.amp;

import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.layer.link.ClientLink;
import com.bbn.openmap.layer.link.LinkActionList;
import com.bbn.openmap.layer.link.LinkGraphic;
import com.bbn.openmap.layer.link.LinkLayer;
import com.bbn.openmap.layer.link.LinkOMGraphicList;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRangeRings;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.drawing.DrawingTool;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JPanel;

public class AmpLinkLayer
extends LinkLayer
implements Tool {
    public static final String RRIntervalUnitsProperty = ".rangeRingIntervalUnits";
    public static final String RRIntervalProperty = ".rangeRingInterval";
    protected OMGraphicList extraGraphics = new OMGraphicList();
    protected DrawingTool drawingTool = null;
    protected final DrawingToolRequestor layer = this;
    protected Container gui;
    protected JButton rrButton;
    protected JButton eZone;
    protected String key = "AMPControls";

    public AmpLinkLayer() {
    }

    public AmpLinkLayer(String host, int port, String propertiesURL) {
        super(host, port, propertiesURL);
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.setAddToBeanContext(true);
    }

    public synchronized OMGraphicList prepare() {
        Projection projection = this.getProjection();
        if (projection != null) {
            this.extraGraphics.generate(projection);
        }
        return super.prepare();
    }

    public void paint(Graphics g) {
        if (Debug.debugging("link")) {
            System.out.println(this.getName() + "|AmpLinkLayer.paint()");
        }
        if (this.extraGraphics != null) {
            this.extraGraphics.render(g);
        }
        super.paint(g);
    }

    public boolean mouseClicked(MouseEvent e) {
        Debug.message("link", "AmpLinkLayer mouseClicked");
        LinkOMGraphicList graphics = this.getGraphicList();
        OMGraphic gesGraphic = null;
        gesGraphic = graphics.findClosest(e.getX(), e.getY(), this.distanceLimit);
        if (gesGraphic == null) {
            gesGraphic = this.extraGraphics.findClosest(e.getX(), e.getY(), this.distanceLimit);
        }
        if (gesGraphic != null && this.drawingTool != null) {
            DrawingTool dt = this.getDrawingTool();
            OMGraphic graphic = null;
            if (dt != null) {
                graphic = dt.edit(gesGraphic, this.layer);
            }
            if (graphic != null) {
                Debug.message("link", "AmpLinkLayer editing graphic");
                return true;
            }
            Debug.message("link", "AmpLinkLayer unable to edit graphic");
        }
        return super.mouseClicked(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawingComplete(OMGraphic omg, OMAction action) {
        block14: {
            String id = null;
            Object obj = omg.getAppObject();
            LinkProperties lp = null;
            if (obj != null && obj instanceof LinkProperties) {
                lp = (LinkProperties)obj;
                id = lp.getProperty("gid");
                Debug.message("link", "AmpLinkLayer: received modified server graphic " + lp);
            } else {
                Debug.message("link", "AmpLinkLayer: received new graphic from dt");
            }
            if (id == null) {
                action.setMask(64);
            } else {
                action.setMask(128);
            }
            if (omg instanceof OMRangeRings) {
                this.extraGraphics.doAction(omg, action);
                this.repaint();
                return;
            }
            try {
                ClientLink l = this.linkManager.getLink(true);
                if (l == null) {
                    System.err.println("LinkLayer.drawingComplete: unable to get link.");
                    return;
                }
                ClientLink clientLink = l;
                synchronized (clientLink) {
                    LinkActionList lal = new LinkActionList(l, new LinkProperties());
                    if (action.isMask(64) || action.isMask(128)) {
                        lal.writeGraphicGestureHeader(action.getValue());
                        LinkGraphic.write(omg, l);
                    } else {
                        lal.modifyGraphic(action.getValue(), lp);
                    }
                    lal.end("\r");
                }
                l.readAndParse(this.getProjection(), this.currentGenerator);
                this.linkManager.finLink();
            }
            catch (UnknownHostException uhe) {
                Debug.error("LinkLayer: unknown host!");
            }
            catch (IOException ioe) {
                Debug.error("LinkLayer: Communication error between " + this.getName() + " layer\nand Link Server: Host: " + this.host + ", Port: " + this.port + "LinkLayer: IOException contacting server!\n" + ioe.getMessage());
                this.linkManager.resetLink();
                if (this.quiet) break block14;
                this.fireRequestMessage("Communication error between " + this.getName() + " layer\nand Link Server: Host: " + this.host + ", Port: " + this.port);
            }
        }
        this.doPrepare();
    }

    public Container getFace() {
        if (this.gui == null) {
            this.gui = new JPanel();
            this.rrButton = new JButton("RR");
            this.rrButton.setToolTipText("Create Range Ring");
            this.rrButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DrawingTool dt = AmpLinkLayer.this.getDrawingTool();
                    GraphicAttributes ga = new GraphicAttributes();
                    ga.setLinePaint(Color.yellow);
                    if (dt != null) {
                        OMRangeRings rr = (OMRangeRings)AmpLinkLayer.this.getDrawingTool().create("com.bbn.openmap.omGraphics.OMRangeRings", ga, AmpLinkLayer.this.layer);
                        if (rr == null) {
                            Debug.error("AmpLinkLayer: Drawing tool can't create OMRangeRings");
                        }
                    } else {
                        Debug.output("AmpLinkLayer can't find a drawing tool");
                    }
                }
            });
            this.eZone = new JButton("EZ");
            this.eZone.setToolTipText("Create Exclusion Zone");
            this.eZone.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DrawingTool dt = AmpLinkLayer.this.getDrawingTool();
                    GraphicAttributes ga = new GraphicAttributes();
                    ga.setRenderType(1);
                    ga.setLinePaint(Color.red);
                    if (dt != null) {
                        OMCircle circle = (OMCircle)AmpLinkLayer.this.getDrawingTool().create("com.bbn.openmap.omGraphics.OMCircle", ga, AmpLinkLayer.this.layer);
                        if (circle == null) {
                            Debug.error("AmpLinkLayer: Drawing tool can't create Exclusion Zones");
                        }
                    } else {
                        Debug.output("AmpLinkLayer can't find a drawing tool");
                    }
                }
            });
            this.gui.add(this.rrButton);
            this.gui.add(this.eZone);
        }
        return this.gui;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String aKey) {
        this.key = aKey;
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof DrawingTool) {
            Debug.message("link", "AmpLinkLayer: found a drawing tool");
            this.setDrawingTool((DrawingTool)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof DrawingTool && this.getDrawingTool() == (DrawingTool)someObj) {
            this.setDrawingTool(null);
        }
    }

    public void setDrawingTool(DrawingTool dt) {
        this.drawingTool = dt;
    }

    public DrawingTool getDrawingTool() {
        return this.drawingTool;
    }
}

