/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.GraphicUpdate;
import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkActionConstants;
import com.bbn.openmap.layer.link.LinkActionList;
import com.bbn.openmap.layer.link.LinkActionRequest;
import com.bbn.openmap.layer.link.LinkBoundingPoly;
import com.bbn.openmap.layer.link.LinkGraphic;
import com.bbn.openmap.layer.link.LinkGraphicList;
import com.bbn.openmap.layer.link.LinkMapRequest;
import com.bbn.openmap.layer.link.LinkOMGraphicList;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.layer.link.LinkServer;
import com.bbn.openmap.layer.link.LinkUtil;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;

public class TestLinkServer
extends LinkServer
implements LinkActionConstants,
LinkPropertiesConstants {
    int newGraphicCounter = 0;
    LinkOMGraphicList clientCreatedGraphics = new LinkOMGraphicList();

    public TestLinkServer(Socket s) {
        super(s);
    }

    public void handleClient() throws IOException {
        while (true) {
            this.link.readAndParse();
            boolean validQuery = false;
            System.out.println("TestLinkServer: fielding request");
            LinkMapRequest graphicsQuery = this.link.getMapRequest();
            LinkActionRequest gestureQuery = this.link.getActionRequest();
            LinkActionList actionList = this.link.getActionList();
            if (graphicsQuery != null) {
                System.out.println(graphicsQuery);
                this.getRectangle(graphicsQuery, this.link);
                validQuery = true;
            }
            if (gestureQuery != null) {
                System.out.println(gestureQuery);
                this.handleGesture(gestureQuery, this.link);
                validQuery = true;
            }
            if (actionList != null) {
                Vector graphicUpdates = actionList.getGraphicUpdates();
                Iterator it = graphicUpdates.iterator();
                while (it.hasNext()) {
                    GraphicUpdate gu = (GraphicUpdate)it.next();
                    if (gu == null) continue;
                    String id = gu.id;
                    System.out.println("TestLinkServer: graphic id = " + id);
                    OMGraphic graphic = gu.graphic;
                    int index = this.clientCreatedGraphics.getOMGraphicIndexWithId(id);
                    if (index != -1) {
                        System.out.println("TestLinkServer: modifying graphic");
                        this.clientCreatedGraphics.setOMGraphicAt(gu.graphic, index);
                    } else {
                        System.out.println("TestLinkServer: new graphic");
                        LinkProperties props = (LinkProperties)graphic.getAppObject();
                        props.setProperty("gid", "graphic" + this.newGraphicCounter++);
                        System.out.println("TestLinkServer: new graphic given id " + props);
                    }
                    this.clientCreatedGraphics.doAction(gu.graphic, new OMAction(gu.action));
                }
            }
            if (validQuery) continue;
            this.huh(this.link);
        }
    }

    public void getRectangle(LinkMapRequest query, Link link) throws IOException {
        LinkProperties lineProperties = new LinkProperties("lc", "FFFF0000");
        lineProperties.setProperty("gid", "testline1");
        lineProperties.setProperty("fc", "FFFF0000");
        lineProperties.setProperty("hc", "FFFFFF00");
        lineProperties.setProperty("lw", "1");
        lineProperties.setProperty("info", "Testing info line.");
        int count = 0;
        LinkGraphicList gr = new LinkGraphicList(link, new LinkProperties());
        LinkBoundingPoly[] bounds = query.getBoundingPolys();
        for (int i = 0; i < bounds.length; ++i) {
            gr.addLine(bounds[i].maxY, bounds[i].minX, bounds[i].minY, bounds[i].maxX, 1, -1, lineProperties);
            ++count;
            int[] data = new int[10000];
            for (int j = 0; j < 10000; ++j) {
                data[j] = j < 3000 ? -65536 : (j < 6000 ? -16711936 : (j < 8000 ? -16776961 : -5592406));
            }
            gr.addGrid(42.0f, -70.0f, 100, 100, 0.0f, 0.001f, 0.001f, 0, data, new LinkProperties());
            ++count;
        }
        LinkGraphic.write(this.clientCreatedGraphics, link);
        gr.end("\n");
        System.out.println("TestLinkServer: Wrote " + count + " graphics to output stream");
        int des = LinkUtil.setMask(0, 1);
        des = LinkUtil.unsetMask(des, 2048);
        new LinkActionRequest(link, des, "\r");
        System.out.println("TestLinkServer: Wrote gesture descriptor to output stream");
    }

    public void handleGesture(LinkActionRequest glq, Link link) throws IOException {
        LinkProperties props = new LinkProperties();
        props.setProperty("info", "Mouse Clicked at: x = " + glq.getX() + ", y = " + glq.getY());
        LinkActionList glr = new LinkActionList(link, props);
        String gid = glq.getGraphicID();
        if (gid == null) {
            System.out.println("Deselecting graphic");
            glr.deselectGraphics();
        } else {
            System.out.println("Selecting graphic");
            props.clear();
            props.setProperty("gid", gid);
            glr.modifyGraphic(8, props);
        }
        glr.end("\r");
    }
}

