/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.OMRasterObject;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.ImageIcon;

public class LinkRaster
implements LinkGraphicConstants,
LinkPropertiesConstants {
    public static void write(float lt, float ln, int w, int h, int[] pix, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RA>".getBytes());
        dos.writeByte(7);
        dos.writeByte(1);
        dos.writeByte(0);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeInt(pix.length);
        for (int i = 0; i < pix.length; ++i) {
            dos.writeInt(pix[i]);
        }
        properties.write(dos);
    }

    public static void write(int x1, int y1, int w, int h, int[] pix, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RA>".getBytes());
        dos.writeByte(7);
        dos.writeByte(2);
        dos.writeByte(0);
        dos.writeInt(x1);
        dos.writeInt(y1);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeInt(pix.length);
        for (int i = 0; i < pix.length; ++i) {
            dos.writeInt(pix[i]);
        }
        properties.write(dos);
    }

    public static void write(float lt, float ln, int offset_x1, int offset_y1, int w, int h, int[] pix, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RA>".getBytes());
        dos.writeByte(7);
        dos.writeByte(3);
        dos.writeByte(0);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        dos.writeInt(offset_x1);
        dos.writeInt(offset_y1);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeInt(pix.length);
        for (int i = 0; i < pix.length; ++i) {
            dos.writeInt(pix[i]);
        }
        properties.write(dos);
    }

    public static void write(float lt, float ln, Image image, int image_width, int image_height, LinkProperties properties, DataOutputStream dos) throws IOException, InterruptedException {
        int[] pixels = new int[image_width * image_height];
        PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, image_width, image_height, pixels, 0, image_width);
        pixelgrabber.grabPixels();
        LinkRaster.write(lt, ln, image_width, image_height, pixels, properties, dos);
    }

    public static void write(int x1, int y1, Image image, int image_width, int image_height, LinkProperties properties, DataOutputStream dos) throws IOException, InterruptedException {
        int[] pixels = new int[image_width * image_height];
        PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, image_width, image_height, pixels, 0, image_width);
        pixelgrabber.grabPixels();
        LinkRaster.write(x1, y1, image_width, image_height, pixels, properties, dos);
    }

    public static void write(float lt, float ln, int offset_x1, int offset_y1, Image image, int image_width, int image_height, LinkProperties properties, DataOutputStream dos) throws IOException, InterruptedException {
        int[] pixels = new int[image_width * image_height];
        PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, image_width, image_height, pixels, 0, image_width);
        pixelgrabber.grabPixels();
        LinkRaster.write(lt, ln, offset_x1, offset_y1, image_width, image_height, pixels, properties, dos);
    }

    public static void write(float lt, float ln, ImageIcon ii, LinkProperties properties, DataOutputStream dos) throws IOException, InterruptedException {
        int image_width = ii.getIconWidth();
        int image_height = ii.getIconHeight();
        Image image = ii.getImage();
        LinkRaster.write(lt, ln, image, image_width, image_height, properties, dos);
    }

    public static void write(int x1, int y1, ImageIcon ii, LinkProperties properties, DataOutputStream dos) throws IOException, InterruptedException {
        int image_width = ii.getIconWidth();
        int image_height = ii.getIconHeight();
        Image image = ii.getImage();
        LinkRaster.write(x1, y1, image, image_width, image_height, properties, dos);
    }

    public static void write(float lt, float ln, int offset_x1, int offset_y1, ImageIcon ii, LinkProperties properties, DataOutputStream dos) throws IOException, InterruptedException {
        int image_width = ii.getIconWidth();
        int image_height = ii.getIconHeight();
        Image image = ii.getImage();
        LinkRaster.write(lt, ln, offset_x1, offset_y1, image, image_width, image_height, properties, dos);
    }

    public static void write(float lt, float ln, String url, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RA>".getBytes());
        dos.writeByte(7);
        dos.writeByte(1);
        dos.writeByte(2);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        properties.setProperty("riu", url);
        properties.write(dos);
    }

    public static void write(int x1, int y1, String url, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RA>".getBytes());
        dos.writeByte(7);
        dos.writeByte(2);
        dos.writeByte(2);
        dos.writeInt(x1);
        dos.writeInt(y1);
        properties.setProperty("riu", url);
        properties.write(dos);
    }

    public static void write(float lt, float ln, int offset_x1, int offset_y1, String url, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RA>".getBytes());
        dos.writeByte(7);
        dos.writeByte(3);
        dos.writeByte(2);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        dos.writeInt(offset_x1);
        dos.writeInt(offset_y1);
        properties.setProperty("riu", url);
        properties.write(dos);
    }

    public static void write(float lt, float ln, int w, int h, byte[] bytes, Color[] colorTable, int trans, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RA>".getBytes());
        dos.writeByte(7);
        dos.writeByte(1);
        dos.writeByte(1);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeInt(bytes.length);
        dos.write(bytes, 0, bytes.length);
        dos.writeInt(colorTable.length);
        for (int i = 0; i < colorTable.length; ++i) {
            dos.writeInt(colorTable[i].getRGB());
        }
        dos.writeInt(trans);
        properties.write(dos);
    }

    public static void write(int x1, int y1, int w, int h, byte[] bytes, Color[] colorTable, int trans, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RA>".getBytes());
        dos.writeByte(7);
        dos.writeByte(2);
        dos.writeByte(1);
        dos.writeInt(x1);
        dos.writeInt(y1);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeInt(bytes.length);
        dos.write(bytes, 0, bytes.length);
        dos.writeInt(colorTable.length);
        for (int i = 0; i < colorTable.length; ++i) {
            dos.writeInt(colorTable[i].getRGB());
        }
        dos.writeInt(trans);
        properties.write(dos);
    }

    public static void write(float lt, float ln, int offset_x1, int offset_y1, int w, int h, byte[] bytes, Color[] colorTable, int trans, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RA>".getBytes());
        dos.writeByte(7);
        dos.writeByte(3);
        dos.writeByte(1);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        dos.writeInt(offset_x1);
        dos.writeInt(offset_y1);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeInt(bytes.length);
        dos.write(bytes, 0, bytes.length);
        dos.writeInt(colorTable.length);
        for (int i = 0; i < colorTable.length; ++i) {
            dos.writeInt(colorTable[i].getRGB());
        }
        dos.writeInt(trans);
        properties.write(dos);
    }

    public static void write(OMRaster raster, Link link, LinkProperties props) throws IOException {
        switch (raster.getRenderType()) {
            default: 
        }
        Debug.error("LinkRaster.write: raster not implemented.");
    }

    public static OMRaster read(DataInputStream dis) throws IOException {
        return LinkRaster.read(dis, null);
    }

    public static OMRaster read(DataInputStream dis, LinkProperties propertiesBuffer) throws IOException {
        String url;
        OMRasterObject raster = null;
        float lat = 0.0f;
        float lon = 0.0f;
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        Debug.message("link", "LinkRaster | Reading Raster graphic");
        byte renderType = dis.readByte();
        byte colorModel = dis.readByte();
        if (Debug.debugging("link")) {
            System.out.println("LinkRaster | Rendertype = " + renderType + ", colorModel = " + colorModel);
        }
        switch (renderType) {
            case 3: {
                lat = dis.readFloat();
                lon = dis.readFloat();
            }
            case 2: {
                x = dis.readInt();
                y = dis.readInt();
                break;
            }
            default: {
                lat = dis.readFloat();
                lon = dis.readFloat();
                if (!Debug.debugging("link")) break;
                System.out.println("LinkRaster | Location: lat = " + lat + ", lon = " + lon);
            }
        }
        if (colorModel != 2) {
            w = dis.readInt();
            h = dis.readInt();
            if (Debug.debugging("link")) {
                System.out.println("LinkRaster | Size: width = " + w + ", height = " + h);
            }
            if (colorModel == 1) {
                int length = dis.readInt();
                byte[] bytes = new byte[length];
                if (Debug.debugging("link")) {
                    System.out.println("LinkRaster | Reading " + length + " bytes.");
                }
                dis.readFully(bytes);
                if (Debug.debugging("link")) {
                    System.out.println("LinkRaster | read bytes.");
                }
                length = dis.readInt();
                if (Debug.debugging("link")) {
                    System.out.println("LinkRaster | " + length + " Colors.");
                }
                Color[] colorTable = new Color[length];
                for (int i = 0; i < length; ++i) {
                    int colorvalue = dis.readInt();
                    colorTable[i] = ColorFactory.createColor(colorvalue, true);
                    if (!Debug.debugging("linkdetail")) continue;
                    System.out.println("LinkRaster | Color " + i + " =  " + colorTable[i] + " from " + Integer.toHexString(colorvalue));
                }
                int trans = dis.readInt();
                if (Debug.debugging("link")) {
                    System.out.println("LinkRaster | Transparency =  " + trans);
                }
                switch (renderType) {
                    case 3: {
                        raster = new OMRaster(lat, lon, x, y, w, h, bytes, colorTable, trans);
                        break;
                    }
                    case 2: {
                        raster = new OMRaster(x, y, w, h, bytes, colorTable, trans);
                        break;
                    }
                    default: {
                        raster = new OMRaster(lat, lon, w, h, bytes, colorTable, trans);
                        break;
                    }
                }
            } else {
                int length = dis.readInt();
                int[] pix = new int[length];
                if (Debug.debugging("link")) {
                    System.out.println("LinkRaster | Reading " + length + " pixels.");
                }
                for (int i = 0; i < length; ++i) {
                    pix[i] = dis.readInt();
                }
                switch (renderType) {
                    case 3: {
                        raster = new OMRaster(lat, lon, x, y, w, h, pix);
                        break;
                    }
                    case 2: {
                        raster = new OMRaster(x, y, w, h, pix);
                        break;
                    }
                    default: {
                        raster = new OMRaster(lat, lon, w, h, pix);
                    }
                }
            }
        }
        LinkProperties properties = (LinkProperties)LinkProperties.read(dis, propertiesBuffer).clone();
        if (colorModel == 2 && (url = properties.getProperty("riu")) != null) {
            switch (renderType) {
                case 3: {
                    raster = new OMRaster(lat, lon, x, y, new ImageIcon(url));
                    break;
                }
                case 2: {
                    raster = new OMRaster(x, y, new ImageIcon(url));
                    break;
                }
                default: {
                    raster = new OMRaster(lat, lon, new ImageIcon(url));
                }
            }
        }
        if (raster != null) {
            properties.setProperties(raster);
            raster.setRotationAngle(ProjMath.degToRad(PropUtils.floatFromProperties(properties, "rot", 0.0f)));
        }
        return raster;
    }
}

