/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.link.ClientLink;
import com.bbn.openmap.layer.link.GraphicUpdate;
import com.bbn.openmap.layer.link.LinkActionConstants;
import com.bbn.openmap.layer.link.LinkActionList;
import com.bbn.openmap.layer.link.LinkActionRequest;
import com.bbn.openmap.layer.link.LinkBoundingPoly;
import com.bbn.openmap.layer.link.LinkGraphic;
import com.bbn.openmap.layer.link.LinkGraphicList;
import com.bbn.openmap.layer.link.LinkListener;
import com.bbn.openmap.layer.link.LinkManager;
import com.bbn.openmap.layer.link.LinkMapRequest;
import com.bbn.openmap.layer.link.LinkOMGraphicList;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.layer.link.LinkUtil;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class LinkLayer
extends OMGraphicHandlerLayer
implements MapMouseListener,
LinkPropertiesConstants,
LinkActionConstants,
DrawingToolRequestor {
    protected LinkListener listener;
    protected int gestureDescriptor = 0;
    protected int port;
    protected String host;
    protected LinkProperties args;
    protected LinkManager linkManager = null;
    protected boolean quiet = false;
    protected OMGridGenerator currentGenerator = null;
    public static final String PortProperty = "port";
    public static final String HostProperty = "host";
    public static final String ArgsProperty = "propertiesURL";
    public static final String ServerLocationProperty = "isl";
    public static final String QuietProperty = "quiet";
    public static final String GridGeneratorProperty = "gridGenerator";
    public static final String DistanceLimitProperty = "distanceLimit";
    public static final int DEFAULT_DISTANCE_LIMIT = 4;
    protected int distanceLimit = 4;
    public static final String ExitOnCommandProperty = "exitOnCommand";
    static /* synthetic */ Class class$com$bbn$openmap$proj$Mercator;

    public LinkLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this){

            public void workerComplete(OMGraphicList list) {
            }
        });
    }

    public LinkLayer(String host, int port, String propertiesURL) {
        this();
        this.host = host;
        this.port = port;
        this.linkManager = new LinkManager(host, port);
        this.args = new LinkProperties();
        if (propertiesURL != null) {
            try {
                URL propertiesFile = new URL(propertiesURL);
                this.args.load(propertiesFile.openStream());
            }
            catch (MalformedURLException mue) {
                System.err.println("LinkLayer:  Properties URL isn't valid: " + propertiesURL);
                System.err.println(mue);
            }
            catch (IOException ioe) {
                System.err.println("LinkLayer: IOException reading properties file:");
                System.err.println(ioe);
            }
        }
    }

    public synchronized void setGraphicList(LinkOMGraphicList aList) {
        super.setList(aList);
    }

    public synchronized LinkOMGraphicList getGraphicList() {
        return (LinkOMGraphicList)this.getList();
    }

    public void removed(Container cont) {
        this.linkManager.resetLink();
    }

    public synchronized void setGestureDescriptor(int descriptor) {
        this.gestureDescriptor = descriptor;
    }

    public synchronized int getGestureDescriptor() {
        return this.gestureDescriptor;
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String quietString = properties.getProperty(realPrefix + QuietProperty);
        if (quietString != null && quietString.intern() == "true") {
            this.quiet = true;
        }
        this.host = properties.getProperty(realPrefix + HostProperty);
        this.port = PropUtils.intFromProperties(properties, realPrefix + PortProperty, 3031);
        this.linkManager = new LinkManager(this.host, this.port);
        this.linkManager.setObeyCommandToExit(PropUtils.booleanFromProperties(properties, realPrefix + ExitOnCommandProperty, false));
        String propertiesURL = properties.getProperty(realPrefix + ArgsProperty);
        this.args = new LinkProperties();
        if (propertiesURL != null) {
            try {
                URL propertiesFile = new URL(propertiesURL);
                this.args.load(propertiesFile.openStream());
                this.checkAndReplaceOldPropertyNames(this.args);
            }
            catch (MalformedURLException mue) {
                System.err.println("LinkLayer:  Properties URL isn't valid: " + realPrefix + ArgsProperty);
                System.err.println(mue);
            }
            catch (IOException ioe) {
                System.err.println("LinkLayer: IOException reading properties file:");
                System.err.println(ioe);
            }
        }
        this.currentGenerator = (OMGridGenerator)PropUtils.objectFromProperties(properties, realPrefix + GridGeneratorProperty);
        if (this.currentGenerator == null) {
            Debug.message("linkdetail", this.getName() + "|LinkLayer: no generator for grid objects.");
        }
        this.distanceLimit = PropUtils.intFromProperties(properties, realPrefix + DistanceLimitProperty, this.distanceLimit);
    }

    public void checkAndReplaceOldPropertyNames(LinkProperties props) {
        this.checkAndReplaceOldPropertyName(props, "lineColor", "lc");
        this.checkAndReplaceOldPropertyName(props, "lineStyle", "ls");
        this.checkAndReplaceOldPropertyName(props, "highlightColor", "hc");
        this.checkAndReplaceOldPropertyName(props, "fillColor", "fc");
        this.checkAndReplaceOldPropertyName(props, "fillPattern", "fp");
        this.checkAndReplaceOldPropertyName(props, "lineWidth", "lw");
        this.checkAndReplaceOldPropertyName(props, "textString", "ts");
        this.checkAndReplaceOldPropertyName(props, "textFont", "tf");
    }

    public void checkAndReplaceOldPropertyName(LinkProperties props, String oldPropertyName, String newPropertyName) {
        String property = props.getProperty(oldPropertyName);
        if (property != null) {
            props.remove(oldPropertyName);
            props.put(newPropertyName, property);
        }
    }

    protected void setListener(LinkListener ll) {
        this.listener = ll;
    }

    protected LinkListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OMGraphicList prepare() {
        OMGraphicList currentList = this.getList();
        if (this.listener == null) {
            this.listener = new LinkListener(this.linkManager, this, this.currentGenerator);
        }
        if (this.listener != null && !this.listener.isListening()) {
            this.listener.startUp();
        }
        if (Debug.debugging("link")) {
            Debug.output(this.getName() + "|LinkLayer.prepare(): Listener " + (this.listener == null ? "is null," : "is OK,") + " listening (" + (this.listener == null ? "nope" : "" + this.listener.isListening()) + ")");
        }
        if (this.isCancelled()) {
            Debug.message("link", this.getName() + "|LinkLayer.prepare(): aborted.");
            return currentList;
        }
        Projection projection = this.getProjection();
        if (projection == null) {
            Debug.error("Link Layer needs to be added to the MapBean before it can get graphics!");
            return currentList;
        }
        if (currentList != null) {
            currentList.generate(projection);
        }
        Debug.message("basic", this.getName() + "|LinkLayer.prepare(): doing it");
        if (Debug.debugging("link")) {
            System.out.println(this.getName() + "|LinkLayer.prepare(): " + "calling getRectangle " + " with projection: " + projection + " ul = " + projection.getUpperLeft() + " lr = " + projection.getLowerRight());
        }
        try {
            ClientLink l = this.linkManager.getLink(true);
            if (l == null) {
                System.err.println("LinkLayer: unable to get link in prepare().");
                return currentList;
            }
            ClientLink clientLink = l;
            synchronized (clientLink) {
                this.sendMapRequest(l, projection);
            }
            this.linkManager.finLink();
        }
        catch (UnknownHostException uhe) {
            System.err.println("LinkLayer: unknown host!");
        }
        catch (IOException ioe) {
            System.err.println("LinkLayer: IOException contacting server for map request!");
            System.err.println(ioe);
            this.linkManager.resetLink();
            if (!this.quiet) {
                this.fireRequestMessage("Communication error between " + this.getName() + " layer\nand Link Server: Host: " + this.host + ", Port: " + this.port);
            }
            System.err.println("LinkLayer: Communication error between " + this.getName() + " layer\nand Link Server: Host: " + this.host + ", Port: " + this.port);
        }
        return currentList;
    }

    protected void sendMapRequest(ClientLink link, Projection proj) throws IOException {
        LatLonPoint ul = proj.getUpperLeft();
        LatLonPoint lr = proj.getLowerRight();
        float ulLat = ul.getLatitude();
        float ulLon = ul.getLongitude();
        float lrLat = lr.getLatitude();
        float lrLon = lr.getLongitude();
        LinkBoundingPoly[] boundingPolys = null;
        if (ProjMath.isCrossingDateline(ulLon, lrLon, proj.getScale())) {
            Debug.message("link", "Dateline is on screen");
            float ymin = Math.min(ulLat, lrLat);
            float ymax = Math.max(ulLat, lrLat);
            boundingPolys = new LinkBoundingPoly[]{new LinkBoundingPoly(ulLon, ymin, 180.0f, ymax), new LinkBoundingPoly(-180.0f, ymin, lrLon, ymax)};
        } else {
            boundingPolys = new LinkBoundingPoly[]{new LinkBoundingPoly(ulLon, lrLat, lrLon, ulLat)};
        }
        LinkMapRequest.write(proj.getCenter().getLatitude(), proj.getCenter().getLongitude(), proj.getScale(), proj.getHeight(), proj.getWidth(), boundingPolys, this.args, link);
    }

    public void handleLinkGraphicList(LinkGraphicList lgl) {
        Debug.message("link", "LinkLayer.handleLinkGraphicList()");
        if (lgl != null) {
            this.handleMessages(lgl.getProperties());
            LinkOMGraphicList lomgl = lgl.getGraphics();
            this.setGraphicList(lomgl);
            Projection proj = this.getProjection();
            if (lomgl.getNeedToRegenerate(proj)) {
                lomgl.generate(proj);
            }
            this.repaint();
        }
    }

    public void handleLinkActionList(LinkActionList lal) {
        Debug.message("link", "LinkLayer.handleLinkActionList()");
        if (lal == null) {
            return;
        }
        this.handleMessages(lal.getProperties());
        Vector updates = lal.getGraphicUpdates();
        Enumeration items = updates.elements();
        boolean needRepaint = false;
        LinkOMGraphicList graphics = this.getGraphicList();
        Projection proj = this.getProjection();
        if (graphics == null) {
            Debug.message("link", "LinkLayer.handleLinkActionList: null LinkOMGraphicList, making new one...");
            graphics = new LinkOMGraphicList();
            this.setGraphicList(graphics);
        }
        while (items.hasMoreElements()) {
            needRepaint = true;
            GraphicUpdate gu = (GraphicUpdate)items.nextElement();
            if (LinkUtil.isMask(gu.action, 32)) {
                Debug.message("link", "LinkLayer.handleLinkActionList: deselecting all graphics");
                graphics.deselectAll();
            }
            if (gu == null) {
                Debug.message("link", "LinkLayer.handleLinkActionList: null GraphicUpdate, skipping...");
                continue;
            }
            OMGraphic gug = gu.graphic;
            OMGraphic reactionGraphic = null;
            int reactionGraphicIndex = -1;
            if (LinkUtil.isMask(gu.action, 64)) {
                if (Debug.debugging("link")) {
                    Debug.output("LinkLayer.handleLinkActionList: adding graphic, id:" + gu.id);
                }
                if (gug != null) {
                    gug.generate(proj);
                    graphics.add(gug);
                    reactionGraphic = gug;
                } else {
                    Debug.message("link", "LinkLayer.handleLinkActionList: trying to add null OMGraphic, id: " + gu.id);
                }
            } else if (gu.id != null) {
                reactionGraphicIndex = graphics.getOMGraphicIndexWithId(gu.id);
                if (reactionGraphicIndex == -1) {
                    if (LinkUtil.isMask(gu.action, 64)) {
                        if (Debug.debugging("link")) {
                            Debug.output("LinkLayer.handleLinkActionList: adding graphic " + gu.id);
                        }
                        if (gug != null) {
                            gug.generate(proj);
                            graphics.add(gug);
                            reactionGraphic = gug;
                        } else {
                            Debug.message("link", "LinkLayer.handleLinkActionList: trying to add null OMGraphic, id: " + gu.id);
                        }
                    } else {
                        gu.action = 0;
                        Debug.error("LinkLayer.handleLinkActionList: Gesture Response on an unknown graphic.");
                    }
                } else if (LinkUtil.isMask(gu.action, 128)) {
                    if (gug != null) {
                        gug.generate(proj);
                        reactionGraphic = gug;
                    } else {
                        Debug.message("link", "LinkLayer.handleLinkActionList: trying to update null OMGraphic, id: " + gu.id);
                    }
                } else {
                    reactionGraphic = graphics.getOMGraphicWithId(gu.id);
                }
            } else {
                Debug.error("LinkLayer.handleLinkActionList:  null ID for graphic");
            }
            if (LinkUtil.isMask(gu.action, 4)) {
                Debug.message("link", "LinkLayer: deleting graphic");
                graphics.removeOMGraphicAt(reactionGraphicIndex);
                continue;
            }
            if (LinkUtil.isMask(gu.action, 128)) {
                Debug.message("link", "LinkLayer: updating graphic");
                graphics.setOMGraphicAt(reactionGraphic, reactionGraphicIndex);
            }
            if (LinkUtil.isMask(gu.action, 8)) {
                Debug.message("link", "LinkLayer: selecting graphic");
                reactionGraphic.select();
            } else if (LinkUtil.isMask(gu.action, 16)) {
                Debug.message("link", "LinkLayer: deselecting graphic");
                reactionGraphic.deselect();
            }
            if (LinkUtil.isMask(gu.action, 1)) {
                Debug.message("link", "LinkLayer: raising graphic");
                graphics.moveIndexedToTop(reactionGraphicIndex);
                continue;
            }
            if (!LinkUtil.isMask(gu.action, 2)) continue;
            Debug.message("link", "LinkLayer: lowering graphic");
            graphics.moveIndexedToBottom(reactionGraphicIndex);
        }
        if (lal.getNeedMapUpdate()) {
            this.updateMap(lal.getMapProperties());
            lal.setNeedMapUpdate(false);
            needRepaint = false;
        }
        if (needRepaint) {
            this.repaint();
        }
    }

    public void handleLinkActionRequest(LinkActionRequest lar) {
        Debug.message("link", "LinkLayer.handleLinkActionRequest()");
        if (lar != null) {
            this.setGestureDescriptor(lar.getDescriptor());
        }
    }

    public void handleMessages(LinkProperties props) {
        String value = props.getProperty("info");
        if (value != null) {
            this.fireRequestInfoLine(value);
        }
        if ((value = props.getProperty("url")) != null) {
            this.fireRequestURL(value);
        } else {
            value = props.getProperty("html");
            if (value != null) {
                this.fireRequestBrowserContent(value);
            }
        }
        value = props.getProperty("mess");
        if (value != null) {
            this.fireRequestMessage(value);
        }
    }

    public synchronized MapMouseListener getMapMouseListener() {
        return this;
    }

    public String[] getMouseModeServiceList() {
        String[] services = new String[]{SelectMouseMode.modeID};
        return services;
    }

    public boolean mousePressed(MouseEvent e) {
        if (LinkUtil.isMask(this.getGestureDescriptor(), 2)) {
            return this.handleGesture(2, e);
        }
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        if (LinkUtil.isMask(this.getGestureDescriptor(), 4)) {
            return this.handleGesture(4, e);
        }
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        if (LinkUtil.isMask(this.getGestureDescriptor(), 1)) {
            return this.handleGesture(1, e);
        }
        return false;
    }

    public void mouseEntered(MouseEvent e) {
        if (LinkUtil.isMask(this.getGestureDescriptor(), 16)) {
            this.handleGesture(16, e);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (LinkUtil.isMask(this.getGestureDescriptor(), 32)) {
            this.handleGesture(32, e);
        }
    }

    public boolean mouseDragged(MouseEvent e) {
        if (LinkUtil.isMask(this.getGestureDescriptor(), 64)) {
            return this.handleGesture(64, e);
        }
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        if (LinkUtil.isMask(this.getGestureDescriptor(), 8)) {
            return this.handleGesture(8, e);
        }
        return false;
    }

    public void mouseMoved() {
        if (LinkUtil.isMask(this.getGestureDescriptor(), 8)) {
            this.handleGesture(8, null);
        }
    }

    protected boolean graphicGestureReaction(OMGraphic graphic, int descriptor, MouseEvent e) {
        String info;
        LinkProperties props = (LinkProperties)graphic.getAppObject();
        boolean mc = LinkUtil.isMask(descriptor, 1);
        boolean mr = LinkUtil.isMask(descriptor, 4);
        boolean mm = LinkUtil.isMask(descriptor, 8);
        boolean si = LinkUtil.isMask(this.getGestureDescriptor(), 2048);
        boolean ret = true;
        if (mr || mc) {
            String url = props.getProperty("url");
            if (url != null) {
                if (Debug.debugging("link")) {
                    System.out.println("LinkLayer:graphicGestureReaction: displaying url: " + url);
                }
                this.fireRequestURL(url);
                ret = si;
            } else {
                String html = props.getProperty("html");
                if (html != null) {
                    this.fireRequestBrowserContent(html);
                    ret = si;
                }
            }
            url = props.getProperty("mess");
            if (url != null) {
                this.fireRequestMessage(url);
                ret = si;
            }
        }
        if ((mr || mm || mc) && (info = props.getProperty("info")) != null) {
            if (Debug.debugging("link")) {
                System.out.println("LinkLayer:graphicGestureReaction: displaying info line: " + info);
            }
            this.fireRequestInfoLine(info);
            ret = si;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleGesture(int descriptor, MouseEvent e) {
        Debug.message("link", "LinkLayer: handleGesture:");
        try {
            LinkOMGraphicList graphics = this.getGraphicList();
            OMGraphic gesGraphic = null;
            if (graphics == null) {
                Debug.message("link", "LinkLayer: null graphics list.");
            } else {
                if (e == null) {
                    graphics.deselectAll();
                    return false;
                }
                gesGraphic = graphics.selectClosest(e.getX(), e.getY(), this.distanceLimit);
            }
            String id = null;
            if (gesGraphic != null) {
                boolean tellServer = this.graphicGestureReaction(gesGraphic, descriptor, e);
                if (!tellServer) {
                    this.repaint();
                    return true;
                }
                descriptor = LinkUtil.setMask(descriptor, 512);
                id = ((LinkProperties)gesGraphic.getAppObject()).getProperty("gid");
            } else {
                this.fireRequestInfoLine("");
            }
            if (!LinkUtil.isMask(this.getGestureDescriptor(), 2048)) {
                return false;
            }
            LatLonPoint llpoint = this.getProjection().inverse(e.getX(), e.getY());
            ClientLink l = this.linkManager.getLink(false);
            if (l == null) {
                Debug.message("link", "LinkLayer: unable to get link in handleGesture().");
                return false;
            }
            ClientLink clientLink = l;
            synchronized (clientLink) {
                if (id != null) {
                    this.args.setProperty("gid", id);
                } else {
                    this.args.remove("gid");
                }
                LinkActionRequest.write(descriptor, e, llpoint.getLatitude(), llpoint.getLongitude(), this.args, l);
            }
            this.linkManager.finLink();
            return false;
        }
        catch (IOException ioe) {
            System.err.println("LinkLayer: IOException contacting server during gesture handling!");
            System.err.println(ioe);
            this.linkManager.resetLink();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawingComplete(OMGraphic omg, OMAction action) {
        String id = null;
        Object obj = omg.getAppObject();
        LinkProperties lp = null;
        if (obj != null && obj instanceof LinkProperties) {
            lp = (LinkProperties)obj;
            id = lp.getProperty("gid");
        }
        if (id == null) {
            action.setMask(64);
        }
        try {
            ClientLink l = this.linkManager.getLink(true);
            if (l == null) {
                System.err.println("LinkLayer.drawingComplete: unable to get link.");
                return;
            }
            ClientLink clientLink = l;
            synchronized (clientLink) {
                LinkActionList lal = new LinkActionList(l, new LinkProperties());
                if (action.isMask(64) || action.isMask(128)) {
                    lal.writeGraphicGestureHeader(action.getValue());
                    LinkGraphic.write(omg, l);
                } else {
                    lal.modifyGraphic(action.getValue(), lp);
                }
                lal.end("\r");
            }
            this.linkManager.finLink();
        }
        catch (UnknownHostException uhe) {
            Debug.error("LinkLayer: unknown host!");
            return;
        }
        catch (IOException ioe) {
            Debug.error("LinkLayer: Communication error between " + this.getName() + " layer\nand Link Server: Host: " + this.host + ", Port: " + this.port + "LinkLayer: IOException contacting server!\n" + ioe.getMessage());
            this.linkManager.resetLink();
            if (!this.quiet) {
                this.fireRequestMessage("Communication error between " + this.getName() + " layer\nand Link Server: Host: " + this.host + ", Port: " + this.port);
            }
            return;
        }
    }

    public void setDistanceLimit(int limit) {
        this.distanceLimit = limit < 0 ? 0 : limit;
    }

    public int getDistanceLimit() {
        return this.distanceLimit;
    }

    public void updateMap(LinkProperties props) {
        MapHandler mapHandler;
        Proj projection = (Proj)this.getProjection();
        float latitude = PropUtils.floatFromProperties(props, "lat", projection.getCenter().getLatitude());
        float longitude = PropUtils.floatFromProperties(props, "lon", projection.getCenter().getLongitude());
        float scale = PropUtils.floatFromProperties(props, "s", projection.getScale());
        int width = PropUtils.intFromProperties(props, "w", projection.getWidth());
        int height = PropUtils.intFromProperties(props, "h", projection.getHeight());
        String projType = props.getProperty("p");
        float latmin = PropUtils.floatFromProperties(props, "latmin", -1000.0f);
        float latmax = PropUtils.floatFromProperties(props, "latmax", -1000.0f);
        float lonmin = PropUtils.floatFromProperties(props, "lonmin", -1000.0f);
        float lonmax = PropUtils.floatFromProperties(props, "lonmax", -1000.0f);
        if (latmin >= -90.0f && latmax <= 90.0f && lonmin >= -180.0f && lonmax <= 180.0f && latmin <= latmax && lonmin <= lonmax) {
            float dist = 0.5f * GreatCircle.spherical_distance(ProjMath.degToRad(latmax), ProjMath.degToRad(lonmin), ProjMath.degToRad(latmin), ProjMath.degToRad(lonmax));
            float azimuth = GreatCircle.spherical_azimuth(ProjMath.degToRad(latmax), ProjMath.degToRad(lonmin), ProjMath.degToRad(latmin), ProjMath.degToRad(lonmax));
            LatLonPoint center = GreatCircle.spherical_between(ProjMath.degToRad(latmax), ProjMath.degToRad(lonmin), dist, azimuth);
            latitude = center.getLatitude();
            longitude = center.getLongitude();
        }
        if ((mapHandler = (MapHandler)this.getBeanContext()) == null) {
            Debug.message("link", "Warning...mapHandler = null");
        } else {
            MapBean mapBean = (MapBean)mapHandler.get("com.bbn.openmap.MapBean");
            if (mapBean == null) {
                Debug.message("link", "Warning...mapBean = null");
            } else {
                if (projType != null) {
                    Class projClass = ProjectionFactory.getProjClassForName(projType);
                    if (projClass == null) {
                        projClass = class$com$bbn$openmap$proj$Mercator == null ? (class$com$bbn$openmap$proj$Mercator = LinkLayer.class$("com.bbn.openmap.proj.Mercator")) : class$com$bbn$openmap$proj$Mercator;
                    }
                    projection = (Proj)ProjectionFactory.makeProjection(projClass, latitude, longitude, scale, width, height);
                } else {
                    projection = (Proj)mapBean.getProjection();
                    projection.setCenter(latitude, longitude);
                    projection.setScale(scale);
                    projection.setWidth(width);
                    projection.setHeight(height);
                }
                if (latmin >= -90.0f && latmax <= 90.0f && lonmin >= -180.0f && lonmax <= 180.0f && latmin <= latmax && lonmin <= lonmax) {
                    LatLonPoint upperLeft = new LatLonPoint(latmax, lonmin);
                    LatLonPoint lowerRight = new LatLonPoint(latmin, lonmax);
                    scale = ProjMath.getScale(upperLeft, lowerRight, (Projection)projection);
                    projection.setScale(scale);
                    LatLonPoint ul = projection.getUpperLeft();
                    LatLonPoint lr = projection.getLowerRight();
                    float factor1 = (latmax - latmin) / (ul.getLatitude() - lr.getLatitude());
                    float factor2 = (lonmax - lonmin) / (lr.getLongitude() - ul.getLongitude());
                    if (factor2 > factor1) {
                        factor1 = factor2;
                    }
                    if ((double)factor1 > 1.0) {
                        projection.setScale(scale *= factor1);
                    }
                }
                mapBean.setProjection(projection);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

