/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.Layer;
import com.bbn.openmap.layer.link.LinkActionList;
import com.bbn.openmap.layer.link.LinkActionRequest;
import com.bbn.openmap.layer.link.LinkConstants;
import com.bbn.openmap.layer.link.LinkGUIList;
import com.bbn.openmap.layer.link.LinkGUIRequest;
import com.bbn.openmap.layer.link.LinkGraphicList;
import com.bbn.openmap.layer.link.LinkMapRequest;
import com.bbn.openmap.layer.link.LinkOMGraphicList;
import com.bbn.openmap.layer.link.LinkOutputStream;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class Link
implements LinkConstants {
    public static final int MAX_HEADER_LENGTH = 80;
    protected LinkOutputStream dos = null;
    protected DataInputStream dis = null;
    protected char[] charArray = new char[80];
    protected boolean closeLink = false;
    protected LinkMapRequest mapRequest = null;
    protected LinkGraphicList graphicList = null;
    protected LinkActionRequest actionRequest = null;
    protected LinkActionList actionList = null;
    protected LinkGUIRequest guiRequest = null;
    protected LinkGUIList guiList = null;
    protected Socket socket = null;
    protected boolean locked = false;
    protected boolean obeyCommandToExit = false;

    public Link(Socket socket) throws IOException {
        this.socket = socket;
        InputStream is = socket.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        this.dis = new DataInputStream(bis);
        OutputStream os = socket.getOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(os);
        this.dos = new LinkOutputStream(bos);
    }

    public void cleanUp() {
        try {
            this.dis.close();
            this.dos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dis = null;
        this.dos = null;
    }

    public void start(String messageHeader) throws IOException {
        this.dos.write(messageHeader.getBytes());
    }

    public void end(String endType) throws IOException {
        this.dos.write(endType.getBytes());
        if (endType == "\r") {
            this.dos.flush();
        }
    }

    public void readAndParse() throws IOException {
        this.readAndParse(null, null);
    }

    public void readAndParse(Projection proj, OMGridGenerator generator) throws IOException {
        this.readAndParse(proj, generator, null);
    }

    public void readAndParse(Projection proj, OMGridGenerator generator, Layer layer) throws IOException {
        LinkOMGraphicList graphics = new LinkOMGraphicList();
        this.graphicList = null;
        this.mapRequest = null;
        this.actionRequest = null;
        this.actionList = null;
        this.guiRequest = null;
        this.guiList = null;
        this.closeLink = false;
        String delimiter = null;
        if (Debug.debugging("link")) {
            System.out.println("Link|readAndParse: listening to link:");
            System.out.println((proj == null ? " without " : " with ") + "a projection and");
            System.out.println((layer == null ? " without " : " with ") + "a layer");
        }
        do {
            delimiter = this.readDelimiter(true);
            if (Debug.debugging("link")) {
                System.out.println("Link:reading section: " + delimiter);
            }
            if (delimiter == "<G>") {
                this.graphicList = layer != null ? new LinkGraphicList(this, graphics, layer.getProjection(), generator) : new LinkGraphicList(this, graphics, proj, generator);
                delimiter = this.graphicList.getLinkStatus();
                continue;
            }
            if (delimiter == "<A>") {
                this.actionList = new LinkActionList(this, layer, proj, generator);
                delimiter = this.actionList.getLinkStatus();
                continue;
            }
            if (delimiter == "<GUI>") {
                this.guiList = new LinkGUIList(this);
                delimiter = this.guiList.getLinkStatus();
                continue;
            }
            if (delimiter == "<Q>") {
                this.closeLink = true;
                continue;
            }
            if (delimiter == "<SDWN>") {
                Debug.message("link", "Link.received command to exit");
                if (!this.obeyCommandToExit) continue;
                System.exit(0);
                continue;
            }
            if (delimiter == "<?>") {
                delimiter = this.readDelimiter(true);
                continue;
            }
            if (delimiter == "<MR>") {
                this.mapRequest = new LinkMapRequest(this);
                delimiter = this.mapRequest.getLinkStatus();
                continue;
            }
            if (delimiter == "<AR>") {
                this.actionRequest = new LinkActionRequest(this);
                delimiter = this.actionRequest.getLinkStatus();
                continue;
            }
            if (delimiter == "<GUIR>") {
                this.guiRequest = new LinkGUIRequest(this);
                delimiter = this.guiRequest.getLinkStatus();
                continue;
            }
            if (delimiter != "<PRQ>") continue;
            this.start("<PR>");
            this.end("\r");
            delimiter = this.readDelimiter(false);
        } while (delimiter != "\r");
    }

    public void setObeyCommandToExit(boolean value) {
        this.obeyCommandToExit = value;
    }

    public boolean getAcceptCommandToExit() {
        return this.obeyCommandToExit;
    }

    public LinkMapRequest getMapRequest() {
        return this.mapRequest;
    }

    public LinkGraphicList getGraphicList() {
        return this.graphicList;
    }

    public LinkActionRequest getActionRequest() {
        return this.actionRequest;
    }

    public LinkActionList getActionList() {
        return this.actionList;
    }

    public LinkGUIRequest getGUIRequest() {
        return this.guiRequest;
    }

    public LinkGUIList getGUIList() {
        return this.guiList;
    }

    protected String readDelimiter(boolean returnString) throws IOException, ArrayIndexOutOfBoundsException {
        String ret = "\r";
        char END_TOTAL_CHAR = "\r".charAt(0);
        char END_SECTION_CHAR = "\n".charAt(0);
        char c = (char)this.dis.readByte();
        if (c == END_TOTAL_CHAR) {
            Debug.message("link", "Link|readDelimiter: Found END_TOTAL");
            return "\r";
        }
        if (c == END_SECTION_CHAR) {
            Debug.message("link", "Link|readDelimiter: Found END_SECTION");
            return "\n";
        }
        if (c != '<') {
            if (Debug.debugging("link")) {
                System.out.println("Link|readDelimiter: unexpected protocol data read '" + c + "'");
            }
            throw new IOException("readDelimiter: unexpected protocol data read.");
        }
        int charCount = 0;
        this.charArray[charCount++] = c;
        c = (char)this.dis.readByte();
        while (c != '>' && charCount < 79) {
            this.charArray[charCount++] = c;
            c = (char)this.dis.readByte();
        }
        if (c != '>') {
            throw new IOException("readDelimiter: header is too long.");
        }
        this.charArray[charCount++] = c;
        ret = returnString ? new String(this.charArray, 0, charCount).intern() : "";
        return ret;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public synchronized boolean setLocked(boolean set) {
        if (set) {
            if (this.locked) {
                return false;
            }
            this.locked = true;
            return true;
        }
        this.locked = set;
        return true;
    }

    public DataOutput getDOS() {
        return this.dos;
    }

    public DataInput getDIS() {
        return this.dis;
    }

    public int getBytesWritten() {
        return this.dos.size();
    }

    public int clearBytesWritten() {
        return this.dos.clearWritten();
    }
}

