/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.io;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.io.InputReader;
import com.bbn.openmap.util.Debug;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class StreamInputReader
implements InputReader {
    protected InputStream inputStream = null;
    protected long inputStreamCount = 0L;
    protected String name = null;

    public String getName() {
        return this.name;
    }

    protected int count(int add) {
        this.inputStreamCount += (long)add;
        return add;
    }

    protected void reopen() throws IOException {
        if (this.inputStream != null) {
            Debug.message("binaryfile", "StreamInputReader: Closing inputStream");
            this.inputStream.close();
        }
        this.inputStreamCount = 0L;
    }

    public long skipBytes(long n) throws IOException {
        long count;
        long gotsofar = 0L;
        for (count = 0L; count < n; count += gotsofar) {
            gotsofar = this.inputStream.skip(n - count);
            if (gotsofar != 0L) continue;
            Debug.error("StreamInputReader can't skip " + n + " bytes as instructed");
            break;
        }
        this.count((int)count);
        return count;
    }

    public long getFilePointer() throws IOException {
        return this.inputStreamCount;
    }

    public void seek(long pos) throws IOException {
        long curPosition;
        boolean seekComments = false;
        if (Debug.debugging("binaryfileseek")) {
            seekComments = true;
        }
        if (pos >= (curPosition = this.inputStreamCount)) {
            if (seekComments) {
                Debug.output("StreamInputReader - seeking to " + pos + " from " + curPosition);
            }
            long skipped = this.skipBytes(pos - curPosition);
            if (seekComments) {
                Debug.output("   now at: " + this.inputStreamCount + ", having skipped " + skipped);
            }
        } else {
            if (seekComments) {
                Debug.output("StreamInputReader - having to start over for seek - " + pos + " from " + curPosition);
            }
            this.reopen();
            if (seekComments) {
                Debug.output("   skipping to: " + pos);
            }
            long skipped = this.skipBytes(pos);
            if (seekComments) {
                Debug.output("   now at: " + this.inputStreamCount + ", having skipped " + skipped);
            }
        }
    }

    public long length() throws IOException {
        return this.inputStreamCount + (long)this.inputStream.available();
    }

    public long available() throws IOException {
        return this.inputStream.available();
    }

    public void close() throws IOException {
        try {
            Debug.message("binaryfile", "StreamInputReader.close()");
            if (Debug.debugging("connection_problems")) {
                Thread.sleep(1000L);
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.inputStream = null;
    }

    public int read() throws IOException {
        this.count(1);
        return this.inputStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int gotsofar;
        int read;
        for (gotsofar = 0; gotsofar < len; gotsofar += read) {
            read = this.inputStream.read(b, off + gotsofar, len - gotsofar);
            if (read != -1) continue;
            if (gotsofar > 0) {
                return gotsofar;
            }
            return read;
        }
        this.count(gotsofar);
        return gotsofar;
    }

    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b, 0, b.length);
    }

    public byte[] readBytes(int howmany, boolean allowless) throws EOFException, FormatException {
        byte[] foo = new byte[howmany];
        int err = 0;
        try {
            for (int gotsofar = 0; gotsofar < howmany; gotsofar += err) {
                err = this.inputStream.read(foo, gotsofar, howmany - gotsofar);
                if (err != -1) continue;
                if (allowless) {
                    byte[] retval = new byte[gotsofar];
                    System.arraycopy(foo, 0, retval, 0, gotsofar);
                    this.count(gotsofar);
                    return retval;
                }
                if (gotsofar > 0) {
                    throw new FormatException("StreamInputReader: EOF while reading data");
                }
                throw new EOFException();
            }
        }
        catch (IOException i) {
            throw new FormatException("StreamInputReader: readBytes IOException: " + i.getMessage());
        }
        this.count(howmany);
        return foo;
    }
}

