/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.time;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.gui.time.RealTimeHandler;
import com.bbn.openmap.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JComboBox;

public class TimerRateComboBox
extends JComboBox
implements ActionListener,
PropertyConsumer {
    protected RealTimeHandler timeHandler;
    protected String propPrefix = null;

    public TimerRateComboBox(RealTimeHandler rth) {
        this.addActionListener(this);
        this.setTimeHandler(rth);
    }

    public void addItem(Object obj) {
        if (obj instanceof TimerRateHolder) {
            super.addItem(obj);
        } else {
            Debug.error("TimerRateComboBox: Only TimerRateHolders can be added");
        }
    }

    public void add(String string, int interval, int pace) {
        super.addItem(new TimerRateHolder(string, interval, pace));
    }

    public void setTimeHandler(RealTimeHandler rth) {
        this.timeHandler = rth;
    }

    public RealTimeHandler getTimeHandler() {
        return this.timeHandler;
    }

    public void actionPerformed(ActionEvent ae) {
        Object obj = ae.getSource();
        if (obj == this) {
            TimerRateHolder trh = (TimerRateHolder)this.getSelectedItem();
            trh.modifyTimer(this.getTimeHandler());
        }
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
    }

    public Properties getProperties(Properties props) {
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        return props;
    }

    public String getPropertyPrefix() {
        return this.propPrefix;
    }

    public void setPropertyPrefix(String prefix) {
        this.propPrefix = prefix;
    }

    public class TimerRateHolder {
        protected String title;
        protected int timerInterval;
        protected int pace;

        public TimerRateHolder(String t, int ti, int p) {
            this.title = t;
            this.timerInterval = ti;
            this.pace = p;
        }

        public void modifyTimer(RealTimeHandler rth) {
            rth.setPace(this.pace);
            rth.setUpdateInterval(this.timerInterval);
        }

        public String toString() {
            return this.title;
        }
    }
}

