/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.dock;

import com.bbn.openmap.gui.dock.DockConstraint;
import com.bbn.openmap.gui.dock.DockLayout;
import com.bbn.openmap.gui.dock.DockPanel;
import com.bbn.openmap.gui.dock.DockWrapper;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class BasicDockPanel
extends JLayeredPane
implements DockPanel {
    private static final Integer BACKGROUND_LAYER = new Integer(-100);
    private JComponent background;
    private HashMap childToConstraint = new HashMap(11);
    private HashMap childToWrapper = new HashMap(11);
    private List externalFrameWrappers = new ArrayList(0);
    private List internalFrameWrappers = new ArrayList(0);
    private DockWrapper north = new DockWrapper(this, 3);
    private DockWrapper south = new DockWrapper(this, 4);
    private DockWrapper east = new DockWrapper(this, 6);
    private DockWrapper west = new DockWrapper(this, 5);

    public BasicDockPanel() {
        this.setLayout(new DockLayout(this));
        this.setBackground(UIManager.getColor("control"));
    }

    public JComponent getBackgroundComponent() {
        return this.background;
    }

    public void setBackgroundComponent(JComponent back) {
        if (this.getBackgroundComponent() != null) {
            this.remove(this.getBackgroundComponent());
        }
        this.add((Component)back, "Center");
    }

    public void setConstraint(JComponent child, DockConstraint c) {
        this.childToConstraint.put(child, c);
    }

    public DockConstraint getConstraint(JComponent child) {
        return (DockConstraint)this.childToConstraint.get(child);
    }

    public void removeConstraint(JComponent child) {
        this.childToConstraint.remove(child);
    }

    public void setPreferredHeight(JComponent child, int i) {
        DockWrapper dw = this.getWrapper(child);
        if (dw != null) {
            dw.setPreferredHeight(i);
        }
    }

    public void setPreferredWidth(JComponent child, int i) {
        DockWrapper dw = this.getWrapper(child);
        if (dw != null) {
            dw.setPreferredWidth(i);
        }
    }

    public void setCanOcclude(JComponent child, boolean b) {
        this.getConstraint(child).setCanOcclude(b);
    }

    public void setCanTransparent(JComponent child, boolean b) {
        this.getConstraint(child).setCanTransparent(b);
        DockWrapper dw = this.getWrapper(child);
        if (dw != null) {
            dw.updateTransparency();
        }
    }

    public void setCanResize(JComponent child, boolean b) {
        this.getConstraint(child).setCanResize(b);
        DockWrapper dw = this.getWrapper(child);
        if (dw != null) {
            dw.updateResizable();
        }
    }

    public void setCanTab(JComponent child, boolean b) {
        this.getConstraint(child).setCanTab(b);
        this.dockSomewhere(child);
    }

    public void setTabName(JComponent child, String tabName) {
        this.getConstraint(child).setTabName(tabName);
        this.getWrapper(child).setTabName(child, tabName);
    }

    public void setCanExternalFrame(JComponent child, boolean b) {
        this.getConstraint(child).setCanExternalFrame(b);
        this.dockSomewhere(child);
    }

    public void setCanInternalFrame(JComponent child, boolean b) {
        this.getConstraint(child).setCanInternalFrame(b);
        this.dockSomewhere(child);
    }

    public void setCanClose(JComponent child, boolean b) {
        this.getConstraint(child).setCanClose(b);
    }

    public void setCanDockNorth(JComponent child, boolean b) {
        this.getConstraint(child).setCanDockNorth(b);
        this.dockSomewhere(child);
    }

    public void setCanDockSouth(JComponent child, boolean b) {
        this.getConstraint(child).setCanDockSouth(b);
        this.dockSomewhere(child);
    }

    public void setCanDockEast(JComponent child, boolean b) {
        this.getConstraint(child).setCanDockEast(b);
        this.dockSomewhere(child);
    }

    public void setCanDockWest(JComponent child, boolean b) {
        this.getConstraint(child).setCanDockWest(b);
        this.dockSomewhere(child);
    }

    public void dockNorth(JComponent child) {
        this.dockNorth(child, -1);
    }

    public void dockNorth(JComponent child, int idx) {
        this.dockNorth(this.getWrapper(child), idx);
    }

    protected void dockNorth(DockWrapper wrapper) {
        this.dockNorth(wrapper, -1);
    }

    protected void dockNorth(DockWrapper wrapper, int idx) {
        this.dock(this.north, wrapper, idx);
    }

    public void dockSouth(JComponent child) {
        this.dockSouth(child, -1);
    }

    public void dockSouth(JComponent child, int idx) {
        this.dockSouth(this.getWrapper(child), idx);
    }

    protected void dockSouth(DockWrapper wrapper) {
        this.dockSouth(wrapper, -1);
    }

    protected void dockSouth(DockWrapper wrapper, int idx) {
        this.dock(this.south, wrapper, idx);
    }

    public void dockEast(JComponent child) {
        this.dockEast(child, -1);
    }

    public void dockEast(JComponent child, int idx) {
        this.dockEast(this.getWrapper(child), idx);
    }

    protected void dockEast(DockWrapper wrapper) {
        this.dockEast(wrapper, -1);
    }

    protected void dockEast(DockWrapper wrapper, int idx) {
        this.dock(this.east, wrapper, idx);
    }

    public void dockWest(JComponent child) {
        this.dockWest(child, -1);
    }

    public void dockWest(JComponent child, int idx) {
        this.dockWest(this.getWrapper(child), idx);
    }

    protected void dockWest(DockWrapper wrapper) {
        this.dockWest(wrapper, -1);
    }

    protected void dockWest(DockWrapper wrapper, int idx) {
        this.dock(this.west, wrapper, idx);
    }

    public void dock(JComponent outter, JComponent inner) {
        this.dock(outter, inner, -1);
    }

    public void dock(JComponent outter, JComponent inner, int idx) {
        this.dock(this.getWrapper(outter), this.getWrapper(inner), idx);
    }

    protected void dock(DockWrapper outter, DockWrapper inner) {
        this.dock(outter, inner, -1);
    }

    protected void dock(DockWrapper outter, DockWrapper inner, int idx) {
        this.freeWrapper(inner);
        outter.dock(inner, idx);
    }

    public void internalFrame(JComponent child) {
        this.internalFrame(this.getWrapper(child));
    }

    protected void internalFrame(DockWrapper wrapper) {
        this.freeWrapper(wrapper);
        this.internalFrameWrappers.add(wrapper);
        wrapper.makeInternalFrame();
    }

    public void externalFrame(JComponent child) {
        this.externalFrame(this.getWrapper(child));
    }

    protected void externalFrame(DockWrapper wrapper) {
        this.freeWrapper(wrapper);
        this.externalFrameWrappers.add(wrapper);
        wrapper.makeExternalFrame();
    }

    public void dockSomewhere(JComponent child) {
        this.dockSomewhere(this.getWrapper(child));
    }

    protected void dockSomewhere(DockWrapper wrapper) {
        if (wrapper == null) {
            throw new RuntimeException("Can't dock null!");
        }
        if (wrapper.canDockNorth()) {
            this.dockNorth(wrapper);
            return;
        }
        if (wrapper.canDockWest()) {
            this.dockWest(wrapper);
            return;
        }
        if (wrapper.canDockSouth()) {
            this.dockSouth(wrapper);
            return;
        }
        if (wrapper.canDockEast()) {
            this.dockEast(wrapper);
            return;
        }
        if (wrapper.canInternalFrame()) {
            this.internalFrame(wrapper);
            return;
        }
        if (wrapper.canExternalFrame()) {
            this.externalFrame(wrapper);
            return;
        }
        Debug.error("DockPanel: Can't dock anywhere...");
        this.externalFrame(wrapper);
    }

    public Component add(Component comp) {
        this.add(comp, new DockConstraint());
        return comp;
    }

    public void add(Component comp, Object constraints) {
        if (comp == null) {
            throw new RuntimeException("Can't add null component to DockPanel");
        }
        if (comp instanceof DockWrapper) {
            Debug.error("DockPanel: Unexpected call to add with a DockWrapper");
            super.add(comp, constraints);
        } else if (constraints.equals("Center")) {
            this.background = (JComponent)comp;
            super.add(comp, constraints);
            this.setLayer(comp, BACKGROUND_LAYER);
        } else if (constraints instanceof DockConstraint) {
            if (comp instanceof JToolBar) {
                JToolBar t = (JToolBar)comp;
                t.setFloatable(false);
            }
            this.setConstraint((JComponent)comp, (DockConstraint)constraints);
            if (!this.alreadyAdded(comp)) {
                this.createDockWrapper((JComponent)comp);
            }
        } else {
            Debug.error("DockPanel: Unexpected constraint: " + constraints);
        }
    }

    public void remove(Component comp) {
        if (comp == null) {
            Debug.error("Trying to remove null component");
        }
        if (comp instanceof DockWrapper) {
            this.freeWrapper((DockWrapper)comp);
            this.removeWrapper((DockWrapper)comp);
        } else {
            DockWrapper w = this.getWrapper((JComponent)comp);
            if (w != null) {
                super.remove(w);
            }
            super.remove(comp);
        }
    }

    public void removeAll() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JComponent comp = (JComponent)this.getComponent(i);
            if (!(comp instanceof DockWrapper)) continue;
            this.freeWrapper((DockWrapper)comp);
            this.removeWrapper((DockWrapper)comp);
        }
        super.removeAll();
    }

    protected DockWrapper getNorth() {
        return this.north;
    }

    protected DockWrapper getSouth() {
        return this.south;
    }

    protected DockWrapper getEast() {
        return this.east;
    }

    protected DockWrapper getWest() {
        return this.west;
    }

    protected int getOverlapTolerance() {
        return 5;
    }

    protected void setWrapper(JComponent child, DockWrapper w) {
        this.childToWrapper.put(child, w);
    }

    protected DockWrapper getWrapper(JComponent child) {
        return (DockWrapper)this.childToWrapper.get(child);
    }

    protected void removeWrapper(DockWrapper wrapper) {
        Iterator iter = wrapper.getChildren().iterator();
        while (iter.hasNext()) {
            JComponent j = (JComponent)iter.next();
            this.childToWrapper.remove(j);
        }
    }

    protected void freeWrapper(DockWrapper w) {
        if (this.externalFrameWrappers.remove(w)) {
            w.freeWrapper();
            return;
        }
        if (this.internalFrameWrappers.remove(w)) {
            w.freeWrapper();
            return;
        }
        if (this.north.freeWrapper(w)) {
            return;
        }
        if (this.south.freeWrapper(w)) {
            return;
        }
        if (this.east.freeWrapper(w)) {
            return;
        }
        if (this.west.freeWrapper(w)) {
            return;
        }
    }

    List getConstraints(List children) {
        ArrayList<DockConstraint> ret = new ArrayList<DockConstraint>(children.size());
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            JComponent child = (JComponent)iter.next();
            ret.add(this.getConstraint(child));
        }
        return ret;
    }

    DockWrapper createDockWrapper(JComponent comp) {
        DockWrapper dw = new DockWrapper(this);
        this.setWrapper(comp, dw);
        dw.addChild(comp);
        this.dockSomewhere(comp);
        return dw;
    }

    void addDockWrapper(DockWrapper dw) {
        super.add((Component)dw, null);
    }

    void removeDockWrapper(DockWrapper dw) {
        super.remove(dw);
    }

    boolean alreadyAdded(Component comp) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            DockWrapper dw;
            Component c = components[i];
            if (!(c instanceof DockWrapper) || !(dw = (DockWrapper)c).getChildren().contains(comp)) continue;
            return true;
        }
        return false;
    }
}

