/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.BufferedMapBean;
import com.bbn.openmap.Environment;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.MultipleSoloMapComponentException;
import com.bbn.openmap.event.NavMouseMode2;
import com.bbn.openmap.gui.OMToolSet;
import com.bbn.openmap.gui.ToolPanel;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import javax.swing.JFrame;

public class MapWindow
extends JFrame {
    protected MapHandler mapHandler = new MapHandler();
    protected MapBean map;

    public MapWindow() {
    }

    public MapWindow(String windowTitle) {
        super(windowTitle);
        try {
            this.map = new BufferedMapBean();
            this.mapHandler.add(new MouseDelegator());
            this.mapHandler.add(new LayerHandler());
            this.mapHandler.add(this.map);
            this.getContentPane().add((Component)this.map, "Center");
        }
        catch (MultipleSoloMapComponentException multipleSoloMapComponentException) {
            // empty catch block
        }
    }

    public void addTo(Object obj) throws MultipleSoloMapComponentException {
        this.mapHandler.add(obj);
    }

    public void removeFrom(Object obj) {
        this.mapHandler.remove(obj);
    }

    public MapHandler getMapHandler() {
        return this.mapHandler;
    }

    public MapBean getMap() {
        return this.map;
    }

    public void setProjection(Projection proj) {
        this.map.setProjection(proj);
    }

    public Projection getProjection() {
        return this.map.getProjection();
    }

    public static void main(String[] argv) {
        Environment.init();
        Debug.init();
        MapBean.suppressCopyright = true;
        MapWindow mw = new MapWindow("OpenMap's MapWindow");
        mw.setSize(500, 500);
        try {
            mw.addTo(new ShapeLayer("share/data/shape/dcwpo-browse.shp"));
            mw.addTo(new NavMouseMode2());
            mw.addTo(new ToolPanel());
            mw.addTo(new OMToolSet());
        }
        catch (MultipleSoloMapComponentException multipleSoloMapComponentException) {
            // empty catch block
        }
        mw.setVisible(true);
    }
}

