/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DimensionQueryPanel
extends JPanel {
    private JTextField hfield;
    private JTextField vfield;
    private JLabel htext = new JLabel("Width: ");
    private JLabel vtext;
    private JLabel ptext1;
    private JLabel ptext2;
    public static final String HEIGHT_CMD = "DQP_HEIGHT_CMD";
    public static final String WIDTH_CMD = "DQP_WIDTH_CMD";

    public DimensionQueryPanel() {
        this(0, 0);
    }

    public DimensionQueryPanel(Dimension d) {
        this((int)d.getWidth(), (int)d.getHeight());
    }

    public DimensionQueryPanel(int width, int height) {
        this.htext.setHorizontalAlignment(4);
        this.vtext = new JLabel("Height: ");
        this.vtext.setHorizontalAlignment(4);
        this.hfield = new DimensionQueryField(Integer.toString(width), 5);
        this.hfield.setActionCommand(WIDTH_CMD);
        this.vfield = new DimensionQueryField(Integer.toString(height), 5);
        this.vfield.setActionCommand(HEIGHT_CMD);
        this.ptext1 = new JLabel(" pixels");
        this.ptext2 = new JLabel(" pixels");
        this.layoutPanel();
    }

    public void setFieldWidth(int width) {
        this.hfield.setText(Integer.toString(width));
    }

    public int getFieldWidth() {
        return Integer.parseInt(this.hfield.getText());
    }

    public void setFieldHeight(int height) {
        this.vfield.setText(Integer.toString(height));
    }

    public int getFieldHeight() {
        return Integer.parseInt(this.vfield.getText());
    }

    public void addActionListener(ActionListener al) {
        this.hfield.addActionListener(al);
        this.vfield.addActionListener(al);
    }

    public void removeActionListener(ActionListener al) {
        this.hfield.removeActionListener(al);
        this.vfield.removeActionListener(al);
    }

    public void layoutPanel() {
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gb);
        c.insets = new Insets(3, 3, 3, 3);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 13;
        gb.setConstraints(this.htext, c);
        this.add(this.htext);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        gb.setConstraints(this.hfield, c);
        this.add(this.hfield);
        c.gridx = 2;
        c.fill = 0;
        c.weightx = 0.0;
        gb.setConstraints(this.ptext1, c);
        this.add(this.ptext1);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 13;
        gb.setConstraints(this.vtext, c);
        this.add(this.vtext);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        gb.setConstraints(this.vfield, c);
        this.add(this.vfield);
        c.gridx = 2;
        c.fill = 0;
        c.weightx = 0.0;
        gb.setConstraints(this.ptext2, c);
        this.add(this.ptext2);
    }

    public void setDimension(Dimension d) {
        this.setFieldWidth((int)d.getWidth());
        this.setFieldHeight((int)d.getHeight());
    }

    public Dimension getDimension() {
        return new Dimension(this.getFieldWidth(), this.getFieldHeight());
    }

    private class DimensionQueryField
    extends JTextField
    implements FocusListener {
        private DimensionQueryField(String text, int columns) {
            super(text, columns);
            this.addFocusListener(this);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.fireActionPerformed();
        }
    }
}

