/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader.netmap;

import com.bbn.openmap.graphicLoader.netmap.NetMapEvent;
import com.bbn.openmap.graphicLoader.netmap.NetMapListener;
import com.bbn.openmap.util.Debug;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class NetMapListenerSupport
implements Serializable {
    private transient Vector listeners;
    private transient Object source;

    public NetMapListenerSupport() {
        this(null);
    }

    public NetMapListenerSupport(Object aSource) {
        this.source = aSource;
    }

    public synchronized void setSource(Object aSource) {
        this.source = aSource;
    }

    public synchronized Object getSource() {
        return this.source;
    }

    public synchronized void addNetMapListener(NetMapListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public synchronized void removeNetMapListener(NetMapListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(l);
    }

    public synchronized Vector getListeners() {
        if (this.listeners == null) {
            return null;
        }
        return (Vector)this.listeners.clone();
    }

    public void clearNetMapListeners() {
        this.listeners.clear();
    }

    public void fireNetMapEvent(Properties eventProperties) {
        Object theSource = this.getSource();
        Vector targets = this.getListeners();
        if (this.listeners == null) {
            return;
        }
        int nTargets = targets.size();
        if (nTargets == 0) {
            return;
        }
        NetMapEvent evt = new NetMapEvent(theSource, eventProperties);
        for (int i = 0; i < nTargets; ++i) {
            NetMapListener target = (NetMapListener)targets.elementAt(i);
            if (Debug.debugging("mapbean")) {
                Debug.output("NetMapListenerSupport.fireNetMapEvent(): target is: " + target);
            }
            target.catchEvent(evt);
        }
    }
}

