/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjectionFactory;
import java.util.Properties;

public class ProjectionChangeVetoException
extends RuntimeException {
    protected Properties parameters;
    public static final String CENTER = "center";
    public static final String SCALE = "scale";
    public static final String PROJECTION_TYPE = "projType";

    public ProjectionChangeVetoException() {
    }

    public ProjectionChangeVetoException(String message) {
        super(message);
    }

    public ProjectionChangeVetoException(String message, Class projectionType, LatLonPoint center, Number scale) {
        super(message);
        this.parameters = new Properties();
        if (projectionType != null) {
            this.parameters.put(PROJECTION_TYPE, projectionType);
        }
        if (center != null) {
            this.parameters.put(CENTER, center);
        }
        if (scale != null) {
            this.parameters.put(SCALE, scale);
        }
    }

    public ProjectionChangeVetoException(String message, Properties suggestedChanges) {
        this.parameters = suggestedChanges;
    }

    public Object getSuggested(String parameter) {
        return this.parameters.get(parameter);
    }

    public void removeSuggested(String parameter) {
        this.parameters.remove(parameter);
    }

    public void updateWithParameters(MapBean mapBean) {
        Proj projection = (Proj)mapBean.getProjection();
        Object suggested = this.getSuggested(PROJECTION_TYPE);
        if (suggested instanceof Class && suggested != projection.getClass()) {
            LatLonPoint center = projection.getCenter();
            projection = (Proj)ProjectionFactory.makeProjection((Class)suggested, center.getLatitude(), center.getLongitude(), projection.getScale(), projection.getWidth(), projection.getHeight());
        }
        if ((suggested = this.getSuggested(CENTER)) instanceof LatLonPoint) {
            projection.setCenter((LatLonPoint)suggested);
        }
        if ((suggested = this.getSuggested(SCALE)) instanceof Number) {
            projection.setScale(((Number)suggested).floatValue());
        }
        mapBean.setProjection(projection);
    }

    public String toString() {
        String message = this.getMessage();
        if (message == null) {
            message = "[no message]";
        }
        return "ProjectionChangeVetoException: " + message + ", suggested parameters: " + this.parameters;
    }
}

