/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape.output;

import com.bbn.openmap.dataAccess.shape.DbfFile;
import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.output.LittleEndianOutputStream;
import com.bbn.openmap.io.FormatException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

public class DbfOutputStream {
    private LittleEndianOutputStream _leos;

    public DbfOutputStream(OutputStream os) {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        this._leos = new LittleEndianOutputStream(bos);
    }

    public void writeModel(DbfTableModel model) throws IOException {
        int rowCount = model.getRowCount();
        short headerLength = this.calcHeaderLength(model);
        short recordLength = this.calcRecordLength(model);
        this.writeHeader(rowCount, headerLength, recordLength);
        this.writeFieldDescriptors(model);
        this.writeRecords(model);
        this.close();
    }

    public short calcRecordLength(DbfTableModel model) {
        int length = 0;
        int columnCount = model.getColumnCount();
        for (int i = 0; i <= columnCount - 1; ++i) {
            length += model.getLength(i);
        }
        Integer integer = new Integer(++length);
        return integer.shortValue();
    }

    public short calcHeaderLength(DbfTableModel model) {
        int length = 0;
        length += model.getColumnCount() * 32;
        length += 32;
        Integer integer = new Integer(++length);
        return integer.shortValue();
    }

    private void writeHeader(int rowCount, short headerLength, short recordLength) throws IOException {
        this._leos.writeByte(3);
        this._leos.writeByte(96);
        this._leos.writeByte(4);
        this._leos.writeByte(30);
        this._leos.writeLEInt(rowCount);
        this._leos.writeLEShort(headerLength);
        this._leos.writeLEShort(recordLength);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
    }

    private void writeFieldDescriptors(DbfTableModel model) throws IOException {
        int columnCount = model.getColumnCount();
        for (int i = 0; i <= columnCount - 1; ++i) {
            String name = model.getColumnName(i);
            int length = model.getLength(i);
            byte decimalCount = model.getDecimalCount(i);
            byte type = model.getType(i);
            this.writeFieldDescriptor(name, type, length, decimalCount);
        }
        this._leos.writeByte(13);
    }

    private void writeFieldDescriptor(String name, byte type, int length, byte decimalPlaces) throws IOException {
        this._leos.writeString(name, 11);
        this._leos.writeByte(type);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(length);
        this._leos.writeByte(decimalPlaces);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
        this._leos.writeByte(0);
    }

    protected void writeDbfFileRecords(DbfFile model) throws IOException {
        NumberFormat df = NumberFormat.getNumberInstance(Locale.ENGLISH);
        int rowCount = model.getRowCount();
        int columnCount = model.getColumnCount();
        for (int r = 0; r <= rowCount - 1; ++r) {
            try {
                List record = model.getRecordData(r);
                this._leos.writeByte(32);
                for (int c = 0; c <= columnCount - 1; ++c) {
                    Object obj;
                    byte type = model.getType(c);
                    String value = null;
                    value = type == 78 ? ((obj = record.get(c)) instanceof Double ? "" + df.format((Double)obj) : (obj != null ? obj.toString() : "")) : (String)record.get(c);
                    int length = model.getLength(c);
                    this._leos.writeString(value, length);
                }
                continue;
            }
            catch (FormatException fe) {
                // empty catch block
            }
        }
    }

    public void writeRecords(DbfTableModel model) throws IOException {
        if (model instanceof DbfFile) {
            this.writeDbfFileRecords((DbfFile)model);
            return;
        }
        NumberFormat df = NumberFormat.getNumberInstance(Locale.ENGLISH);
        int rowCount = model.getRowCount();
        int columnCount = model.getColumnCount();
        for (int r = 0; r <= rowCount - 1; ++r) {
            this._leos.writeByte(32);
            for (int c = 0; c <= columnCount - 1; ++c) {
                Object obj;
                byte type = model.getType(c);
                String value = null;
                value = type == 78 ? ((obj = model.getValueAt(r, c)) instanceof Double ? "" + df.format((Double)obj) : (obj != null ? obj.toString() : "")) : (String)model.getValueAt(r, c);
                int length = model.getLength(c);
                this._leos.writeString(value, length);
            }
        }
    }

    public void close() throws IOException {
        this._leos.writeByte(26);
        this._leos.flush();
        this._leos.close();
    }
}

