/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.dataAccess.shape.DbfFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class DbfHandler
extends OMComponent {
    protected DbfFile dbf;
    protected List rules = new Vector();
    protected DrawingAttributes defaultDA = new DrawingAttributes();
    public static final String RuleListProperty = "rules";
    public static final String RuleKeyColumnProperty = "key";
    public static final String RuleOperatorProperty = "op";
    public static final String RuleValueProperty = "val";
    public static final String RuleActionRender = "render";
    public static final String RuleActionTooltip = "tooltip";
    public static final String RuleActionInfoline = "infoline";
    public static final String RuleActionLabel = "label";
    public static final String RuleActionMinScale = "minScale";
    public static final String RuleActionMaxScale = "maxScale";
    protected String lastLabel;

    protected DbfHandler() {
    }

    public DbfHandler(String dbfFilePath) throws IOException, FormatException {
        this();
        BinaryFile bf = new BinaryFile(dbfFilePath);
        this.dbf = new DbfFile(bf);
    }

    public DbfHandler(BinaryFile bf) throws IOException, FormatException {
        this();
        this.dbf = new DbfFile(bf);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.defaultDA.setProperties(prefix, props);
        String rulesString = props.getProperty(prefix + RuleListProperty);
        Vector keysV = PropUtils.parseSpacedMarkers(rulesString);
        Iterator it = keysV.iterator();
        while (it.hasNext()) {
            String ruleMarker = (String)it.next();
            Rule rule = new Rule(this.dbf);
            rule.setProperties(prefix + ruleMarker, props);
            this.rules.add(rule);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        this.defaultDA.getProperties(props);
        StringBuffer ruleList = new StringBuffer();
        int createdRuleNum = 1;
        Iterator it = this.getRuleIterator();
        while (it.hasNext()) {
            Rule rule = (Rule)it.next();
            String rulePrefix = rule.getPropertyPrefix();
            if (rulePrefix == null) {
                rulePrefix = "createdRulePrefix" + createdRuleNum++;
                rule.setPropertyPrefix(prefix + rulePrefix);
            }
            if (rulePrefix.startsWith(prefix) && (rulePrefix = rulePrefix.substring(prefix.length())).startsWith(".")) {
                rulePrefix = rulePrefix.substring(1);
            }
            ruleList.append(rulePrefix + " ");
            rule.getProperties(props);
        }
        if (ruleList.length() > 0) {
            props.put(prefix + RuleListProperty, ruleList.toString());
        }
        return props;
    }

    public void addRule(Rule rule) {
        if (rule != null) {
            this.rules.add(rule);
        }
    }

    public boolean removeRule(Rule rule) {
        if (rule != null) {
            return this.rules.remove(rule);
        }
        return false;
    }

    public void clearRules() {
        this.rules.clear();
    }

    public Iterator getRuleIterator() {
        return this.rules.iterator();
    }

    public OMGraphic evaluate(OMGraphic omg, OMGraphicList labelList, Projection proj) {
        Integer index = (Integer)omg.getAttribute("SHAPE_INDEX_ATTRIBUTE");
        return this.evaluate(index - 1, omg, labelList, proj);
    }

    public OMGraphic evaluate(int index, OMGraphic omg, OMGraphicList labelList, Projection proj) {
        if (this.rules == null || this.rules.size() == 0) {
            return omg;
        }
        try {
            List record = this.dbf.getRecordData(index);
            Iterator it = this.rules.iterator();
            while (it.hasNext()) {
                Object recVal;
                Rule rule = (Rule)it.next();
                if (!rule.evaluate(recVal = record.get(rule.keyIndex))) continue;
                float scale = proj.getScale();
                if (scale < rule.displayMinScale || scale > rule.displayMaxScale) {
                    return null;
                }
                if (rule.infolineIndicies != null) {
                    omg.putAttribute("Information Line", this.getContentFromIndicies(rule.infolineIndicies, record));
                }
                if (rule.tooltipIndicies != null) {
                    omg.putAttribute("Tooltip", this.getContentFromIndicies(rule.tooltipIndicies, record));
                }
                if (rule.labelIndicies != null && scale >= rule.labelMinScale && scale <= rule.labelMaxScale) {
                    String curLabel = this.getContentFromIndicies(rule.labelIndicies, record);
                    if (this.lastLabel == null || this.lastLabel != null && !this.lastLabel.equalsIgnoreCase(curLabel)) {
                        OMTextLabeler label = new OMTextLabeler(curLabel, 1);
                        omg.putAttribute("Label", label);
                        labelList.add(label);
                    }
                    this.lastLabel = curLabel;
                }
                if (rule.da != null) {
                    rule.da.setTo(omg);
                }
                break;
            }
        }
        catch (IOException ioe) {
        }
        catch (FormatException fe) {
            // empty catch block
        }
        return omg;
    }

    public String getContentFromIndicies(int[] indicies, List record) {
        int numIndicies = indicies.length;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < numIndicies; ++i) {
            int val = indicies[i];
            if (val == -1) continue;
            buf.append((String)record.get(val) + " ");
        }
        return buf.toString().trim();
    }

    public static abstract class Op {
        protected String description;
        protected String propertyNotation;
        public static final Op EQUALS = new Op("equals", "equals"){

            public boolean compare(int kvcr) {
                return kvcr == 0;
            }
        };
        public static final Op LESS_THAN = new Op("less than", "lt"){

            public boolean compare(int kvcr) {
                return kvcr > 0;
            }
        };
        public static final Op LESS_THAN_EQUALS = new Op("less than or equals", "lte"){

            public boolean compare(int kvcr) {
                return kvcr == 0 || kvcr > 0;
            }
        };
        public static final Op GREATER_THAN = new Op("greater than", "gt"){

            public boolean compare(int kvcr) {
                return kvcr < 0;
            }
        };
        public static final Op GREATER_THAN_EQUALS = new Op("greater than or equals", "gte"){

            public boolean compare(int kvcr) {
                return kvcr == 0 || kvcr < 0;
            }
        };
        public static final Op NOT_EQUALS = new Op("not equals", "ne"){

            public boolean compare(int kvcr) {
                return kvcr != 0;
            }
        };
        public static final Op NONE = new Op("no-op", "noop"){

            public boolean compare(int kvcr) {
                return false;
            }
        };
        public static final Op ALL = new Op("all", "all"){

            public boolean compare(int kvcr) {
                return true;
            }
        };
        public static final Op STARTS_WITH = new Op("starts with", "starts"){

            public boolean compare(int kvcr) {
                return kvcr == 0;
            }

            public boolean evaluate(Object key, Object val) {
                return val.toString().startsWith(key.toString());
            }
        };
        public static final Op ENDS_WITH = new Op("ends with", "ends"){

            public boolean compare(int kvcr) {
                return kvcr == 0;
            }

            public boolean evaluate(Object key, Object val) {
                return val.toString().endsWith(key.toString());
            }
        };
        public static Op[] POSSIBLES = new Op[]{EQUALS, GREATER_THAN, GREATER_THAN_EQUALS, LESS_THAN, LESS_THAN_EQUALS, NOT_EQUALS, NONE, ALL, STARTS_WITH, ENDS_WITH};

        public Op(String desc, String propNotation) {
            this.description = desc;
            this.propertyNotation = propNotation;
        }

        public boolean evaluate(Object key, Object val) {
            int compare = 0;
            if (key == null) {
                return true;
            }
            if (val instanceof String) {
                compare = ((String)key).compareTo(val.toString());
            } else if (val instanceof Double) {
                if (key instanceof String) {
                    DecimalFormat df = new DecimalFormat();
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.ENGLISH);
                    df.setDecimalFormatSymbols(dfs);
                    try {
                        key = new Double(df.parse((String)key).doubleValue());
                    }
                    catch (ParseException pe) {
                        // empty catch block
                    }
                }
                compare = ((Double)key).compareTo((Double)val);
            }
            return this.compare(compare);
        }

        public abstract boolean compare(int var1);

        public static Op resolve(String opString) {
            if (opString == null) {
                return null;
            }
            for (int i = 0; i < POSSIBLES.length; ++i) {
                Op cur = POSSIBLES[i];
                if (!cur.propertyNotation.equalsIgnoreCase(opString)) continue;
                return cur;
            }
            return null;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPropertyNotation() {
            return this.propertyNotation;
        }
    }

    public class Rule
    extends OMComponent {
        protected DbfFile dbf;
        protected int keyIndex = -1;
        protected Object val;
        protected Op op = Op.NONE;
        protected DrawingAttributes da;
        protected int[] tooltipIndicies;
        protected int[] infolineIndicies;
        protected int[] labelIndicies;
        protected float displayMinScale = Float.MIN_VALUE;
        protected float displayMaxScale = Float.MAX_VALUE;
        protected float labelMinScale = Float.MIN_VALUE;
        protected float labelMaxScale = Float.MAX_VALUE;

        public Rule(DbfFile dbfFile) {
            this.dbf = dbfFile;
        }

        public void setProperties(String prefix, Properties props) {
            String newVal;
            super.setProperties(prefix, props);
            prefix = PropUtils.getScopedPropertyPrefix(prefix);
            String key = props.getProperty(prefix + DbfHandler.RuleKeyColumnProperty);
            this.keyIndex = this.dbf.getColumnIndexForName(key);
            Op op = Op.resolve(props.getProperty(prefix + DbfHandler.RuleOperatorProperty));
            if (op != null) {
                this.op = op;
            }
            if ((newVal = props.getProperty(prefix + DbfHandler.RuleValueProperty)) != null) {
                this.val = newVal;
            }
            if (key == null) {
                Debug.output("No key for rule (" + prefix + ") found in properties.");
            }
            this.displayMinScale = PropUtils.floatFromProperties(props, prefix + DbfHandler.RuleActionRender + "." + DbfHandler.RuleActionMinScale, this.displayMinScale);
            this.displayMaxScale = PropUtils.floatFromProperties(props, prefix + DbfHandler.RuleActionRender + "." + DbfHandler.RuleActionMaxScale, this.displayMaxScale);
            this.labelMinScale = PropUtils.floatFromProperties(props, prefix + DbfHandler.RuleActionLabel + "." + DbfHandler.RuleActionMinScale, this.labelMinScale);
            this.labelMaxScale = PropUtils.floatFromProperties(props, prefix + DbfHandler.RuleActionLabel + "." + DbfHandler.RuleActionMaxScale, this.labelMaxScale);
            this.tooltipIndicies = this.getIndicies(prefix + DbfHandler.RuleActionTooltip, props);
            this.infolineIndicies = this.getIndicies(prefix + DbfHandler.RuleActionInfoline, props);
            this.labelIndicies = this.getIndicies(prefix + DbfHandler.RuleActionLabel, props);
            this.da = null;
            boolean renderProperties = PropUtils.booleanFromProperties(props, prefix + DbfHandler.RuleActionRender, false);
            if (renderProperties) {
                this.da = new DrawingAttributes();
                this.da.setProperties(prefix, props);
            }
        }

        public Properties getProperties(Properties props) {
            props = super.getProperties(props);
            if (this.dbf == null) {
                return props;
            }
            String prefix = PropUtils.getScopedPropertyPrefix(this);
            props.put(prefix + DbfHandler.RuleKeyColumnProperty, PropUtils.unnull(this.dbf.getColumnName(this.keyIndex)));
            if (this.op != null) {
                props.put(prefix + DbfHandler.RuleOperatorProperty, this.op.getPropertyNotation());
            }
            if (this.val != null) {
                props.put(prefix + DbfHandler.RuleValueProperty, PropUtils.unnull(this.val.toString()));
            }
            if (this.displayMinScale != Float.MIN_VALUE) {
                props.put(prefix + DbfHandler.RuleActionRender + "." + DbfHandler.RuleActionMinScale, Float.toString(this.displayMinScale));
            }
            if (this.displayMaxScale != Float.MAX_VALUE) {
                props.put(prefix + DbfHandler.RuleActionRender + "." + DbfHandler.RuleActionMaxScale, Float.toString(this.displayMaxScale));
            }
            if (this.labelMinScale != Float.MIN_VALUE) {
                props.put(prefix + DbfHandler.RuleActionLabel + "." + DbfHandler.RuleActionMinScale, Float.toString(this.labelMinScale));
            }
            if (this.labelMaxScale != Float.MAX_VALUE) {
                props.put(prefix + DbfHandler.RuleActionLabel + "." + DbfHandler.RuleActionMaxScale, Float.toString(this.labelMaxScale));
            }
            if (this.tooltipIndicies != null && this.tooltipIndicies.length > 0) {
                props.put(prefix + DbfHandler.RuleActionTooltip, this.getColumnNamesFromIndicies(this.tooltipIndicies));
            }
            if (this.infolineIndicies != null && this.infolineIndicies.length > 0) {
                props.put(prefix + DbfHandler.RuleActionInfoline, this.getColumnNamesFromIndicies(this.infolineIndicies));
            }
            if (this.labelIndicies != null && this.labelIndicies.length > 0) {
                props.put(prefix + DbfHandler.RuleActionLabel, this.getColumnNamesFromIndicies(this.labelIndicies));
            }
            if (this.da != null) {
                props.put(prefix + DbfHandler.RuleActionRender, Boolean.toString(true));
                this.da.getProperties(props);
            }
            return props;
        }

        public boolean evaluate(Object val) {
            return this.op.evaluate(this.val, val);
        }

        public int[] getIndicies(String actionProperty, Properties props) {
            int[] indicies = null;
            String actionLabel = props.getProperty(actionProperty);
            if (actionLabel != null) {
                Vector columnNames = PropUtils.parseSpacedMarkers(actionLabel);
                int numCols = columnNames.size();
                indicies = new int[numCols];
                for (int i = 0; i < numCols; ++i) {
                    String columnName = (String)columnNames.get(i);
                    indicies[i] = this.dbf.getColumnIndexForName(columnName);
                }
            }
            return indicies;
        }

        public String getColumnNamesFromIndicies(int[] indicies) {
            StringBuffer buf = new StringBuffer();
            int numCols = indicies.length;
            for (int i = 0; i < numCols; ++i) {
                buf.append(this.dbf.getColumnName(indicies[i]) + " ");
            }
            return buf.toString().trim();
        }

        public DrawingAttributes getDa() {
            return this.da;
        }

        public void setDa(DrawingAttributes da) {
            this.da = da;
        }

        public float getDisplayMaxScale() {
            return this.displayMaxScale;
        }

        public void setDisplayMaxScale(float displayMaxScale) {
            this.displayMaxScale = displayMaxScale;
        }

        public float getDisplayMinScale() {
            return this.displayMinScale;
        }

        public void setDisplayMinScale(float displayMinScale) {
            this.displayMinScale = displayMinScale;
        }

        public int[] getInfolineIndicies() {
            return this.infolineIndicies;
        }

        public void setInfolineIndicies(int[] infolineIndicies) {
            this.infolineIndicies = infolineIndicies;
        }

        public int getKeyIndex() {
            return this.keyIndex;
        }

        public void setKeyIndex(int keyIndex) {
            this.keyIndex = keyIndex;
        }

        public int[] getLabelIndicies() {
            return this.labelIndicies;
        }

        public void setLabelIndicies(int[] labelIndicies) {
            this.labelIndicies = labelIndicies;
        }

        public float getLabelMaxScale() {
            return this.labelMaxScale;
        }

        public void setLabelMaxScale(float labelMaxScale) {
            this.labelMaxScale = labelMaxScale;
        }

        public float getLabelMinScale() {
            return this.labelMinScale;
        }

        public void setLabelMinScale(float labelMinScale) {
            this.labelMinScale = labelMinScale;
        }

        public Op getOp() {
            return this.op;
        }

        public void setOp(Op op) {
            this.op = op;
        }

        public int[] getTooltipIndicies() {
            return this.tooltipIndicies;
        }

        public void setTooltipIndicies(int[] tooltipIndicies) {
            this.tooltipIndicies = tooltipIndicies;
        }

        public Object getVal() {
            return this.val;
        }

        public void setVal(Object val) {
            this.val = val;
        }
    }
}

